/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class SpringMvcViewUtils {
    SpringMvcViewUtils() {
    }

    static boolean processControllers(Module module, Processor<? super SpringBeanPointer> processor2) {
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            SpringMVCModel springMVCModel;
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null || (springMVCModel = SpringMVCModelService.getInstance().getModel(webFacet, springFacet)) == null) continue;
            for (SpringBeanPointer pointer : springMVCModel.getControllers()) {
                if (processor2.process((Object)pointer)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean processUrls(Module module, @Nullable SpringBeanPointer controllerSpringBeanPointer, Set<RequestMethod> requestMethods, Processor<? super SpringMVCModel.Variant> processor2) {
        boolean foundMatch = false;
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            assert (springFacet != null);
            SpringMVCModel model = SpringMVCModelService.getInstance().getModel(webFacet, springFacet);
            if (model == null) continue;
            for (SpringMVCModel.Variant variant : model.getAllUrls()) {
                if (!SpringMvcViewUtils.matchesSelectedController(controllerSpringBeanPointer, variant) || !SpringMvcViewUtils.matchesRequestMethod(requestMethods, variant)) continue;
                foundMatch = true;
                if (processor2.process((Object)variant)) continue;
                return false;
            }
        }
        return !foundMatch;
    }

    private static boolean matchesSelectedController(@Nullable SpringBeanPointer controllerSpringBeanPointer, SpringMVCModel.Variant variant) {
        CommonSpringBean targetBean;
        if (controllerSpringBeanPointer == null) {
            return true;
        }
        PsiElement variantElement = variant.getPsiElementPointer().getPsiElement();
        if (variantElement != null && controllerSpringBeanPointer instanceof JamSpringBeanPointer) {
            PsiFile variantFile = variantElement.getContainingFile();
            if (variantFile.equals(controllerSpringBeanPointer.getContainingFile())) {
                return true;
            }
            PsiClass controllerClass = controllerSpringBeanPointer.getBeanClass();
            assert (controllerClass != null);
            for (PsiClass controllerSuperClass : controllerClass.getSupers()) {
                if (!variantFile.equals(controllerSuperClass.getContainingFile())) continue;
                return true;
            }
        }
        return (targetBean = SpringBeanPomTargetUtils.getSpringBean((PsiElement)variantElement)) instanceof DomSpringBean && Comparing.equal((Object)targetBean, (Object)controllerSpringBeanPointer.getSpringBean());
    }

    private static boolean matchesRequestMethod(Set<RequestMethod> requestMethods, SpringMVCModel.Variant variant) {
        if (variant.getMethod().length == 0) {
            return true;
        }
        for (RequestMethod method : variant.getMethod()) {
            if (!requestMethods.contains(method)) continue;
            return true;
        }
        return false;
    }
}

