/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.web.mvc.tiles.TilesViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TilesViewResolverFactory
extends ViewResolverFactory {
    @NotNull
    public Set<ViewResolver> handleViewResolverRegistry(String methodName, PsiMethodCallExpression methodCallExpression, SpringModel servletModel) {
        if ("tiles".equals(methodName)) {
            Set<ViewResolver> set = Collections.singleton(new TilesViewResolver("ViewResolverRegistry#tiles()", servletModel));
            if (set == null) {
                TilesViewResolverFactory.$$$reportNull$$$0(0);
            }
            return set;
        }
        Set set = super.handleViewResolverRegistry(methodName, methodCallExpression, servletModel);
        if (set == null) {
            TilesViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            TilesViewResolverFactory.$$$reportNull$$$0(2);
        }
        if (TilesViewResolverFactory.isTilesViewResolverClass(beanClass)) {
            return true;
        }
        if (!(bean instanceof SpringBean)) {
            return false;
        }
        String viewClassValue = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"viewClass");
        if (viewClassValue == null) {
            return false;
        }
        if ("org.springframework.web.servlet.view.tiles2.TilesView".equals(viewClassValue) || "org.springframework.web.servlet.view.tiles3.TilesView".equals(viewClassValue)) {
            return true;
        }
        Module module = bean.getModule();
        if (module == null) {
            return false;
        }
        return TilesViewResolverFactory.isTilesViewClass(SpringCommonUtils.findLibraryClass((Module)module, (String)viewClassValue));
    }

    public String getBeanClass() {
        return null;
    }

    @NotNull
    public Set<ViewResolver> doCreate(@Nullable CommonSpringBean bean, SpringModel model) {
        assert (bean != null);
        Set<ViewResolver> set = Collections.singleton(new TilesViewResolver("TilesViewResolver[" + bean.getBeanName() + "]", model));
        if (set == null) {
            TilesViewResolverFactory.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static boolean isTilesViewClass(PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.view.tiles2.TilesView") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.view.tiles3.TilesView");
    }

    private static boolean isTilesViewResolverClass(PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.view.tiles2.TilesViewResolver") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.view.tiles3.TilesViewResolver");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/web/mvc/tiles/TilesViewResolverFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "handleViewResolverRegistry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/web/mvc/tiles/TilesViewResolverFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

