/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.request;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.spring.web.mvc.request.RestClientRequestNavigatorBase;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.run.RunHttpRequestAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class RestClientRequestRunnerNavigator
extends RestClientRequestNavigatorBase {
    public String getId() {
        return "RestClientRequestRunnerNavigator";
    }

    @Override
    protected void performNavigation(@NotNull NavigatablePsiElement psiElement) {
        if (psiElement == null) {
            RestClientRequestRunnerNavigator.$$$reportNull$$$0(0);
        }
        HttpRequest httpRequest = null;
        if (psiElement instanceof HttpRequest) {
            httpRequest = (HttpRequest)psiElement;
        } else if (psiElement instanceof HttpRequestBlock) {
            httpRequest = ((HttpRequestBlock)psiElement).getRequest();
        }
        if (httpRequest != null) {
            HttpRequest request = httpRequest;
            Promise promise = DataManager.getInstance().getDataContextFromFocusAsync();
            promise.onSuccess(dataContext -> {
                DataContext wrapper = dataId -> {
                    if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                        return new PsiElement[]{request};
                    }
                    return dataContext.getData(dataId);
                };
                new RunHttpRequestAction.RunRequestWithDefaultEnvAction(request).actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)wrapper));
            });
            promise.onError(error -> {
                if (psiElement == null) {
                    RestClientRequestRunnerNavigator.$$$reportNull$$$0(1);
                }
                LOG.info("Failed to run HTTP request", error);
                psiElement.navigate(true);
            });
        } else {
            LOG.info("Failed to run HTTP request: request not found in " + psiElement.getContainingFile());
            psiElement.navigate(true);
        }
    }

    public Icon getIcon() {
        return AllIcons.Actions.Execute;
    }

    public String getDisplayText() {
        return SpringMvcBundle.message("request.navigator.rest.client.display.text", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiElement";
        objectArray2[1] = "com/intellij/spring/web/mvc/request/RestClientRequestRunnerNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performNavigation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$performNavigation$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

