/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.uast.ULiteralExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.semantic.SemKey;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

class MVCRequestMappingReference
extends PsiReferenceBase<PsiLanguageInjectionHost>
implements EmptyResolveMessageProvider {
    static final ULiteralExpressionPattern PATTERN = (ULiteralExpressionPattern)UastPatterns.stringLiteralExpression().annotationParams("org.springframework.web.bind.annotation.PathVariable", (ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"value", "name"}));
    private final ULiteralExpression myULiteral;

    MVCRequestMappingReference(ULiteralExpression literalExpression, PsiLanguageInjectionHost psiElement) {
        super((PsiElement)psiElement);
        this.myULiteral = literalExpression;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results;
        CommonProcessors.FindProcessor<MVCPathVariableReference> processor2 = new CommonProcessors.FindProcessor<MVCPathVariableReference>(){

            protected boolean accept(MVCPathVariableReference reference) {
                return reference.getValue().equals(MVCRequestMappingReference.this.getValue());
            }
        };
        this.processPathVariables((Processor<MVCPathVariableReference>)processor2);
        MVCPathVariableReference value = (MVCPathVariableReference)((Object)processor2.getFoundValue());
        if (value == null) {
            return null;
        }
        for (ResolveResult result : results = value.multiResolve(false)) {
            PsiElement element = result.getElement();
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        this.processPathVariables((Processor<MVCPathVariableReference>)processor2);
        SmartList variants = new SmartList();
        for (MVCPathVariableReference reference : processor2.getResults()) {
            variants.add(reference.getValue());
        }
        Object[] objectArray = ArrayUtil.toStringArray((Collection)variants);
        if (objectArray == null) {
            MVCRequestMappingReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Cannot resolve path variable ''{0}'' in request mapping" == null) {
            MVCRequestMappingReference.$$$reportNull$$$0(1);
        }
        return "Cannot resolve path variable ''{0}'' in request mapping";
    }

    private void processPathVariables(Processor<MVCPathVariableReference> processor2) {
        UMethod method = (UMethod)UastUtils.findContaining((PsiElement)this.myULiteral.getSourcePsi(), UMethod.class);
        boolean processed = MVCRequestMappingReference.processModifierListOwner(processor2, (UDeclaration)method, RequestMapping.METHOD_JAM_KEY);
        if (!processed) {
            return;
        }
        UClass clazz = UastUtils.getContainingUClass((UElement)method);
        MVCRequestMappingReference.processModifierListOwner(processor2, (UDeclaration)clazz, RequestMapping.CLASS_JAM_KEY);
    }

    private static <T extends PsiMember> boolean processModifierListOwner(Processor<MVCPathVariableReference> processor2, @Nullable UDeclaration modifierListOwner, SemKey<? extends RequestMapping<T>> jamKey) {
        if (modifierListOwner == null) {
            return false;
        }
        PsiElement jvmDeclaration = modifierListOwner.getJavaPsi();
        if (jvmDeclaration == null) {
            return false;
        }
        RequestMapping requestMapping = (RequestMapping)JamService.getJamService((Project)jvmDeclaration.getProject()).getJamElement(jamKey, jvmDeclaration);
        if (requestMapping == null) {
            return true;
        }
        for (JamStringAttributeElement<String> urlAttribute : requestMapping.getMappingUrls()) {
            PsiAnnotationMemberValue urlPsiElement = urlAttribute.getPsiElement();
            if (urlPsiElement == null) continue;
            for (PsiReference reference : MVCRequestMappingReference.getReferencesForUrlPsiElement(urlPsiElement)) {
                boolean processed;
                if (!(reference instanceof MVCPathVariableReference) || (processed = processor2.process((Object)((MVCPathVariableReference)reference)))) continue;
                return false;
            }
        }
        return true;
    }

    private static PsiReference[] getReferencesForUrlPsiElement(PsiAnnotationMemberValue element) {
        PsiReference[] initializer;
        if (element instanceof PsiLiteral) {
            return element.getReferences();
        }
        UReferenceExpression uReferenceExpression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)element, UReferenceExpression.class);
        if (uReferenceExpression != null && (initializer = MVCPathVariableReferenceProvider.createMVCPathVariableReferencesForReferenceExpression(uReferenceExpression)) != null) {
            return initializer;
        }
        return EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/web/mvc/pathVariables/MVCRequestMappingReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

