/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamStringAttributeElementPsiElementPointer;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.mvc.ViewControllerBase;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMappingUtil;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.CodeConfigurationViewControllerParser;
import com.intellij.spring.web.mvc.model.SpringMVCRequestMappings;
import com.intellij.xml.util.PsiElementPointer;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

class SpringMVCRequestMappingsCollector {
    private final Module myModule;
    private final Collection<? extends SpringModel> myModels;
    private final SpringMVCRequestMappings myRequestMappings = new SpringMVCRequestMappings();
    static final Key<CachedValue<List<Pair<RequestMapping.Method, Boolean>>>> REQUEST_MAPPINGS_CACHE = Key.create((String)"REQUEST_MAPPINGS_CACHE");

    SpringMVCRequestMappingsCollector(Module module, Collection<? extends SpringModel> models) {
        this.myModule = module;
        this.myModels = models;
    }

    SpringMVCRequestMappings collect() {
        this.doCollect();
        return this.myRequestMappings;
    }

    private void doCollect() {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable SpringModelSearchParameters.BeanClass controllerClassSearchParams = this.createSearchParams("org.springframework.web.servlet.mvc.Controller");
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable SpringModelSearchParameters.BeanClass simpleUrlMappingSearchParams = this.createSearchParams("org.springframework.web.servlet.handler.SimpleUrlHandlerMapping");
        for (SpringModel springModel : this.myModels) {
            List list = controllerClassSearchParams == null ? Collections.emptyList() : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)controllerClassSearchParams);
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                CommonSpringBean bean;
                PomTarget target;
                SpringBeanPointer springBeanPointer = (SpringBeanPointer)iterator.next();
                PsiElement element = springBeanPointer.getPsiElement();
                if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof SpringBeanPsiTarget && (bean = ((SpringBeanPsiTarget)target).getSpringBean()) instanceof ViewControllerBase) {
                    ViewControllerBase viewController = (ViewControllerBase)bean;
                    String path = viewController.getPath().getStringValue();
                    if (path == null) continue;
                    this.myRequestMappings.addUrl(path, (PsiElementPointer)springBeanPointer, new RequestMethod[0]);
                    continue;
                }
                String name = springBeanPointer.getName();
                if (name == null) continue;
                this.myRequestMappings.addUrl(name, (PsiElementPointer)springBeanPointer, new RequestMethod[0]);
            }
            List simpleMappings = simpleUrlMappingSearchParams == null ? Collections.emptyList() : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)simpleUrlMappingSearchParams);
            for (SpringBeanPointer mapping : simpleMappings) {
                SpringPropertyDefinition mappings;
                CommonSpringBean springBean = mapping.getSpringBean();
                if (!(springBean instanceof SpringBean)) continue;
                SpringPropertyDefinition urlMap = ((SpringBean)springBean).getProperty("urlMap");
                if (urlMap instanceof SpringProperty) {
                    for (SpringEntry entry : ((SpringProperty)urlMap).getMap().getEntries()) {
                        SpringBeanPointer springBeanPointer;
                        String key = (String)entry.getKeyAttr().getValue();
                        if (key == null || (springBeanPointer = entry.getRefValue()) == null) continue;
                        this.myRequestMappings.addUrl(key, (PsiElementPointer)springBeanPointer.getBasePointer(), new RequestMethod[0]);
                    }
                }
                if ((mappings = ((SpringBean)springBean).getProperty("mappings")) == null) continue;
                String value = mappings.getValueAsString();
                if (value != null) {
                    try {
                        Properties properties = new Properties();
                        properties.load(new StringReader(value));
                        for (Map.Entry entry : properties.entrySet()) {
                            Object beanName = entry.getValue();
                            SpringBeanPointer bean = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)((String)beanName));
                            if (bean == null) continue;
                            this.myRequestMappings.addUrl((String)entry.getKey(), (PsiElementPointer)bean, new RequestMethod[0]);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!(mappings instanceof SpringProperty)) continue;
                SpringProperty holder = (SpringProperty)mappings;
                for (Prop prop : holder.getProps().getProps()) {
                    String url;
                    Object controllerBean = prop.getValue();
                    if (!(controllerBean instanceof SpringBeanPointer) || (url = prop.getKey().getStringValue()) == null) continue;
                    this.myRequestMappings.addUrl(url, (PsiElementPointer)((SpringBeanPointer)controllerBean), new RequestMethod[0]);
                }
            }
        }
        JamService jamService = JamService.getJamService((Project)this.myModule.getProject());
        List list = (List)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, REQUEST_MAPPINGS_CACHE, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule, (boolean)false);
            ArrayList<Pair> allMappings = new ArrayList<Pair>();
            Collection requestMappingAnnotations = MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)this.myModule, (String)"org.springframework.web.bind.annotation.RequestMapping", (boolean)false);
            for (PsiClass anno : requestMappingAnnotations) {
                if (anno.getQualifiedName() == null) continue;
                List mappings = jamService.getJamMethodElements(RequestMapping.METHOD_JAM_KEY, anno.getQualifiedName(), scope);
                for (RequestMapping.Method mapping : mappings) {
                    PsiClass containingClass = ((PsiMethod)mapping.getPsiElement()).getContainingClass();
                    if (containingClass == null) continue;
                    SpringController springController = (SpringController)SpringController.META.getJamElement((PsiModifierListOwner)containingClass);
                    allMappings.add(Pair.create((Object)mapping, (Object)(springController != null ? 1 : 0)));
                }
            }
            return CachedValueProvider.Result.create(allMappings, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }, false);
        for (Pair pair : list) {
            RequestMapping.Method method = (RequestMapping.Method)pair.first;
            Boolean inControllerClass = (Boolean)pair.second;
            if (inControllerClass.booleanValue()) {
                this.processMapping(method.getClassLevelMapping(), method);
                continue;
            }
            PsiClass psiClass = ((PsiMethod)method.getPsiElement()).getContainingClass();
            assert (psiClass != null);
            for (PsiClass controllerClass : ClassInheritorsSearch.search((PsiClass)psiClass)) {
                if (SpringController.META.getJamElement((PsiModifierListOwner)controllerClass) == null) continue;
                RequestMapping<PsiClass> controllerClassLevelMapping = RequestMappingUtil.getClassLevelMapping(controllerClass);
                this.processMapping(controllerClassLevelMapping, method);
            }
        }
        SpringModelSearchParameters.BeanClass mvcConfigurationSupportSearchParameters = this.createSearchParams("org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport");
        if (mvcConfigurationSupportSearchParameters != null) {
            for (SpringModel springModel : this.myModels) {
                SpringBeanPointer pointer;
                CodeConfigurationViewControllerParser parser;
                boolean configured;
                Iterator iterator = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)mvcConfigurationSupportSearchParameters).iterator();
                while (iterator.hasNext() && !(configured = (parser = new CodeConfigurationViewControllerParser(springModel, pointer = (SpringBeanPointer)iterator.next(), this.myRequestMappings)).collect())) {
                }
            }
        }
    }

    private void processMapping(RequestMapping<PsiClass> classMapping, RequestMapping.Method mapping) {
        RequestMethod[] method = mapping.getMethods();
        List<JamStringAttributeElement<String>> urls = mapping.getMappingUrls();
        if (urls.isEmpty() && classMapping != null) {
            this.processRequestMapping(mapping, classMapping, null, null, method);
        }
        for (JamStringAttributeElement<String> url : urls) {
            String urlValue = url.getStringValue();
            if (classMapping != null) {
                this.processRequestMapping(mapping, classMapping, url, urlValue, method);
                continue;
            }
            if (urlValue == null) continue;
            this.myRequestMappings.addUrl(urlValue, (PsiElementPointer)new JamStringAttributeElementPsiElementPointer(url, (JamElement)mapping), method);
        }
    }

    private void processRequestMapping(RequestMapping<PsiMethod> mapping, RequestMapping<PsiClass> classMapping, @Nullable JamStringAttributeElement<String> url, @Nullable String urlValue, RequestMethod ... method) {
        for (JamStringAttributeElement<String> classUrl : classMapping.getMappingUrls()) {
            String baseUrl = classUrl.getStringValue();
            if (baseUrl != null && urlValue == null) {
                this.myRequestMappings.addUrl(baseUrl, (PsiElementPointer)new JamStringAttributeElementPsiElementPointer(classUrl, classMapping), method);
                continue;
            }
            if (baseUrl == null) {
                baseUrl = "";
            }
            StringBuilder builder = new StringBuilder(baseUrl);
            if (urlValue != null) {
                if (!baseUrl.endsWith("/") && !urlValue.startsWith("/")) {
                    builder.append('/');
                }
                builder.append(urlValue);
            }
            this.myRequestMappings.addUrl(builder.toString(), (PsiElementPointer)new JamStringAttributeElementPsiElementPointer(url, mapping), method);
        }
    }

    @Nullable
    private SpringModelSearchParameters.BeanClass createSearchParams(String fqn) {
        PsiClass psiClass = SpringCommonUtils.findLibraryClass((Module)this.myModule, (String)fqn);
        if (psiClass == null) {
            return null;
        }
        return SpringModelSearchParameters.byClass((PsiClass)psiClass).withInheritors();
    }
}

