/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.CodeConfigurationViewResolverParser;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCRequestMappings;
import com.intellij.spring.web.mvc.model.SpringMVCRequestMappingsCollector;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolverRegistry;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.PsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCModelImpl
extends SpringMVCModel {
    private static final Function<SpringMVCRequestMappings.PatternMapping, SpringMVCModel.Variant> MAPPING = patternMapping -> {
        String s = patternMapping.getUrl();
        int i = s.indexOf(42);
        if (i >= 0) {
            s = s.substring(0, i);
        }
        return new VariantImpl(patternMapping.getMapping(), s, true, patternMapping.getOriginalUrl());
    };
    private final WebFacet myWebFacet;
    private final List<? extends SpringFileSet> myFileSets;
    private final NotNullLazyValue<Collection<SpringModel>> myModels;
    private boolean myHasUnknownResolvers;
    private final NotNullLazyValue<List<ViewResolver>> myResolvers;
    private final NotNullLazyValue<SpringMVCRequestMappings> myRequestMappings;

    SpringMVCModelImpl(@NotNull WebFacet facet, List<? extends SpringFileSet> fileSets) {
        if (facet == null) {
            SpringMVCModelImpl.$$$reportNull$$$0(0);
        }
        this.myModels = new NotNullLazyValue<Collection<SpringModel>>(){
            private final NullableFunction<SpringFileSet, SpringModel> myMapping = new NullableFunction<SpringFileSet, SpringModel>(){

                public SpringModel fun(SpringFileSet springFileSet) {
                    Module module = SpringMVCModelImpl.this.myWebFacet.getModule();
                    Set allModels = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
                    for (SpringModel model : allModels) {
                        if (!springFileSet.equals((Object)model.getFileSet())) continue;
                        return model;
                    }
                    return null;
                }
            };

            @NotNull
            protected Collection<SpringModel> compute() {
                SmartList allModels = new SmartList();
                allModels.addAll(ContainerUtil.mapNotNull((Collection)SpringMVCModelImpl.this.myFileSets, this.myMapping));
                SmartList smartList = allModels;
                if (smartList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return smartList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModelImpl$1", "compute"));
            }
        };
        this.myResolvers = new NotNullLazyValue<List<ViewResolver>>(){

            @NotNull
            protected List<ViewResolver> compute() {
                Module module = SpringMVCModelImpl.this.myWebFacet.getModule();
                PsiClass viewResolver = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.ViewResolver");
                if (viewResolver == null) {
                    List<ViewResolver> list = Collections.emptyList();
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)viewResolver).withInheritors();
                SmartList resolvers = new SmartList();
                for (SpringModel model : SpringMVCModelImpl.this.getServletModels()) {
                    List pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
                    block1: for (SpringBeanPointer pointer : pointers) {
                        CommonSpringBean springBean = pointer.getSpringBean();
                        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(true));
                        if (beanClass == null) continue;
                        for (ViewResolverFactory factory : ViewResolverRegistry.getInstance().getAllFactories()) {
                            Set factoryResolvers = factory.createResolvers(springBean, beanClass, model);
                            if (factoryResolvers.isEmpty()) continue;
                            resolvers.addAll(factoryResolvers);
                            continue block1;
                        }
                        SpringMVCModelImpl.this.myHasUnknownResolvers = true;
                    }
                }
                PsiClass webMvcConfigurationSupportClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport");
                if (webMvcConfigurationSupportClass != null) {
                    SpringModelSearchParameters.BeanClass mvcConfigurationSupportSearch = SpringModelSearchParameters.byClass((PsiClass)webMvcConfigurationSupportClass).withInheritors();
                    for (SpringModel model : SpringMVCModelImpl.this.getServletModels()) {
                        SpringBeanPointer pointer;
                        CodeConfigurationViewResolverParser parser;
                        boolean configured;
                        Iterator iterator = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)mvcConfigurationSupportSearch).iterator();
                        while (iterator.hasNext() && !(configured = (parser = new CodeConfigurationViewResolverParser(model, pointer = (SpringBeanPointer)iterator.next(), (List<? super ViewResolver>)resolvers)).collect())) {
                        }
                    }
                }
                SmartList smartList = resolvers;
                if (smartList == null) {
                    2.$$$reportNull$$$0(1);
                }
                return smartList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModelImpl$2", "compute"));
            }
        };
        this.myRequestMappings = new NotNullLazyValue<SpringMVCRequestMappings>(){

            @NotNull
            protected SpringMVCRequestMappings compute() {
                Collection<SpringModel> models = SpringMVCModelImpl.this.getServletModels();
                SpringMVCRequestMappingsCollector collector = new SpringMVCRequestMappingsCollector(SpringMVCModelImpl.this.myWebFacet.getModule(), models);
                SpringMVCRequestMappings springMVCRequestMappings = collector.collect();
                if (springMVCRequestMappings == null) {
                    3.$$$reportNull$$$0(0);
                }
                return springMVCRequestMappings;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModelImpl$3", "compute"));
            }
        };
        this.myWebFacet = facet;
        this.myFileSets = fileSets;
    }

    @Nullable
    public WebDirectoryElement findWebDirectoryElement(@NotNull String path) {
        if (path == null) {
            SpringMVCModelImpl.$$$reportNull$$$0(1);
        }
        return WebUtil.getWebUtil().findWebDirectoryElement(path, this.myWebFacet);
    }

    public List<SpringMVCModel.Variant> getAllUrls() {
        SpringMVCRequestMappings requestMappings = (SpringMVCRequestMappings)this.myRequestMappings.getValue();
        ArrayList<SpringMVCModel.Variant> variants = new ArrayList<SpringMVCModel.Variant>();
        MultiMap<String, SpringMVCRequestMappings.Mapping> urls = requestMappings.getUrls();
        for (Map.Entry entry : urls.entrySet()) {
            for (SpringMVCRequestMappings.Mapping mapping : (Collection)entry.getValue()) {
                variants.add(new VariantImpl(mapping, (String)entry.getKey(), false, (String)entry.getKey()));
            }
        }
        variants.addAll(ContainerUtil.map(requestMappings.getPatterns(), MAPPING));
        return variants;
    }

    public Collection<SpringModel> getAllModels() {
        return (Collection)this.myModels.getValue();
    }

    public Collection<SpringModel> getServletModels() {
        Collection models = (Collection)this.myModels.getValue();
        return ContainerUtil.mapNotNull((Collection)models, (Function)((NullableFunction)springModel -> SpringMVCModelImpl.getServlet(springModel) == null ? null : springModel));
    }

    @Nullable
    public ServletMappingInfo getServletMappingInfo() {
        Collection models = (Collection)this.myModels.getValue();
        for (SpringModel model : models) {
            CommonServlet servlet = SpringMVCModelImpl.getServlet(model);
            if (servlet == null) continue;
            List mappings = this.myWebFacet.getWebModel().getServletMappings();
            for (CommonServletMapping mapping : mappings) {
                List mappingInfos;
                if (mapping.getServlet() != servlet || (mappingInfos = ServletMappingInfo.createMappingInfos((CommonServletMapping)mapping)).isEmpty()) continue;
                return (ServletMappingInfo)mappingInfos.get(0);
            }
        }
        return null;
    }

    public boolean processVariables(PsiElement viewContext, Processor<PsiVariable> processor2, @Nullable String nameHint) {
        PsiFile psiFile = viewContext.getContainingFile().getOriginalFile();
        List<ViewResolver> resolvers = this.getViewResolvers();
        for (SpringBeanPointer pointer : this.getControllers()) {
            ProgressManager.checkCanceled();
            PsiClass beanClass = pointer.getBeanClass();
            if (beanClass == null || beanClass instanceof PsiCompiledElement) continue;
            SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(beanClass);
            MultiMap<String, PsiVariable> controllerVariables = info.getVariables();
            if (nameHint != null && !ContainerUtil.exists((Iterable)controllerVariables.values(), variable -> nameHint.equals(variable.getName()))) continue;
            for (String view : controllerVariables.keySet()) {
                for (ViewResolver resolver : resolvers) {
                    Collection variables;
                    ProgressManager.checkCanceled();
                    PsiElement resolvedView = resolver.resolveFinalView(viewContext, view, (SpringMVCModel)this);
                    if (!psiFile.equals(resolvedView) || ContainerUtil.process((Iterable)(variables = controllerVariables.get((Object)view)), processor2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static CommonServlet getServlet(SpringModel model) {
        ServletFileSet fileSet = (ServletFileSet)model.getFileSet();
        assert (fileSet != null);
        return fileSet.getServlet();
    }

    @Nullable
    public Collection<PsiElement> resolveUrl(String url, @NotNull ServletMappingInfo info) {
        if (info == null) {
            SpringMVCModelImpl.$$$reportNull$$$0(2);
        }
        return ((SpringMVCRequestMappings)this.myRequestMappings.getValue()).resolve(url, info);
    }

    public List<ViewResolver> getViewResolvers() {
        return (List)this.myResolvers.getValue();
    }

    public boolean hasUnknownResolvers() {
        this.myResolvers.getValue();
        return this.myHasUnknownResolvers;
    }

    public List<SpringBeanPointer> getControllers() {
        Module module = this.myWebFacet.getModule();
        PsiClass servletMvcController = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.mvc.Controller");
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable SpringModelSearchParameters.BeanClass searchParameters = servletMvcController == null ? null : SpringModelSearchParameters.byClass((PsiClass)servletMvcController).withInheritors();
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        for (SpringModel springModel : this.getServletModels()) {
            if (searchParameters != null) {
                pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters));
            }
            for (SpringBeanPointer pointer : springModel.getAllCommonBeans()) {
                CommonSpringBean bean;
                if (!(pointer instanceof JamSpringBeanPointer) || !((bean = pointer.getSpringBean()) instanceof SpringController)) continue;
                pointers.add(pointer);
            }
        }
        return pointers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/web/mvc/model/SpringMVCModelImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findWebDirectoryElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VariantImpl
    implements SpringMVCModel.Variant {
        private final PsiElementPointer psiElementPointer;
        private final String lookupString;
        private final boolean isPattern;
        private final String presentation;
        private final RequestMethod[] method;

        private VariantImpl(SpringMVCRequestMappings.Mapping mapping, String lookupString, boolean pattern, String presentation) {
            this.psiElementPointer = mapping.pointer;
            this.lookupString = lookupString;
            this.isPattern = pattern;
            this.presentation = presentation;
            this.method = mapping.method;
        }

        public String toString() {
            return this.lookupString + " (" + this.presentation + ")";
        }

        public PsiElementPointer getPsiElementPointer() {
            return this.psiElementPointer;
        }

        public String getLookupString() {
            return this.lookupString;
        }

        public String getPresentation() {
            return this.presentation;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        public RequestMethod[] getMethod() {
            return this.method;
        }
    }
}

