/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DumpSpringMVCModelAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpSpringMVCModelAction.$$$reportNull$$$0(0);
        }
        boolean hasSpring = (project = (Project)e.getData(CommonDataKeys.PROJECT)) != null && SpringCommonUtils.hasSpringFacets((Project)project);
        e.getPresentation().setEnabled(hasSpring);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpSpringMVCModelAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ThrowableComputable computable = () -> (String)ReadAction.compute(() -> DumpSpringMVCModelAction.getMvcModelDump(project));
        String dump = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, "Gathering Spring MVC Models...", true, project);
        String fileName = String.format("SpringMVCModel-%s.txt", DateFormatUtil.formatDateTime((long)System.currentTimeMillis()));
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)dump);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static String getMvcModelDump(Project project) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        pi.setIndeterminate(false);
        pi.setText("Scanning Spring MVC models...");
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        StringBuilder dump = new StringBuilder();
        int processedModules = 0;
        for (Module module : modules) {
            pi.checkCanceled();
            String name = module.getName();
            dump.append(name).append(" ").append(StringUtil.repeatSymbol((char)'=', (int)Math.max(1, 119 - name.length()))).append("\n");
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) {
                dump.append("no Spring facet");
            } else {
                Collection webFacets = WebFacet.getInstances((Module)module);
                if (webFacets.isEmpty()) {
                    dump.append("no Web facets");
                } else {
                    DumpSpringMVCModelAction.dumpModule(dump, springFacet, webFacets);
                }
            }
            dump.append("\n\n");
            pi.setFraction((double)(++processedModules) / (double)modules.length);
        }
        return dump.toString();
    }

    private static void dumpModule(StringBuilder dump, SpringFacet springFacet, Collection<WebFacet> webFacets) {
        SpringFileSet fileSet;
        SpringMVCModel model = SpringMVCModelService.getInstance().getModel(webFacets.iterator().next(), springFacet);
        if (model == null) {
            dump.append("No Spring MVC model");
            return;
        }
        dump.append("Servlet models:\n");
        Collection servletModels = model.getServletModels();
        for (SpringModel servletModel : servletModels) {
            fileSet = servletModel.getFileSet();
            assert (fileSet != null) : servletModel;
            dump.append(" ").append(fileSet.getId());
        }
        dump.append("\nRoot models:\n");
        for (SpringModel allModel : model.getAllModels()) {
            if (servletModels.contains(allModel)) continue;
            fileSet = allModel.getFileSet();
            assert (fileSet != null) : allModel;
            dump.append(" ").append(fileSet.getId());
        }
        dump.append("\n\nServlet mapping:\n");
        ServletMappingInfo info = model.getServletMappingInfo();
        if (info == null) {
            dump.append("NONE\n");
        } else {
            dump.append("'").append(info.getUrlPattern()).append("' ").append(info.getServlet().getServletName().getStringValue()).append(" (in ").append(info.getServlet().getContainingFile()).append(")");
        }
        PsiClass dummyPsiElement = info == null ? null : info.getServlet().getPsiClass();
        dump.append("\n\nView Resolvers:\n");
        dump.append(" hasUnknown: ").append(model.hasUnknownResolvers());
        for (ViewResolver resolver : model.getViewResolvers()) {
            dump.append("\n ").append(resolver.toString()).append(" [").append(resolver.getID()).append("]");
            if (dummyPsiElement == null) continue;
            dump.append("\n    ").append(StringUtil.join((Collection)ContainerUtil.map((Collection)resolver.getAllViews((PsiElement)dummyPsiElement, model), element -> element.getLookupString()), (String)", "));
        }
        dump.append("\n\nURLs:");
        for (SpringMVCModel.Variant variant : model.getAllUrls()) {
            PsiElement resolve = variant.getPsiElementPointer().getPsiElement();
            PsiFile finalResolve = resolve != null ? resolve.getContainingFile() : null;
            dump.append("\n").append(variant.getLookupString()).append(" ").append(RequestMethod.getDisplay((RequestMethod[])variant.getMethod())).append(" ").append(finalResolve);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/spring/web/mvc/model/DumpSpringMVCModelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

