/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.CodeConfigurationParserBase;
import com.intellij.spring.web.mvc.model.SpringMVCRequestMappings;
import com.intellij.xml.util.PsiElementPointer;
import org.jetbrains.annotations.Nullable;

class CodeConfigurationViewControllerParser
extends CodeConfigurationParserBase {
    private final SpringMVCRequestMappings myMappings;

    protected CodeConfigurationViewControllerParser(SpringModel model, SpringBeanPointer pointer, SpringMVCRequestMappings requestMappings) {
        super(model, pointer);
        this.myMappings = requestMappings;
    }

    @Override
    protected boolean parseConfigurationClass(PsiClass configClass) {
        LightMethodBuilder addViewControllersMethod = new LightMethodBuilder(configClass.getManager(), "addViewControllers").setModifiers(new String[]{"protected"}).setMethodReturnType((PsiType)PsiType.VOID).addParameter("registry", "org.springframework.web.servlet.config.annotation.ViewControllerRegistry");
        PsiMethod configureViewResolvers = configClass.findMethodBySignature((PsiMethod)addViewControllersMethod, false);
        if (configureViewResolvers == null) {
            return false;
        }
        configureViewResolvers.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression == null) {
                    return;
                }
                PsiType qualifierType = qualifierExpression.getType();
                PsiClass qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
                if (qualifierClass == null || !"org.springframework.web.servlet.config.annotation.ViewControllerRegistry".equals(qualifierClass.getQualifiedName())) {
                    return;
                }
                String methodName = methodExpression.getReferenceName();
                if ("addViewController".equals(methodName)) {
                    CodeConfigurationViewControllerParser.this.handleAddViewController(expression);
                } else if ("addRedirectViewController".equals(methodName)) {
                    CodeConfigurationViewControllerParser.this.handleAddRedirectViewController(expression);
                } else if ("addStatusController".equals(methodName)) {
                    CodeConfigurationViewControllerParser.this.handleAddStatusController(expression);
                }
            }
        });
        return true;
    }

    private void handleAddViewController(PsiMethodCallExpression expression) {
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (arguments.length == 1) {
            this.addUrlFromFirstArgument(arguments[0]);
        }
    }

    private void handleAddRedirectViewController(PsiMethodCallExpression expression) {
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (arguments.length == 2) {
            this.addUrlFromFirstArgument(arguments[0]);
        }
    }

    private void handleAddStatusController(PsiMethodCallExpression expression) {
        PsiExpression[] arguments = expression.getArgumentList().getExpressions();
        if (arguments.length == 2) {
            this.addUrlFromFirstArgument(arguments[0]);
        }
    }

    private void addUrlFromFirstArgument(PsiExpression argument) {
        Pair urlPathExpr = StringExpressionHelper.evaluateExpression((PsiElement)argument);
        if (urlPathExpr != null) {
            this.addUrl((String)urlPathExpr.getSecond(), (PsiElement)urlPathExpr.getFirst(), new RequestMethod[0]);
        }
    }

    private void addUrl(String path, PsiElement definition, RequestMethod ... requestMethods) {
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)definition.getProject()).createSmartPsiElementPointer(definition);
        this.myMappings.addUrl(path, new PsiElementPointer(){

            @Nullable
            public PsiElement getPsiElement() {
                return pointer.getElement();
            }
        }, requestMethods);
    }
}

