/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCInitBinderInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            SpringMVCInitBinderInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringMVCInitBinderInspection.$$$reportNull$$$0(1);
        }
        if (!SpringMVCInitBinderInspection.isRelevantMethod(method)) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(containingClass);
        if (!info.isController()) {
            return null;
        }
        PsiAnnotation annotation = method.getModifierList().findAnnotation("org.springframework.web.bind.annotation.InitBinder");
        assert (annotation != null);
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)annotation, "Method annotated with @InitBinder must return void", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
    }

    private static boolean isRelevantMethod(PsiMethod method) {
        return method.hasModifierProperty("public") && !method.hasModifierProperty("static") && !PsiType.VOID.equals((Object)method.getReturnType()) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.web.bind.annotation.InitBinder", (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/web/mvc/jam/SpringMVCInitBinderInspection";
        objectArray[2] = "checkMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

