/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.spring.web.mvc.jsp.SpringModelELVariable;
import com.intellij.spring.web.mvc.views.SpringMVCViewUastReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallExpressionEx;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class SpringControllerClassInfo {
    @NonNls
    private static final String MODEL = "org.springframework.ui.Model";
    @NonNls
    private static final String MODEL_MAP = "org.springframework.ui.ModelMap";
    @NonNls
    private static final String REDIRECT_ATTRIBUTES = "org.springframework.web.servlet.mvc.support.RedirectAttributes";
    private static final UExpressionPattern<UExpression, ?> ATTRIBUTE_PATTERN = (UExpressionPattern)((UExpressionPattern)UastPatterns.uExpression().withSourcePsiCondition(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).andOr(new ElementPattern[]{UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).inClass("org.springframework.web.servlet.ModelAndView")), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).inClass("org.springframework.ui.Model")), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"addAttribute", "addObject"})).inClass("org.springframework.ui.ModelMap")), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addFlashAttribute")).inClass("org.springframework.web.servlet.mvc.support.RedirectAttributes")), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("put")).inClass("java.util.Map")), UastPatterns.uExpression().annotationParams("org.springframework.web.bind.annotation.ModelAttribute", (ElementPattern)StandardPatterns.string().oneOf(new String[]{"value", "name"})), UastPatterns.uExpression().constructorParameter(1, "org.springframework.web.servlet.ModelAndView"), UastPatterns.uExpression().constructorParameter(0, "org.springframework.ui.ModelMap"), UastPatterns.uExpression().arrayAccessParameterOf((ElementPattern)PsiJavaPatterns.psiClass().inheritorOf(false, PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"org.springframework.ui.Model", "org.springframework.ui.ModelMap"}))))});
    private static final UExpressionPattern<UExpression, ?> IMPLICIT_ATTRIBUTE_PATTERN = (UExpressionPattern)UastPatterns.uExpression().andOr(new ElementPattern[]{UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).withParameterCount(1).inClass("org.springframework.web.servlet.ModelAndView")), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).withParameterCount(1).inClass("org.springframework.ui.Model")), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"addAttribute", "addObject"})).withParameterCount(1).inClass("org.springframework.ui.ModelMap"))});
    private static final PsiExpressionPattern.Capture<PsiExpression> SESSION_ATTRIBUTES_PATTERN = (PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().annotationParam("org.springframework.web.bind.annotation.SessionAttributes", "value");
    private final boolean myController;
    private final boolean myInheritedController;
    private final boolean myHasClassLevelResponseBody;
    private final PsiClass myClass;

    public static SpringControllerClassInfo getInfo(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringControllerClassInfo.$$$reportNull$$$0(0);
        }
        return (SpringControllerClassInfo)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                SpringControllerClassInfo.$$$reportNull$$$0(6);
            }
            return CachedValueProvider.Result.createSingleDependency((Object)new SpringControllerClassInfo(psiClass), (Object)psiClass);
        });
    }

    private SpringControllerClassInfo(PsiClass psiClass) {
        this.myClass = psiClass;
        this.myInheritedController = InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.mvc.Controller");
        SpringController controller = (SpringController)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringController.META});
        this.myController = this.myInheritedController || controller != null;
        this.myHasClassLevelResponseBody = this.calcHasClassLevelResponseBody(controller);
    }

    public boolean isController() {
        return this.myController;
    }

    public boolean hasClassLevelResponseBody() {
        return this.myHasClassLevelResponseBody;
    }

    private boolean calcHasClassLevelResponseBody(@Nullable SpringController controller) {
        if (controller == null) {
            return false;
        }
        String definingAnnotation = controller.getDefiningAnnotation();
        assert (definingAnnotation != null) : this.myClass;
        if ("org.springframework.stereotype.Controller".equals(definingAnnotation)) {
            return false;
        }
        PsiClass metaControllerAnnoClass = JavaPsiFacade.getInstance((Project)this.myClass.getProject()).findClass(definingAnnotation, controller.getPsiElement().getResolveScope());
        return metaControllerAnnoClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)metaControllerAnnoClass, (String)"org.springframework.web.bind.annotation.ResponseBody", (int)0);
    }

    public boolean isRequestHandler(PsiMethod method) {
        if (!this.isController()) {
            return false;
        }
        if (!SpringControllerClassInfo.isRequestHandlerCandidate(method)) {
            return false;
        }
        if (this.myInheritedController) {
            return "handleRequest".equals(method.getName()) || "handleRequestInternal".equals(method.getName());
        }
        return SpringControllerClassInfo.hasRequestMappingJam(method);
    }

    public static boolean isRequestHandlerCandidate(PsiMethod method) {
        return (method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && !method.hasModifierProperty("static") && !method.isConstructor();
    }

    public static boolean isJamRequestHandler(PsiMethod method) {
        return SpringControllerClassInfo.isRequestHandlerCandidate(method) && SpringControllerClassInfo.hasRequestMappingJam(method);
    }

    private static boolean hasRequestMappingJam(PsiMethod method) {
        return JamService.getJamService((Project)method.getProject()).getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)method) != null;
    }

    @Nullable
    private static String getLiteralName(PsiElement element) {
        Pair pair = StringExpressionHelper.evaluateConstantExpression((PsiElement)element);
        return (String)Pair.getSecond((Pair)pair);
    }

    @Nullable
    private static String getLiteralName(UExpression element) {
        return UastUtils.evaluateString((UExpression)element);
    }

    public MultiMap<String, PsiVariable> getVariables() {
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> CachedValueProvider.Result.create(this.computeVariables(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private MultiMap<String, PsiVariable> computeVariables() {
        MultiMap result = new MultiMap();
        final HashSet<String> visitorViews = new HashSet<String>();
        SmartList visitorVariables = new SmartList();
        AbstractUastVisitor visitor = new AbstractUastVisitor((List)visitorVariables){
            private final Set<PsiMethod> visited = new HashSet<PsiMethod>();
            final /* synthetic */ List val$visitorVariables;
            {
                this.val$visitorVariables = list;
            }

            public boolean visitElement(@NotNull UElement element) {
                UMethod uMethod;
                PsiMethod method;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof ULiteralExpression || element instanceof UReferenceExpression) {
                    if (SpringMVCViewUastReferenceProvider.VIEW_PATTERN.accepts((Object)element)) {
                        String literalName = SpringControllerClassInfo.getLiteralName((UExpression)element);
                        ContainerUtil.addIfNotNull((Collection)visitorViews, (Object)literalName);
                    } else if (ATTRIBUTE_PATTERN.accepts((Object)element)) {
                        ELImplicitVariable variable = SpringControllerClassInfo.createVariable((PsiElement)SpringControllerClassInfo.this.myClass.getContainingFile(), (UExpression)element);
                        ContainerUtil.addIfNotNull((Collection)this.val$visitorVariables, (Object)variable);
                    }
                }
                if (element instanceof UExpression && IMPLICIT_ATTRIBUTE_PATTERN.accepts((Object)element)) {
                    PsiType type = ((UExpression)element).getExpressionType();
                    String variableName = SpringControllerClassInfo.getVariableName(type);
                    if (variableName != null) {
                        SpringModelELVariable elVariable = new SpringModelELVariable((PsiElement)SpringControllerClassInfo.this.myClass.getContainingFile(), variableName, type, element.getSourcePsi(), "NESTED");
                        this.val$visitorVariables.add(elVariable);
                    }
                } else if (element instanceof UCallExpression && (method = ((UCallExpression)element).resolve()) != null && !(method instanceof PsiCompiledElement) && this.visited.add(method) && InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)SpringControllerClassInfo.this.myClass, (boolean)true) && (uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class)) != null) {
                    uMethod.accept((UastVisitor)this);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/SpringControllerClassInfo$1", "visitElement"));
            }
        };
        for (PsiMethod method : this.myClass.getAllMethods()) {
            UMethod uMethod;
            if (!this.isRequestHandler(method) || (uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class)) == null) continue;
            SpringControllerClassInfo.visitMethod((MultiMap<String, PsiVariable>)result, visitorViews, (List<PsiVariable>)visitorVariables, (UastVisitor)visitor, uMethod);
            visitorViews.clear();
            visitorVariables.clear();
        }
        if (!this.myInheritedController) {
            this.processGlobalModelAttributes((MultiMap<String, PsiVariable>)result, (List<PsiVariable>)visitorVariables, (UastVisitor)visitor);
        }
        return result;
    }

    @Nullable
    public static String getVariableName(@Nullable PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            PsiClass psiClass = psiClassType.resolve();
            if (psiClass == null) {
                return null;
            }
            if (psiClassType.getParameterCount() == 1 && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.List") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Set")) {
                PsiType collectionElementType = psiClassType.getParameters()[0];
                return SpringControllerClassInfo.pluralize(SpringControllerClassInfo.getComponentName(collectionElementType));
            }
            return StringUtil.decapitalize((String)psiClass.getName());
        }
        if (psiType instanceof PsiArrayType) {
            PsiArrayType psiArrayType = (PsiArrayType)psiType;
            PsiType arrayElementType = psiArrayType.getComponentType();
            return SpringControllerClassInfo.pluralize(SpringControllerClassInfo.getComponentName(arrayElementType));
        }
        return null;
    }

    @Nullable
    private static String getComponentName(PsiType psiType) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
        return psiClass != null ? StringUtil.decapitalize((String)psiClass.getName()) : null;
    }

    @Nullable
    private static String pluralize(@Nullable String componentName) {
        return componentName == null ? null : componentName + "List";
    }

    private void processGlobalModelAttributes(MultiMap<String, PsiVariable> result, List<PsiVariable> visitorVariables, UastVisitor visitor) {
        for (PsiMethod method : this.myClass.getAllMethods()) {
            SpringMVCModelAttribute modelAttribute;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static") || method.isConstructor() || (modelAttribute = (SpringMVCModelAttribute)SpringMVCModelAttribute.METHOD_META.getJamElement((PsiModifierListOwner)method)) == null) continue;
            if (PsiType.VOID.equals((Object)method.getReturnType())) {
                visitorVariables.clear();
                UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class);
                if (uMethod != null) {
                    uMethod.accept(visitor);
                }
                for (Map.Entry entry : result.entrySet()) {
                    ((Collection)entry.getValue()).addAll(visitorVariables);
                }
                continue;
            }
            String name = modelAttribute.getName();
            if (name == null) continue;
            SpringModelELVariable var = new SpringModelELVariable((PsiElement)this.myClass, name, modelAttribute.getType(), PomService.convertToPsi((PsiTarget)modelAttribute.getPsiTarget()), "NESTED");
            for (Map.Entry entry : result.entrySet()) {
                ((Collection)entry.getValue()).add(var);
            }
        }
    }

    public MultiMap<String, PsiMethod> getViews(@Nullable PsiMethod method) {
        final MultiMap result = new MultiMap();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiLiteral || element instanceof PsiReferenceExpression) {
                    String name;
                    if (SpringMVCViewUastReferenceProvider.VIEW_PATTERN.accepts((Object)UastContextKt.toUElement((PsiElement)element, UExpression.class)) && (name = SpringControllerClassInfo.getLiteralName(element)) != null) {
                        result.putValue((Object)name, (Object)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class));
                    }
                } else {
                    super.visitElement(element);
                }
            }
        };
        if (method != null) {
            visitor.visitElement((PsiElement)method);
        } else {
            for (PsiMethod psiMethod : this.myClass.getAllMethods()) {
                visitor.visitElement((PsiElement)psiMethod);
            }
        }
        return result;
    }

    private static void visitMethod(@NotNull MultiMap<String, PsiVariable> map, @NotNull Set<String> views, @NotNull List<PsiVariable> variables, @NotNull UastVisitor visitor, @NotNull UMethod method) {
        if (map == null) {
            SpringControllerClassInfo.$$$reportNull$$$0(1);
        }
        if (views == null) {
            SpringControllerClassInfo.$$$reportNull$$$0(2);
        }
        if (variables == null) {
            SpringControllerClassInfo.$$$reportNull$$$0(3);
        }
        if (visitor == null) {
            SpringControllerClassInfo.$$$reportNull$$$0(4);
        }
        if (method == null) {
            SpringControllerClassInfo.$$$reportNull$$$0(5);
        }
        method.accept(visitor);
        for (String view : views) {
            map.putValues((Object)view, (Collection)new SmartList(variables));
        }
    }

    @Nullable
    private static ELImplicitVariable createVariable(PsiElement scope, UExpression declaration) {
        List arguments;
        int i;
        String name = SpringControllerClassInfo.getLiteralName(declaration);
        if (name == null) {
            return null;
        }
        PsiLanguageInjectionHost sourcePsi = UastLiteralUtils.getSourceInjectionHost((UExpression)declaration);
        if (sourcePsi == null) {
            sourcePsi = declaration.getSourcePsi();
        }
        if (sourcePsi == null) {
            return null;
        }
        PsiType type = null;
        UElement parent = declaration.getUastParent();
        if (parent instanceof UCallExpressionEx && (i = (arguments = ((UCallExpressionEx)parent).getValueArguments()).indexOf(declaration)) != -1 && arguments.size() > i + 1) {
            type = ((UExpression)arguments.get(i + 1)).getExpressionType();
        }
        if (type == null) {
            UMethod psiMethod;
            UParameter psiParameter = (UParameter)UastUtils.getParentOfType((UElement)declaration, UParameter.class);
            type = psiParameter != null ? psiParameter.getType() : ((psiMethod = (UMethod)UastUtils.getParentOfType((UElement)declaration, UMethod.class)) == null ? null : psiMethod.getReturnType());
        }
        return new SpringModelELVariable(scope, name, type, (PsiElement)sourcePsi, "NESTED");
    }

    public static void registerVariablesReferenceProvider(PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, ATTRIBUTE_PATTERN, (UastReferenceProvider)UastReferenceRegistrar.uastLiteralReferenceProvider((expression, host) -> {
            PsiReference[] psiReferenceArray;
            UClass psiClass = UastUtils.getContainingUClass((UElement)expression);
            if (psiClass == null) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            } else {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = PsiReferenceBase.createSelfReference((PsiElement)host, (PsiElement)SpringControllerClassInfo.createVariable((PsiElement)psiClass.getJavaPsi(), (UExpression)expression));
            }
            return psiReferenceArray;
        }), (double)0.0);
        registrar.registerReferenceProvider(SESSION_ATTRIBUTES_PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiClass psiClass;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String name = ElementManipulators.getValueText((PsiElement)element);
                SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(psiClass);
                MultiMap<String, PsiVariable> variables = info.getVariables();
                for (PsiVariable variable : variables.values()) {
                    if (!name.equals(variable.getName())) continue;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase.Immediate<PsiLiteralExpression>((PsiLiteralExpression)element, (PsiElement)variable){

                        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                            if (newElementName == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
                            return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/spring/web/mvc/SpringControllerClassInfo$3$1", "handleElementRename"));
                        }
                    }};
                    if (psiReferenceArray == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    3.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/web/mvc/SpringControllerClassInfo$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/web/mvc/SpringControllerClassInfo$3";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "views";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/web/mvc/SpringControllerClassInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getInfo$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

