/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.VdUtil;
import com.android.utils.Pair;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Preconditions;
import java.awt.geom.AffineTransform;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class SvgTree {
    private static final Logger logger = Logger.getLogger(SvgTree.class.getSimpleName());
    public static final String SVG_WIDTH = "width";
    public static final String SVG_HEIGHT = "height";
    public static final String SVG_VIEW_BOX = "viewBox";
    private float w = -1.0f;
    private float h = -1.0f;
    private final AffineTransform mRootTransform = new AffineTransform();
    private float[] viewBox;
    private float mScaleFactor = 1.0f;
    private SvgGroupNode mRoot;
    private String mFileName;
    private final ArrayList<LogMessage> mLogMessages = new ArrayList();
    private boolean mHasLeafNode;
    private boolean mHasGradient;
    private final HashMap<String, SvgNode> mIdMap = new HashMap();
    private final HashSet<SvgGroupNode> mUseGroupSet = new HashSet();
    private final Map<SvgNode, Pair<SvgGroupNode, String>> mClipPathAffectedNodes = new HashMap<SvgNode, Pair<SvgGroupNode, String>>();
    private final HashMap<String, HashSet<SvgNode>> mStyleAffectedNodes = new HashMap();
    private final HashMap<String, String> mStyleClassAttributeMap = new HashMap();

    SvgTree() {
    }

    public float getWidth() {
        return this.w;
    }

    public float getHeight() {
        return this.h;
    }

    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    public void setHasLeafNode(boolean hasLeafNode) {
        this.mHasLeafNode = hasLeafNode;
    }

    public void setHasGradient(boolean hasGradient) {
        this.mHasGradient = hasGradient;
    }

    public float[] getViewBox() {
        return this.viewBox;
    }

    public void flatten() {
        this.mRoot.flatten(new AffineTransform());
    }

    public Document parse(File f) throws Exception {
        this.mFileName = f.getName();
        return PositionXmlParser.parse((InputStream)new BufferedInputStream(new FileInputStream(f)), (boolean)false);
    }

    public void normalize() {
        this.mRootTransform.preConcatenate(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -this.viewBox[0], -this.viewBox[1]));
        this.transform(this.mRootTransform);
        logger.log(Level.FINE, "matrix=" + this.mRootTransform);
    }

    private void transform(AffineTransform rootTransform) {
        this.mRoot.transformIfNeeded(rootTransform);
    }

    public void dump(SvgGroupNode root) {
        logger.log(Level.FINE, "current file is :" + this.mFileName);
        root.dumpNode("");
    }

    public void setRoot(SvgGroupNode root) {
        this.mRoot = root;
    }

    public SvgGroupNode getRoot() {
        return this.mRoot;
    }

    public void logErrorLine(String s, Node node, SvgLogLevel level) {
        Preconditions.checkArgument((!s.isEmpty() ? 1 : 0) != 0);
        int line = node == null ? 0 : SvgTree.getPosition(node).getStartLine() + 1;
        this.mLogMessages.add(new LogMessage(level, line, s));
    }

    public String getErrorLog() {
        if (this.mLogMessages.isEmpty()) {
            return "";
        }
        Collections.sort(this.mLogMessages);
        StringBuilder result = new StringBuilder();
        result.append("In ").append(this.mFileName).append(':');
        for (LogMessage message : this.mLogMessages) {
            result.append('\n');
            result.append(message.getFormattedMessage());
        }
        return result.toString();
    }

    public boolean getHasLeafNode() {
        return this.mHasLeafNode;
    }

    public boolean getHasGradient() {
        return this.mHasGradient;
    }

    private static SourcePosition getPosition(Node node) {
        return PositionXmlParser.getPosition((Node)node);
    }

    public float getViewportWidth() {
        return this.viewBox == null ? -1.0f : this.viewBox[2];
    }

    public float getViewportHeight() {
        return this.viewBox == null ? -1.0f : this.viewBox[3];
    }

    public void parseDimension(Node nNode) {
        NamedNodeMap a = nNode.getAttributes();
        int len = a.getLength();
        SizeType widthType = SizeType.PIXEL;
        SizeType heightType = SizeType.PIXEL;
        for (int i = 0; i < len; ++i) {
            Node n = a.item(i);
            String name = n.getNodeName().trim();
            String value = n.getNodeValue().trim();
            int subStringSize = value.length();
            SizeType currentType = SizeType.PIXEL;
            String unit = value.substring(Math.max(value.length() - 2, 0));
            if (unit.matches("em|ex|px|in|cm|mm|pt|pc")) {
                subStringSize -= 2;
            } else if (value.endsWith("%")) {
                --subStringSize;
                currentType = SizeType.PERCENTAGE;
            }
            if (SVG_WIDTH.equals(name)) {
                this.w = Float.parseFloat(value.substring(0, subStringSize));
                widthType = currentType;
                continue;
            }
            if (SVG_HEIGHT.equals(name)) {
                this.h = Float.parseFloat(value.substring(0, subStringSize));
                heightType = currentType;
                continue;
            }
            if (!SVG_VIEW_BOX.equals(name)) continue;
            this.viewBox = new float[4];
            String[] strbox = value.split(" ");
            for (int j = 0; j < this.viewBox.length; ++j) {
                this.viewBox[j] = Float.parseFloat(strbox[j]);
            }
        }
        if (this.viewBox == null && this.w > 0.0f && this.h > 0.0f) {
            this.viewBox = new float[4];
            this.viewBox[2] = this.w;
            this.viewBox[3] = this.h;
        } else if ((this.w < 0.0f || this.h < 0.0f) && this.viewBox != null) {
            this.w = this.viewBox[2];
            this.h = this.viewBox[3];
        }
        if (widthType == SizeType.PERCENTAGE && this.w > 0.0f) {
            this.w = this.viewBox[2] * this.w / 100.0f;
        }
        if (heightType == SizeType.PERCENTAGE && this.h > 0.0f) {
            this.h = this.viewBox[3] * this.h / 100.0f;
        }
    }

    public void addIdToMap(String id, SvgNode svgNode) {
        this.mIdMap.put(id, svgNode);
    }

    public SvgNode getSvgNodeFromId(String id) {
        return this.mIdMap.get(id);
    }

    public void addToUseSet(SvgGroupNode useGroup) {
        this.mUseGroupSet.add(useGroup);
    }

    public Set<SvgGroupNode> getUseSet() {
        return this.mUseGroupSet;
    }

    public void addClipPathAffectedNode(SvgNode child, SvgGroupNode currentGroup, String clipPathName) {
        this.mClipPathAffectedNodes.put(child, (Pair<SvgGroupNode, String>)Pair.of((Object)currentGroup, (Object)clipPathName));
    }

    public Set<Map.Entry<SvgNode, Pair<SvgGroupNode, String>>> getClipPathAffectedNodesSet() {
        return this.mClipPathAffectedNodes.entrySet();
    }

    public void addAffectedNodeToStyleClass(String className, SvgNode child) {
        if (this.mStyleAffectedNodes.containsKey(className)) {
            this.mStyleAffectedNodes.get(className).add(child);
        } else {
            HashSet<SvgNode> styleNodesSet = new HashSet<SvgNode>();
            styleNodesSet.add(child);
            this.mStyleAffectedNodes.put(className, styleNodesSet);
        }
    }

    public void addStyleClassToTree(String className, String attributes) {
        this.mStyleClassAttributeMap.put(className, attributes);
    }

    public boolean containsStyleClass(String classname) {
        return this.mStyleClassAttributeMap.containsKey(classname);
    }

    public String getStyleClassAttr(String classname) {
        return this.mStyleClassAttributeMap.get(classname);
    }

    public Set<Map.Entry<String, HashSet<SvgNode>>> getStyleAffectedNodes() {
        return this.mStyleAffectedNodes.entrySet();
    }

    public SvgGroupNode findParent(SvgNode node) {
        return this.mRoot.findParent(node);
    }

    public DecimalFormat getCoordinateFormat() {
        float viewportWidth = this.getViewportWidth();
        float viewportHeight = this.getViewportHeight();
        return VdUtil.getCoordinateFormat(Math.max(viewportHeight, viewportWidth));
    }

    private static enum SizeType {
        PIXEL,
        PERCENTAGE;

    }

    private static class LogMessage
    implements Comparable<LogMessage> {
        final SvgLogLevel level;
        final int line;
        final String message;

        LogMessage(SvgLogLevel level, int line, String message) {
            this.level = level;
            this.line = line;
            this.message = message;
        }

        String getFormattedMessage() {
            return this.level.name() + (this.line == 0 ? "" : " @ line " + this.line) + ' ' + this.message;
        }

        @Override
        public int compareTo(@NotNull LogMessage other) {
            int cmp = this.level.compareTo(other.level);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(this.line, other.line);
            if (cmp != 0) {
                return cmp;
            }
            return this.message.compareTo(other.message);
        }
    }

    public static enum SvgLogLevel {
        ERROR,
        WARNING;

    }
}

