/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgColor;
import com.android.ide.common.vectordrawable.SvgGradientNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdPath;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

class SvgLeafNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgLeafNode.class.getSimpleName());
    private String mPathData;
    private boolean mHasFillGradient;
    private boolean mHasStrokeGradient;
    private SvgGradientNode mFillGradientNode;
    private SvgGradientNode mStrokeGradientNode;

    public SvgLeafNode(SvgTree svgTree, Node node, String nodeName) {
        super(svgTree, node, nodeName);
    }

    @Override
    public SvgLeafNode deepCopy() {
        SvgLeafNode newInstance = new SvgLeafNode(this.getTree(), this.getDocumentNode(), this.getName());
        this.copyTo(newInstance);
        return newInstance;
    }

    protected void copyTo(SvgLeafNode newInstance) {
        super.copyTo(newInstance);
        newInstance.setPathData(this.getPathData());
    }

    private void writeAttributeValues(OutputStreamWriter writer, String indent) throws IOException {
        this.parsePathOpacity();
        for (Map.Entry entry : this.mVdAttributesMap.entrySet()) {
            String key = (String)entry.getKey();
            String attribute = (String)Svg2Vector.presentationMap.get((Object)key);
            String svgValue = ((String)entry.getValue()).trim();
            String vdValue = SvgColor.colorSvg2Vd(svgValue, "#000000", this);
            if (vdValue == null) {
                if (svgValue.endsWith("px")) {
                    vdValue = svgValue.substring(0, svgValue.length() - 2).trim();
                } else {
                    if (svgValue.startsWith("url(#") && svgValue.endsWith(")")) {
                        SvgNode node;
                        vdValue = svgValue.substring(5, svgValue.length() - 1);
                        if (key.equals("fill")) {
                            node = this.getTree().getSvgNodeFromId(vdValue);
                            if (node == null) continue;
                            this.mFillGradientNode = (SvgGradientNode)node.deepCopy();
                            this.mFillGradientNode.setSvgLeafNode(this);
                            this.mFillGradientNode.setGradientUsage(SvgGradientNode.GradientUsage.FILL);
                            this.mHasFillGradient = true;
                            continue;
                        }
                        if (!key.equals("stroke") || (node = this.getTree().getSvgNodeFromId(vdValue)) == null) continue;
                        this.mStrokeGradientNode = (SvgGradientNode)node.deepCopy();
                        this.mStrokeGradientNode.setSvgLeafNode(this);
                        this.mStrokeGradientNode.setGradientUsage(SvgGradientNode.GradientUsage.STROKE);
                        this.mHasStrokeGradient = true;
                        continue;
                    }
                    vdValue = svgValue;
                }
            }
            writer.write(System.lineSeparator());
            writer.write(indent);
            writer.write("    ");
            writer.write(attribute);
            writer.write("=\"");
            writer.write(vdValue);
            writer.write("\"");
        }
    }

    private float getOpacityValueFromMap(String key) {
        float result = 1.0f;
        String opacity = (String)this.mVdAttributesMap.get(key);
        if (opacity != null) {
            try {
                result = Float.parseFloat(opacity);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Math.min(Math.max(result, 0.0f), 1.0f);
    }

    private void parsePathOpacity() {
        float opacityInFloat = this.getOpacityValueFromMap("opacity");
        if (opacityInFloat < 1.0f) {
            DecimalFormat df = new DecimalFormat("#.##");
            float fillOpacity = this.getOpacityValueFromMap("fill-opacity");
            float strokeOpacity = this.getOpacityValueFromMap("stroke-opacity");
            this.mVdAttributesMap.put("fill-opacity", df.format(fillOpacity * opacityInFloat));
            this.mVdAttributesMap.put("stroke-opacity", df.format(strokeOpacity * opacityInFloat));
        }
        this.mVdAttributesMap.remove("opacity");
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + (this.mPathData != null ? this.mPathData : " null pathData ") + (this.mName != null ? this.mName : " null name "));
    }

    public void setPathData(String pathData) {
        this.mPathData = pathData;
    }

    public String getPathData() {
        return this.mPathData;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    public boolean hasGradient() {
        return this.mHasFillGradient || this.mHasStrokeGradient;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        if (this.mPathData == null) {
            return;
        }
        VdPath.Node[] n = PathParser.parsePath(this.mPathData);
        AffineTransform finalTransform = new AffineTransform(rootTransform);
        finalTransform.concatenate(this.mStackedTransform);
        boolean needsConvertRelativeMoveAfterClose = VdPath.Node.hasRelMoveAfterClose(n);
        if (!finalTransform.isIdentity() || needsConvertRelativeMoveAfterClose) {
            VdPath.Node.transform(finalTransform, n);
        }
        DecimalFormat decimalFormat = this.mSvgTree.getCoordinateFormat();
        this.mPathData = VdPath.Node.nodeListToString(n, decimalFormat);
    }

    @Override
    public void flatten(AffineTransform transform) {
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
        if (this.mVdAttributesMap.containsKey("stroke-width") && (this.mStackedTransform.getType() & 6) != 0) {
            this.getTree().logErrorLine("Scaling of the stroke width is ignored", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer, boolean inClipPath, String indent) throws IOException {
        boolean emptyPath;
        if (inClipPath) {
            writer.write(this.mPathData);
            writer.write(" M 0,0");
            return;
        }
        String fillColor = (String)this.mVdAttributesMap.get("fill");
        String strokeColor = (String)this.mVdAttributesMap.get("stroke");
        logger.log(Level.FINE, "fill color " + fillColor);
        boolean emptyFill = fillColor != null && ("none".equals(fillColor) || "#00000000".equals(fillColor));
        boolean emptyStroke = strokeColor == null || "none".equals(strokeColor);
        boolean bl = emptyPath = this.mPathData == null;
        if (emptyPath || emptyFill && emptyStroke) {
            return;
        }
        writer.write(indent);
        writer.write("<path");
        writer.write(System.lineSeparator());
        if (!this.mVdAttributesMap.containsKey("fill") && !this.mHasFillGradient) {
            logger.log(Level.FINE, "ADDING FILL SVG_FILL_COLOR");
            writer.write(indent);
            writer.write("    ");
            writer.write("android:fillColor=\"#FF000000\"");
            writer.write(System.lineSeparator());
        }
        if (!(emptyStroke || this.mVdAttributesMap.containsKey("stroke-width") || this.mHasStrokeGradient)) {
            logger.log(Level.FINE, "Adding default stroke width");
            writer.write(indent);
            writer.write("    ");
            writer.write("android:strokeWidth=\"1\"");
            writer.write(System.lineSeparator());
        }
        writer.write(indent);
        writer.write("    ");
        writer.write("android:pathData=\"" + this.mPathData + "\"");
        this.writeAttributeValues(writer, indent);
        if (!this.hasGradient()) {
            writer.write(47);
        }
        writer.write(62);
        writer.write(System.lineSeparator());
        if (this.mHasFillGradient) {
            this.mFillGradientNode.writeXML(writer, false, indent + "  ");
        }
        if (this.mHasStrokeGradient) {
            this.mStrokeGradientNode.writeXML(writer, false, indent + "  ");
        }
        if (this.hasGradient()) {
            writer.write(indent);
            writer.write("</path>");
            writer.write(System.lineSeparator());
        }
    }
}

