/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.yaml.snakeyaml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.gradle.internal.impldep.org.yaml.snakeyaml.DumperOptions;
import org.gradle.internal.impldep.org.yaml.snakeyaml.emitter.Emitter;
import org.gradle.internal.impldep.org.yaml.snakeyaml.error.YAMLException;
import org.gradle.internal.impldep.org.yaml.snakeyaml.representer.Representer;
import org.gradle.internal.impldep.org.yaml.snakeyaml.resolver.Resolver;
import org.gradle.internal.impldep.org.yaml.snakeyaml.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dumper {
    private final Representer representer;
    private final DumperOptions options;
    private boolean attached = false;

    public Dumper(Representer representer, DumperOptions options) {
        this.representer = representer;
        representer.setDefaultFlowStyle(options.getDefaultFlowStyle());
        representer.setDefaultScalarStyle(options.getDefaultScalarStyle());
        representer.setAllowReadOnlyProperties(options.isAllowReadOnlyProperties());
        this.options = options;
    }

    public Dumper(DumperOptions options) {
        this(new Representer(), options);
    }

    public void dump(Iterator<? extends Object> iter, Writer output, Resolver resolver) {
        Serializer s = new Serializer(new Emitter(output, this.options), resolver, this.options);
        try {
            s.open();
            while (iter.hasNext()) {
                this.representer.represent(s, iter.next());
            }
            s.close();
        }
        catch (IOException e) {
            throw new YAMLException(e);
        }
    }

    void setAttached() {
        if (this.attached) {
            throw new YAMLException("Dumper cannot be shared.");
        }
        this.attached = true;
    }
}

