/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.util.graph.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyCollectionContext;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencySelector;
import org.gradle.internal.impldep.org.sonatype.aether.graph.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndDependencySelector
implements DependencySelector {
    private final Collection<DependencySelector> selectors;

    public AndDependencySelector(DependencySelector ... selectors) {
        if (selectors != null && selectors.length > 0) {
            this.selectors = new LinkedHashSet<DependencySelector>();
            Collections.addAll(this.selectors, selectors);
        } else {
            this.selectors = Collections.emptySet();
        }
    }

    public AndDependencySelector(Set<DependencySelector> selectors) {
        this.selectors = selectors != null && !selectors.isEmpty() ? selectors : Collections.emptySet();
    }

    public static DependencySelector newInstance(DependencySelector selector1, DependencySelector selector2) {
        if (selector1 == null) {
            return selector2;
        }
        if (selector2 == null) {
            return selector1;
        }
        return new AndDependencySelector(selector1, selector2);
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        for (DependencySelector selector : this.selectors) {
            if (selector.selectDependency(dependency)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        int seen = 0;
        LinkedHashSet<DependencySelector> childSelectors = null;
        for (DependencySelector selector : this.selectors) {
            DependencySelector childSelector = selector.deriveChildSelector(context);
            if (childSelectors != null) {
                childSelectors.add(childSelector);
                continue;
            }
            if (!selector.equals(childSelector)) {
                childSelectors = new LinkedHashSet<DependencySelector>();
                if (seen > 0) {
                    for (DependencySelector s : this.selectors) {
                        if (childSelectors.size() >= seen) break;
                        childSelectors.add(s);
                    }
                }
                childSelectors.add(childSelector);
                continue;
            }
            ++seen;
        }
        return childSelectors != null ? new AndDependencySelector(childSelectors) : this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AndDependencySelector that = (AndDependencySelector)obj;
        return ((Object)this.selectors).equals(that.selectors);
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + ((Object)this.selectors).hashCode();
        return hash;
    }
}

