/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.util;

import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Constants;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RawCharSequence;
import org.gradle.internal.impldep.org.eclipse.jgit.util.StringUtils;

public class RawSubStringPattern {
    private final String needleString;
    private final byte[] needle;

    public RawSubStringPattern(String patternText) {
        if (patternText.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.needleString = patternText;
        byte[] b = Constants.encode(patternText);
        this.needle = new byte[b.length];
        for (int i = 0; i < b.length; ++i) {
            this.needle[i] = RawSubStringPattern.lc(b[i]);
        }
    }

    public int match(RawCharSequence rcs) {
        int needleLen = this.needle.length;
        byte first = this.needle[0];
        byte[] text = rcs.buffer;
        int maxPos = rcs.endPtr - needleLen;
        block0: for (int matchPos = rcs.startPtr; matchPos <= maxPos; ++matchPos) {
            if (RawSubStringPattern.neq(first, text[matchPos])) {
                while (++matchPos <= maxPos && RawSubStringPattern.neq(first, text[matchPos])) {
                }
                if (matchPos > maxPos) {
                    return -1;
                }
            }
            int si = matchPos + 1;
            int j = 1;
            while (j < needleLen) {
                if (RawSubStringPattern.neq(this.needle[j], text[si])) continue block0;
                ++j;
                ++si;
            }
            return matchPos;
        }
        return -1;
    }

    private static final boolean neq(byte a, byte b) {
        return a != b && a != RawSubStringPattern.lc(b);
    }

    private static final byte lc(byte q) {
        return (byte)StringUtils.toLowerCase((char)(q & 0xFF));
    }

    public String pattern() {
        return this.needleString;
    }

    public String toString() {
        return this.pattern();
    }
}

