/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.ClassWorld;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.Entry;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.strategy.Strategy;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.strategy.StrategyFactory;

public class ClassRealm
extends URLClassLoader {
    private ClassWorld world;
    private String id;
    private SortedSet foreignImports;
    private SortedSet parentImports;
    private Strategy strategy;
    private ClassLoader parentClassLoader;

    public ClassRealm(ClassWorld world, String id, ClassLoader baseClassLoader) {
        super(new URL[0], baseClassLoader);
        this.world = world;
        this.id = id;
        this.foreignImports = new TreeSet();
        this.strategy = StrategyFactory.getStrategy(this);
    }

    public String getId() {
        return this.id;
    }

    public ClassWorld getWorld() {
        return this.world;
    }

    public void importFromParent(String packageName) {
        if (this.parentImports == null) {
            this.parentImports = new TreeSet();
        }
        this.parentImports.add(new Entry(null, packageName));
    }

    boolean isImportedFromParent(String name) {
        if (this.parentImports != null && !this.parentImports.isEmpty()) {
            Iterator iterator = this.parentImports.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (!entry.matches(name)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void importFrom(String realmId, String packageName) throws NoSuchRealmException {
        this.importFrom(this.getWorld().getRealm(realmId), packageName);
    }

    public void importFrom(ClassLoader classLoader, String packageName) {
        this.foreignImports.add(new Entry(classLoader, packageName));
    }

    public ClassLoader getImportClassLoader(String name) {
        Iterator iterator = this.foreignImports.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.matches(name)) continue;
            return entry.getClassLoader();
        }
        return null;
    }

    public Collection getImportRealms() {
        HashSet<ClassLoader> importRealms = new HashSet<ClassLoader>();
        Iterator iterator = this.foreignImports.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!(entry.getClassLoader() instanceof ClassRealm)) continue;
            importRealms.add(entry.getClassLoader());
        }
        return importRealms;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public void setParentRealm(ClassRealm realm) {
        this.parentClassLoader = realm;
    }

    public ClassRealm getParentRealm() {
        return this.parentClassLoader instanceof ClassRealm ? (ClassRealm)this.parentClassLoader : null;
    }

    public ClassRealm createChildRealm(String id) throws DuplicateRealmException {
        ClassRealm childRealm = this.getWorld().newRealm(id, null);
        childRealm.setParentRealm(this);
        return childRealm;
    }

    public void addURL(URL url) {
        String urlStr = url.toExternalForm();
        if (urlStr.startsWith("jar:") && urlStr.endsWith("!/")) {
            urlStr = urlStr.substring(4, urlStr.length() - 2);
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        super.addURL(url);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return this.strategy.loadClass(name);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    public URL findResource(String name) {
        StackTraceElement caller = new Exception().getStackTrace()[1];
        if ("java.lang.ClassLoader".equals(caller.getClassName())) {
            return this.strategy.getResource(name);
        }
        return super.findResource(name);
    }

    public Enumeration findResources(String name) throws IOException {
        StackTraceElement caller = new Exception().getStackTrace()[1];
        if ("java.lang.ClassLoader".equals(caller.getClassName())) {
            return this.strategy.getResources(name);
        }
        return super.findResources(name);
    }

    public void display() {
        this.display(System.out);
    }

    public void display(PrintStream out) {
        out.println("-----------------------------------------------------");
        for (ClassRealm cr = this; cr != null; cr = cr.getParentRealm()) {
            out.println("realm =    " + cr.getId());
            out.println("strategy = " + cr.getStrategy().getClass().getName());
            ClassRealm.showUrls(cr, out);
            out.println();
        }
        out.println("-----------------------------------------------------");
    }

    private static void showUrls(ClassRealm classRealm, PrintStream out) {
        URL[] urls = classRealm.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            out.println("urls[" + i + "] = " + urls[i]);
        }
        out.println("Number of foreign imports: " + classRealm.foreignImports.size());
        Iterator i = classRealm.foreignImports.iterator();
        while (i.hasNext()) {
            out.println("import: " + i.next());
        }
        if (classRealm.parentImports != null) {
            out.println("Number of parent imports: " + classRealm.parentImports.size());
            i = classRealm.parentImports.iterator();
            while (i.hasNext()) {
                out.println("import: " + i.next());
            }
        }
    }

    public String toString() {
        return "ClassRealm[" + this.getId() + ", parent: " + this.getParentClassLoader() + "]";
    }

    public Class loadClassFromImport(String name) {
        ClassLoader importClassLoader = this.getImportClassLoader(name);
        if (importClassLoader != null) {
            try {
                return importClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public Class loadClassFromSelf(String name) {
        Class<?> clazz;
        try {
            clazz = this.findLoadedClass(name);
            if (clazz == null) {
                clazz = super.findClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return clazz;
    }

    public Class loadClassFromParent(String name) {
        ClassLoader parent = this.getParentClassLoader();
        if (parent != null && this.isImportedFromParent(name)) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public URL loadResourceFromImport(String name) {
        ClassLoader importClassLoader = this.getImportClassLoader(name);
        if (importClassLoader != null) {
            return importClassLoader.getResource(name);
        }
        return null;
    }

    public URL loadResourceFromSelf(String name) {
        return super.findResource(name);
    }

    public URL loadResourceFromParent(String name) {
        ClassLoader parent = this.getParentClassLoader();
        if (parent != null && this.isImportedFromParent(name)) {
            return parent.getResource(name);
        }
        return null;
    }

    public Enumeration loadResourcesFromImport(String name) {
        ClassLoader importClassLoader = this.getImportClassLoader(name);
        if (importClassLoader != null) {
            try {
                return importClassLoader.getResources(name);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public Enumeration loadResourcesFromSelf(String name) {
        try {
            return super.findResources(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Enumeration loadResourcesFromParent(String name) {
        ClassLoader parent = this.getParentClassLoader();
        if (parent != null && this.isImportedFromParent(name)) {
            try {
                return parent.getResources(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

