/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.xbean.recipe;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.internal.impldep.org.apache.xbean.recipe.ConstructionException;
import org.gradle.internal.impldep.org.apache.xbean.recipe.MissingAccessorException;
import org.gradle.internal.impldep.org.apache.xbean.recipe.MissingFactoryMethodException;
import org.gradle.internal.impldep.org.apache.xbean.recipe.Option;
import org.gradle.internal.impldep.org.apache.xbean.recipe.ParameterNameLoader;
import org.gradle.internal.impldep.org.apache.xbean.recipe.ParameterNames;
import org.gradle.internal.impldep.org.apache.xbean.recipe.Recipe;
import org.gradle.internal.impldep.org.apache.xbean.recipe.RecipeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private static ParameterNameLoader parameterNamesLoader;

    private ReflectionUtil() {
    }

    public static Field findField(Class typeClass, String propertyName, Object propertyValue, Set<Option> options) {
        if (typeClass == null) {
            throw new NullPointerException("typeClass is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        if (options == null) {
            options = EnumSet.noneOf(Option.class);
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        if (propertyName.contains("/")) {
            String[] strings = propertyName.split("/");
            if (strings == null || strings.length != 2) {
                throw new IllegalArgumentException("badly formed <class>/<attribute> property name: " + propertyName);
            }
            String className = strings[0];
            propertyName = strings[1];
            boolean found = false;
            while (!typeClass.equals(Object.class) && !found) {
                if (typeClass.getName().equals(className)) {
                    found = true;
                    break;
                }
                typeClass = typeClass.getSuperclass();
            }
            if (!found) {
                throw new MissingAccessorException("Type not assignable to class: " + className, -1);
            }
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(typeClass.getDeclaredFields()));
        for (Class parent = typeClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            fields.addAll(Arrays.asList(parent.getDeclaredFields()));
        }
        boolean allowPrivate = options.contains((Object)Option.PRIVATE_PROPERTIES);
        boolean allowStatic = options.contains((Object)Option.STATIC_PROPERTIES);
        boolean caseInsesnitive = options.contains((Object)Option.CASE_INSENSITIVE_PROPERTIES);
        for (Field field : fields) {
            if (!field.getName().equals(propertyName) && (!caseInsesnitive || !field.getName().equalsIgnoreCase(propertyName))) continue;
            if (!allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is not public: " + field, matchLevel);
                continue;
            }
            if (!allowStatic && Modifier.isStatic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is static: " + field, matchLevel);
                continue;
            }
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + fieldType.getName() + ": " + field, matchLevel);
                continue;
            }
            if (!RecipeHelper.isInstance(fieldType, propertyValue) && !RecipeHelper.isConvertable(fieldType, propertyValue)) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingAccessorException((propertyValue == null ? "null" : propertyValue.getClass().getName()) + " can not be assigned or converted to " + fieldType.getName() + ": " + field, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                ReflectionUtil.setAccessible(field);
            }
            return field;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid field: ");
        buffer.append("public ").append(" ").append(propertyValue == null ? "null" : propertyValue.getClass().getName());
        buffer.append(" ").append(propertyName).append(";");
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static Method findSetter(Class typeClass, String propertyName, Object propertyValue, Set<Option> options) {
        List<Method> setters = ReflectionUtil.findAllSetters(typeClass, propertyName, propertyValue, options);
        return setters.get(0);
    }

    public static List<Method> findAllSetters(Class typeClass, String propertyName, Object propertyValue, Set<Option> options) {
        if (typeClass == null) {
            throw new NullPointerException("typeClass is null");
        }
        if (propertyName == null) {
            throw new NullPointerException("name is null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        if (options == null) {
            options = EnumSet.noneOf(Option.class);
        }
        if (propertyName.contains("/")) {
            String[] strings = propertyName.split("/");
            if (strings == null || strings.length != 2) {
                throw new IllegalArgumentException("badly formed <class>/<attribute> property name: " + propertyName);
            }
            String className = strings[0];
            propertyName = strings[1];
            boolean found = false;
            while (!typeClass.equals(Object.class) && !found) {
                if (typeClass.getName().equals(className)) {
                    found = true;
                    break;
                }
                typeClass = typeClass.getSuperclass();
            }
            if (!found) {
                throw new MissingAccessorException("Type not assignable to class: " + className, -1);
            }
        }
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.length() > 0) {
            setterName = setterName + propertyName.substring(1);
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        boolean allowPrivate = options.contains((Object)Option.PRIVATE_PROPERTIES);
        boolean allowStatic = options.contains((Object)Option.STATIC_PROPERTIES);
        boolean caseInsesnitive = options.contains((Object)Option.CASE_INSENSITIVE_PROPERTIES);
        LinkedList<Method> validSetters = new LinkedList<Method>();
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        for (Method method : methods) {
            if (!method.getName().equals(setterName) && (!caseInsesnitive || !method.getName().equalsIgnoreCase(setterName))) continue;
            if (method.getParameterTypes().length == 0) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingAccessorException("Setter takes no parameters: " + method, matchLevel);
                continue;
            }
            if (method.getParameterTypes().length > 1) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingAccessorException("Setter takes more then one parameter: " + method, matchLevel);
                continue;
            }
            if (method.getReturnType() != Void.TYPE) {
                if (matchLevel >= 2) continue;
                matchLevel = 2;
                missException = new MissingAccessorException("Setter returns a value: " + method, matchLevel);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new MissingAccessorException("Setter is abstract: " + method, matchLevel);
                continue;
            }
            if (!allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is not public: " + method, matchLevel);
                continue;
            }
            if (!allowStatic && Modifier.isStatic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is static: " + method, matchLevel);
                continue;
            }
            Class<?> methodParameterType = method.getParameterTypes()[0];
            if (methodParameterType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + methodParameterType.getName() + ": " + method, matchLevel);
                continue;
            }
            if (!RecipeHelper.isInstance(methodParameterType, propertyValue) && !RecipeHelper.isConvertable(methodParameterType, propertyValue)) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingAccessorException((propertyValue == null ? "null" : propertyValue.getClass().getName()) + " can not be assigned or converted to " + methodParameterType.getName() + ": " + method, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                ReflectionUtil.setAccessible(method);
            }
            if (RecipeHelper.isInstance(methodParameterType, propertyValue)) {
                validSetters.addFirst(method);
                continue;
            }
            validSetters.add(method);
        }
        if (!validSetters.isEmpty()) {
            return new ArrayList<Method>(new LinkedHashSet(validSetters));
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid setter method: ");
        buffer.append("public void ").append(typeClass.getName()).append(".");
        buffer.append(setterName).append("(");
        if (propertyValue == null) {
            buffer.append("null");
        } else if (propertyValue instanceof String || propertyValue instanceof Recipe) {
            buffer.append("...");
        } else {
            buffer.append(propertyValue.getClass().getName());
        }
        buffer.append(")");
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static List<Field> findAllFieldsByType(Class typeClass, Object propertyValue, Set<Option> options) {
        if (typeClass == null) {
            throw new NullPointerException("typeClass is null");
        }
        if (options == null) {
            options = EnumSet.noneOf(Option.class);
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(typeClass.getDeclaredFields()));
        for (Class parent = typeClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            fields.addAll(Arrays.asList(parent.getDeclaredFields()));
        }
        boolean allowPrivate = options.contains((Object)Option.PRIVATE_PROPERTIES);
        boolean allowStatic = options.contains((Object)Option.STATIC_PROPERTIES);
        LinkedList<Field> validFields = new LinkedList<Field>();
        for (Field field : fields) {
            Class<?> fieldType = field.getType();
            if (!RecipeHelper.isInstance(fieldType, propertyValue) && !RecipeHelper.isConvertable(fieldType, propertyValue)) continue;
            if (!allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is not public: " + field, matchLevel);
                continue;
            }
            if (!allowStatic && Modifier.isStatic(field.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Field is static: " + field, matchLevel);
                continue;
            }
            if (fieldType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + fieldType.getName() + ": " + field, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(field.getModifiers())) {
                ReflectionUtil.setAccessible(field);
            }
            if (RecipeHelper.isInstance(fieldType, propertyValue)) {
                validFields.addFirst(field);
                continue;
            }
            validFields.add(field);
        }
        if (!validFields.isEmpty()) {
            return new ArrayList<Field>(new LinkedHashSet(validFields));
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid field ");
        if (propertyValue instanceof Recipe) {
            buffer.append("for ").append(propertyValue == null ? "null" : propertyValue);
        } else {
            buffer.append("of type ").append(propertyValue == null ? "null" : propertyValue.getClass().getName());
        }
        buffer.append(" in class ").append(typeClass.getName());
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static List<Method> findAllSettersByType(Class typeClass, Object propertyValue, Set<Option> options) {
        if (typeClass == null) {
            throw new NullPointerException("typeClass is null");
        }
        if (options == null) {
            options = EnumSet.noneOf(Option.class);
        }
        int matchLevel = 0;
        MissingAccessorException missException = null;
        boolean allowPrivate = options.contains((Object)Option.PRIVATE_PROPERTIES);
        boolean allowStatic = options.contains((Object)Option.STATIC_PROPERTIES);
        LinkedList<Method> validSetters = new LinkedList<Method>();
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        for (Method method : methods) {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !RecipeHelper.isInstance(method.getParameterTypes()[0], propertyValue) && !RecipeHelper.isConvertable(method.getParameterTypes()[0], propertyValue)) continue;
            if (method.getReturnType() != Void.TYPE) {
                if (matchLevel >= 2) continue;
                matchLevel = 2;
                missException = new MissingAccessorException("Setter returns a value: " + method, matchLevel);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new MissingAccessorException("Setter is abstract: " + method, matchLevel);
                continue;
            }
            if (!allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is not public: " + method, matchLevel);
                continue;
            }
            Class<?> methodParameterType = method.getParameterTypes()[0];
            if (methodParameterType.isPrimitive() && propertyValue == null) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingAccessorException("Null can not be assigned to " + methodParameterType.getName() + ": " + method, matchLevel);
                continue;
            }
            if (!allowStatic && Modifier.isStatic(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingAccessorException("Setter is static: " + method, matchLevel);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                ReflectionUtil.setAccessible(method);
            }
            if (RecipeHelper.isInstance(methodParameterType, propertyValue)) {
                validSetters.addFirst(method);
                continue;
            }
            validSetters.add(method);
        }
        if (!validSetters.isEmpty()) {
            return new ArrayList<Method>(new LinkedHashSet(validSetters));
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid setter ");
        if (propertyValue instanceof Recipe) {
            buffer.append("for ").append(propertyValue == null ? "null" : propertyValue);
        } else {
            buffer.append("of type ").append(propertyValue == null ? "null" : propertyValue.getClass().getName());
        }
        buffer.append(" in class ").append(typeClass.getName());
        throw new MissingAccessorException(buffer.toString(), -1);
    }

    public static ConstructorFactory findConstructor(Class typeClass, List<? extends Class<?>> parameterTypes, Set<Option> options) {
        return ReflectionUtil.findConstructor(typeClass, null, parameterTypes, null, options);
    }

    public static ConstructorFactory findConstructor(Class typeClass, List<String> parameterNames, List<? extends Class<?>> parameterTypes, Set<String> availableProperties, Set<Option> options) {
        if (typeClass == null) {
            throw new NullPointerException("typeClass is null");
        }
        if (availableProperties == null) {
            availableProperties = Collections.emptySet();
        }
        if (options == null) {
            options = EnumSet.noneOf(Option.class);
        }
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new ConstructionException("Class is not public: " + typeClass.getName());
        }
        if (Modifier.isInterface(typeClass.getModifiers())) {
            throw new ConstructionException("Class is an interface: " + typeClass.getName());
        }
        if (Modifier.isAbstract(typeClass.getModifiers())) {
            throw new ConstructionException("Class is abstract: " + typeClass.getName());
        }
        if (parameterNames != null) {
            if (parameterTypes == null) {
                parameterTypes = Collections.nCopies(parameterNames.size(), null);
            }
            if (parameterNames.size() != parameterTypes.size()) {
                throw new ConstructionException("Invalid ObjectRecipe: recipe has " + parameterNames.size() + " parameter names and " + parameterTypes.size() + " parameter types");
            }
        } else if (!options.contains((Object)Option.NAMED_PARAMETERS)) {
            parameterNames = Collections.emptyList();
            parameterTypes = Collections.emptyList();
        }
        ArrayList constructors = new ArrayList(Arrays.asList(typeClass.getConstructors()));
        constructors.addAll(Arrays.asList(typeClass.getDeclaredConstructors()));
        Collections.sort(constructors, new Comparator<Constructor>(){

            @Override
            public int compare(Constructor constructor1, Constructor constructor2) {
                return constructor2.getParameterTypes().length - constructor1.getParameterTypes().length;
            }
        });
        int matchLevel = 0;
        MissingFactoryMethodException missException = null;
        boolean allowPrivate = options.contains((Object)Option.PRIVATE_CONSTRUCTOR);
        for (Constructor constructor : constructors) {
            if (parameterTypes != null) {
                if (constructor.getParameterTypes().length != parameterTypes.size()) {
                    if (matchLevel >= true) continue;
                    matchLevel = 1;
                    missException = new MissingFactoryMethodException("Constructor has " + constructor.getParameterTypes().length + " arugments " + "but expected " + parameterTypes.size() + " arguments: " + constructor);
                    continue;
                }
                if (!RecipeHelper.isAssignableFrom(parameterTypes, Arrays.asList(constructor.getParameterTypes()))) {
                    if (matchLevel >= 2) continue;
                    matchLevel = 2;
                    missException = new MissingFactoryMethodException("Constructor has signature public static " + typeClass.getName() + ReflectionUtil.toParameterList(constructor.getParameterTypes()) + " but expected signature " + "public static " + typeClass.getName() + ReflectionUtil.toParameterList(parameterTypes));
                    continue;
                }
            } else {
                parameterNames = ReflectionUtil.getParameterNames(constructor);
                if (parameterNames == null || !availableProperties.containsAll(parameterNames)) continue;
            }
            if (Modifier.isAbstract(constructor.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingFactoryMethodException("Constructor is abstract: " + constructor);
                continue;
            }
            if (!allowPrivate && !Modifier.isPublic(constructor.getModifiers())) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingFactoryMethodException("Constructor is not public: " + constructor);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(constructor.getModifiers())) {
                ReflectionUtil.setAccessible(constructor);
            }
            return new ConstructorFactory(constructor, parameterNames);
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid constructor: ");
        buffer.append("public void ").append(typeClass.getName()).append(ReflectionUtil.toParameterList(parameterTypes));
        throw new ConstructionException(buffer.toString());
    }

    public static StaticFactory findStaticFactory(Class typeClass, String factoryMethod, List<? extends Class<?>> parameterTypes, Set<Option> options) {
        return ReflectionUtil.findStaticFactory(typeClass, factoryMethod, null, parameterTypes, null, options);
    }

    public static StaticFactory findStaticFactory(Class typeClass, String factoryMethod, List<String> parameterNames, List<? extends Class<?>> parameterTypes, Set<String> allProperties, Set<Option> options) {
        if (typeClass == null) {
            throw new NullPointerException("typeClass is null");
        }
        if (factoryMethod == null) {
            throw new NullPointerException("name is null");
        }
        if (factoryMethod.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        if (allProperties == null) {
            allProperties = Collections.emptySet();
        }
        if (options == null) {
            options = EnumSet.noneOf(Option.class);
        }
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new ConstructionException("Class is not public: " + typeClass.getName());
        }
        if (Modifier.isInterface(typeClass.getModifiers())) {
            throw new ConstructionException("Class is an interface: " + typeClass.getName());
        }
        if (parameterNames != null) {
            if (parameterTypes == null) {
                parameterTypes = Collections.nCopies(parameterNames.size(), null);
            }
            if (parameterNames.size() != parameterTypes.size()) {
                throw new ConstructionException("Invalid ObjectRecipe: recipe has " + parameterNames.size() + " parameter names and " + parameterTypes.size() + " parameter types");
            }
        } else if (!options.contains((Object)Option.NAMED_PARAMETERS)) {
            parameterNames = Collections.emptyList();
            parameterTypes = Collections.emptyList();
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method method2, Method method1) {
                return method1.getParameterTypes().length - method2.getParameterTypes().length;
            }
        });
        int matchLevel = 0;
        MissingFactoryMethodException missException = null;
        boolean allowPrivate = options.contains((Object)Option.PRIVATE_FACTORY);
        boolean caseInsesnitive = options.contains((Object)Option.CASE_INSENSITIVE_FACTORY);
        for (Method method : methods) {
            if (!method.getName().equals(factoryMethod) && (!caseInsesnitive || !method.getName().equalsIgnoreCase(method.getName()))) continue;
            if (parameterTypes != null) {
                if (method.getParameterTypes().length != parameterTypes.size()) {
                    if (matchLevel >= true) continue;
                    matchLevel = 1;
                    missException = new MissingFactoryMethodException("Static factory method has " + method.getParameterTypes().length + " arugments " + "but expected " + parameterTypes.size() + " arguments: " + method);
                    continue;
                }
                if (!RecipeHelper.isAssignableFrom(parameterTypes, Arrays.asList(method.getParameterTypes()))) {
                    if (matchLevel >= 2) continue;
                    matchLevel = 2;
                    missException = new MissingFactoryMethodException("Static factory method has signature public static " + typeClass.getName() + "." + factoryMethod + ReflectionUtil.toParameterList(method.getParameterTypes()) + " but expected signature " + "public static " + typeClass.getName() + "." + factoryMethod + ReflectionUtil.toParameterList(parameterTypes));
                    continue;
                }
            } else {
                parameterNames = ReflectionUtil.getParameterNames(method);
                if (parameterNames == null || !allProperties.containsAll(parameterNames)) continue;
            }
            if (method.getReturnType() == Void.TYPE) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new MissingFactoryMethodException("Static factory method does not return a value: " + method);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingFactoryMethodException("Static factory method is abstract: " + method);
                continue;
            }
            if (!allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingFactoryMethodException("Static factory method is not public: " + method);
                continue;
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                if (matchLevel >= 6) continue;
                matchLevel = 6;
                missException = new MissingFactoryMethodException("Static factory method is not static: " + method);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                ReflectionUtil.setAccessible(method);
            }
            return new StaticFactory(method, parameterNames);
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid factory method: ");
        buffer.append("public void ").append(typeClass.getName()).append(".");
        buffer.append(factoryMethod).append(ReflectionUtil.toParameterList(parameterTypes));
        throw new MissingFactoryMethodException(buffer.toString());
    }

    public static Method findInstanceFactory(Class typeClass, String factoryMethod, Set<Option> options) {
        if (typeClass == null) {
            throw new NullPointerException("typeClass is null");
        }
        if (factoryMethod == null) {
            throw new NullPointerException("name is null");
        }
        if (factoryMethod.length() == 0) {
            throw new IllegalArgumentException("name is an empty string");
        }
        if (options == null) {
            options = EnumSet.noneOf(Option.class);
        }
        int matchLevel = 0;
        MissingFactoryMethodException missException = null;
        boolean allowPrivate = options.contains((Object)Option.PRIVATE_FACTORY);
        boolean caseInsesnitive = options.contains((Object)Option.CASE_INSENSITIVE_FACTORY);
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(typeClass.getMethods()));
        methods.addAll(Arrays.asList(typeClass.getDeclaredMethods()));
        for (Method method : methods) {
            if (!method.getName().equals(factoryMethod) && (!caseInsesnitive || !method.getName().equalsIgnoreCase(method.getName()))) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                if (matchLevel >= true) continue;
                matchLevel = 1;
                missException = new MissingFactoryMethodException("Instance factory method is static: " + method);
                continue;
            }
            if (method.getParameterTypes().length != 0) {
                if (matchLevel >= 2) continue;
                matchLevel = 2;
                missException = new MissingFactoryMethodException("Instance factory method has signature public " + typeClass.getName() + "." + factoryMethod + ReflectionUtil.toParameterList(method.getParameterTypes()) + " but expected signature " + "public " + typeClass.getName() + "." + factoryMethod + "()");
                continue;
            }
            if (method.getReturnType() == Void.TYPE) {
                if (matchLevel >= 3) continue;
                matchLevel = 3;
                missException = new MissingFactoryMethodException("Instance factory method does not return a value: " + method);
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) {
                if (matchLevel >= 4) continue;
                matchLevel = 4;
                missException = new MissingFactoryMethodException("Instance factory method is abstract: " + method);
                continue;
            }
            if (!allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                if (matchLevel >= 5) continue;
                matchLevel = 5;
                missException = new MissingFactoryMethodException("Instance factory method is not public: " + method);
                continue;
            }
            if (allowPrivate && !Modifier.isPublic(method.getModifiers())) {
                ReflectionUtil.setAccessible(method);
            }
            return method;
        }
        if (missException != null) {
            throw missException;
        }
        StringBuffer buffer = new StringBuffer("Unable to find a valid factory method: ");
        buffer.append("public void ").append(typeClass.getName()).append(".");
        buffer.append(factoryMethod).append("()");
        throw new MissingFactoryMethodException(buffer.toString());
    }

    public static List<String> getParameterNames(Constructor<?> constructor) {
        try {
            String[] parameterNames;
            Class<Annotation> constructorPropertiesClass = ClassLoader.getSystemClassLoader().loadClass("java.beans.ConstructorProperties").asSubclass(Annotation.class);
            Annotation constructorProperties = constructor.getAnnotation(constructorPropertiesClass);
            if (constructorProperties != null && (parameterNames = (String[])constructorPropertiesClass.getMethod("value", new Class[0]).invoke((Object)constructorProperties, new Object[0])) != null) {
                return Arrays.asList(parameterNames);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ParameterNames parameterNames = constructor.getAnnotation(ParameterNames.class);
        if (parameterNames != null && parameterNames.value() != null) {
            return Arrays.asList(parameterNames.value());
        }
        if (parameterNamesLoader != null) {
            return parameterNamesLoader.get(constructor);
        }
        return null;
    }

    public static List<String> getParameterNames(Method method) {
        ParameterNames parameterNames = method.getAnnotation(ParameterNames.class);
        if (parameterNames != null && parameterNames.value() != null) {
            return Arrays.asList(parameterNames.value());
        }
        if (parameterNamesLoader != null) {
            return parameterNamesLoader.get(method);
        }
        return null;
    }

    private static void setAccessible(final AccessibleObject accessibleObject) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                accessibleObject.setAccessible(true);
                return null;
            }
        });
    }

    private static String toParameterList(Class<?>[] parameterTypes) {
        return ReflectionUtil.toParameterList(parameterTypes != null ? Arrays.asList(parameterTypes) : null);
    }

    private static String toParameterList(List<? extends Class<?>> parameterTypes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        if (parameterTypes != null) {
            for (int i = 0; i < parameterTypes.size(); ++i) {
                Class<?> type = parameterTypes.get(i);
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(type.getName());
            }
        } else {
            buffer.append("...");
        }
        buffer.append(")");
        return buffer.toString();
    }

    static {
        try {
            Class<ParameterNameLoader> loaderClass = ReflectionUtil.class.getClassLoader().loadClass("org.gradle.internal.impldep.org.apache.xbean.recipe.AsmParameterNameLoader").asSubclass(ParameterNameLoader.class);
            parameterNamesLoader = loaderClass.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticFactory
    implements Factory {
        private Method staticFactory;
        private List<String> parameterNames;

        public StaticFactory(Method staticFactory, List<String> parameterNames) {
            this.staticFactory = staticFactory;
            this.parameterNames = parameterNames;
        }

        @Override
        public List<String> getParameterNames() {
            if (this.parameterNames == null) {
                throw new ConstructionException("InstanceFactory has not been initialized");
            }
            return this.parameterNames;
        }

        @Override
        public List<Type> getParameterTypes() {
            return new ArrayList<Type>(Arrays.asList(this.staticFactory.getGenericParameterTypes()));
        }

        @Override
        public Object create(Object ... parameters) throws ConstructionException {
            try {
                Object instance = this.staticFactory.invoke(null, parameters);
                return instance;
            }
            catch (Exception e) {
                InvocationTargetException invocationTargetException;
                Throwable t = e;
                if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                    t = invocationTargetException.getCause();
                }
                throw new ConstructionException("Error invoking factory method: " + this.staticFactory, t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstructorFactory
    implements Factory {
        private Constructor constructor;
        private List<String> parameterNames;

        public ConstructorFactory(Constructor constructor, List<String> parameterNames) {
            if (constructor == null) {
                throw new NullPointerException("constructor is null");
            }
            if (parameterNames == null) {
                throw new NullPointerException("parameterNames is null");
            }
            this.constructor = constructor;
            this.parameterNames = parameterNames;
        }

        @Override
        public List<String> getParameterNames() {
            return this.parameterNames;
        }

        @Override
        public List<Type> getParameterTypes() {
            return new ArrayList<Type>(Arrays.asList(this.constructor.getGenericParameterTypes()));
        }

        @Override
        public Object create(Object ... parameters) throws ConstructionException {
            try {
                Object instance = this.constructor.newInstance(parameters);
                return instance;
            }
            catch (Exception e) {
                InvocationTargetException invocationTargetException;
                Throwable t = e;
                if (e instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)e).getCause() != null) {
                    t = invocationTargetException.getCause();
                }
                throw new ConstructionException("Error invoking constructor: " + this.constructor, t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public List<String> getParameterNames();

        public List<Type> getParameterTypes();

        public Object create(Object ... var1) throws ConstructionException;
    }
}

