/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.metadata;

import java.util.Collection;
import org.gradle.internal.impldep.org.apache.maven.artifact.Artifact;
import org.gradle.internal.impldep.org.apache.maven.artifact.ArtifactScopeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactMetadata {
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String type;
    protected ArtifactScopeEnum artifactScope;
    protected String classifier;
    protected String why;
    protected Collection<ArtifactMetadata> dependencies;
    protected String uri;
    protected boolean resolved = false;
    protected boolean artifactExists = false;
    protected String artifactUri;
    private String error;

    public ArtifactMetadata(String name) {
        if (name == null) {
            return;
        }
        int ind1 = name.indexOf(58);
        int ind2 = name.lastIndexOf(58);
        if (ind1 == -1 || ind2 == -1) {
            return;
        }
        this.groupId = name.substring(0, ind1);
        if (ind1 == ind2) {
            this.artifactId = name.substring(ind1 + 1);
        } else {
            this.artifactId = name.substring(ind1 + 1, ind2);
            this.version = name.substring(ind2 + 1);
        }
    }

    public ArtifactMetadata(String groupId, String name, String version) {
        this(groupId, name, version, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type) {
        this(groupId, name, version, type, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope) {
        this(groupId, name, version, type, artifactScope, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope, String classifier) {
        this(groupId, name, version, type, artifactScope, classifier, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope, String classifier, String artifactUri) {
        this(groupId, name, version, type, artifactScope, classifier, artifactUri, null, true, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope, String classifier, String artifactUri, String why, boolean resolved, String error) {
        this.groupId = groupId;
        this.artifactId = name;
        this.version = version;
        this.type = type;
        this.artifactScope = artifactScope;
        this.classifier = classifier;
        this.artifactUri = artifactUri;
        this.why = why;
        this.resolved = resolved;
        this.error = error;
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, String scopeString, String classifier, String artifactUri, String why, boolean resolved, String error) {
        this(groupId, name, version, type, scopeString == null ? ArtifactScopeEnum.DEFAULT_SCOPE : ArtifactScopeEnum.valueOf(scopeString), classifier, artifactUri, why, resolved, error);
    }

    public ArtifactMetadata(Artifact af) {
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toDomainString() {
        return this.groupId + ":" + this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String name) {
        this.artifactId = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public String getCheckedType() {
        return this.type == null ? "jar" : this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ArtifactScopeEnum getArtifactScope() {
        return this.artifactScope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : this.artifactScope;
    }

    public void setArtifactScope(ArtifactScopeEnum artifactScope) {
        this.artifactScope = artifactScope;
    }

    public void setScope(String scope) {
        this.artifactScope = scope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : ArtifactScopeEnum.valueOf(scope);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getScope() {
        return this.getArtifactScope().getScope();
    }

    public ArtifactScopeEnum getScopeAsEnum() {
        return this.artifactScope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : this.artifactScope;
    }

    public boolean isArtifactExists() {
        return this.artifactExists;
    }

    public void setArtifactExists(boolean artifactExists) {
        this.artifactExists = artifactExists;
    }

    public Collection<ArtifactMetadata> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Collection<ArtifactMetadata> dependencies) {
        this.dependencies = dependencies;
    }

    public String getArtifactUri() {
        return this.artifactUri;
    }

    public void setArtifactUri(String artifactUri) {
        this.artifactUri = artifactUri;
    }

    public String getWhy() {
        return this.why;
    }

    public void setWhy(String why) {
        this.why = why;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error == null;
    }

    public String getDependencyConflictId() {
        return this.groupId + ":" + this.artifactId;
    }
}

