/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.legacy.resolver.transform;

import org.gradle.internal.impldep.org.apache.maven.artifact.Artifact;
import org.gradle.internal.impldep.org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.RepositoryRequest;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Versioning;
import org.gradle.internal.impldep.org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.gradle.internal.impldep.org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.gradle.internal.impldep.org.apache.maven.repository.legacy.resolver.transform.AbstractVersionTransformation;
import org.gradle.internal.impldep.org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactTransformation.class, hint="release")
public class ReleaseArtifactTransformation
extends AbstractVersionTransformation {
    public void transformForResolve(Artifact artifact, RepositoryRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        if ("RELEASE".equals(artifact.getVersion())) {
            try {
                String version = this.resolveVersion(artifact, request);
                if ("RELEASE".equals(version)) {
                    throw new ArtifactNotFoundException("Unable to determine the release version", artifact);
                }
                artifact.setBaseVersion(version);
                artifact.updateVersion(version, request.getLocalRepository());
            }
            catch (RepositoryMetadataResolutionException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, e);
            }
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) {
        ArtifactMetadata metadata = this.createMetadata(artifact);
        artifact.addMetadata(metadata);
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) {
        ArtifactMetadata metadata = this.createMetadata(artifact);
        artifact.addMetadata(metadata);
    }

    private ArtifactMetadata createMetadata(Artifact artifact) {
        Versioning versioning = new Versioning();
        versioning.updateTimestamp();
        versioning.addVersion(artifact.getVersion());
        if (artifact.isRelease()) {
            versioning.setRelease(artifact.getVersion());
        }
        return new ArtifactRepositoryMetadata(artifact, versioning);
    }

    protected String constructVersion(Versioning versioning, String baseVersion) {
        return versioning.getRelease();
    }
}

