/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesIterableVariable;
import com.intellij.thymeleaf.lang.psi.ThymesIterateExpression;
import com.intellij.thymeleaf.lang.psi.ThymesStatusVariable;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafIterateVariablesProvider
extends ThymeleafContextVariablesProvider {
    private static final Map<String, PsiType> map = ContainerUtil.newHashMap();

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(0);
        }
        HashSet<Object> variables = new HashSet<Object>();
        for (ThymesElExpression expression : ThymeleafCommonUtil.findEachExpressions(contextElement)) {
            if (!(expression instanceof ThymesIterateExpression)) continue;
            ThymesIterateExpression iterateExpression = (ThymesIterateExpression)expression;
            PsiType itType = ThymeleafIterateVariablesProvider.getIterateExpressionType(iterateExpression);
            List<ThymesElExpression> list = iterateExpression.getIterateVariables().getElExpressionList();
            for (ThymesElExpression variable : list) {
                String name;
                if (variable instanceof ThymesStatusVariable) {
                    name = variable.getText();
                    variables.add(ThymeleafIterateVariablesProvider.createStatVariable(name, variable, itType));
                    continue;
                }
                if (!(variable instanceof ThymesIterableVariable)) continue;
                name = variable.getText();
                if (itType != null) {
                    variables.add((ThymesIterableVariable)variable);
                }
                if (list.size() != 1) continue;
                variables.add(ThymeleafIterateVariablesProvider.createStatVariable(name + "Stat", variable, itType));
            }
        }
        HashSet<Object> hashSet = variables;
        if (hashSet == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    public static PsiType getIterateExpressionType(@NotNull ThymesIterateExpression iterateExpression) {
        if (iterateExpression == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(2);
        }
        return (PsiType)RecursionManager.doPreventingRecursion((Object)iterateExpression, (boolean)true, () -> {
            ThymesElExpression iteratedExpression;
            PsiType type;
            if (iterateExpression == null) {
                ThymeleafIterateVariablesProvider.$$$reportNull$$$0(9);
            }
            if ((type = (iteratedExpression = iterateExpression.getElExpression()).getType()) instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type;
                Project project = iteratedExpression.getProject();
                PsiType typeParameter = PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
                if (typeParameter == null) {
                    typeParameter = ThymeleafIterateVariablesProvider.getMapEntryType(classType, project);
                }
                return typeParameter != null ? typeParameter : PsiType.getJavaLangObject((PsiManager)iteratedExpression.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)iterateExpression.getProject()));
            }
            if (type instanceof PsiArrayType) {
                return ((PsiArrayType)type).getComponentType();
            }
            return null;
        });
    }

    @Nullable
    private static PsiType getMapEntryType(@NotNull PsiClassType mapType, @NotNull Project project) {
        PsiClass entryClass;
        if (mapType == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(4);
        }
        if ((entryClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.Map.Entry", GlobalSearchScope.allScope((Project)project))) != null) {
            PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)mapType, (String)"java.util.Map", (int)0, (boolean)false);
            PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)mapType, (String)"java.util.Map", (int)1, (boolean)false);
            if (keyType != null && valueType != null) {
                return JavaPsiFacade.getElementFactory((Project)project).createType(entryClass, new PsiType[]{keyType, valueType});
            }
        }
        return null;
    }

    @NotNull
    private static ThymeleafVariable createStatVariable(@NotNull String s, @NotNull ThymesElExpression variable, @Nullable PsiType itType) {
        if (s == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(5);
        }
        if (variable == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(6);
        }
        ThymeleafStatusVariable thymeleafStatusVariable = new ThymeleafStatusVariable(s, variable, itType);
        if (thymeleafStatusVariable == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(7);
        }
        return thymeleafStatusVariable;
    }

    public static boolean processStatusVariableDeclarations(ThymeleafElementProcessor processor, @Nullable PsiType itType, @NotNull PsiElement element) {
        if (element == null) {
            ThymeleafIterateVariablesProvider.$$$reportNull$$$0(8);
        }
        for (Map.Entry<String, PsiType> entry : map.entrySet()) {
            if (processor.processVariable((PsiVariable)new ThymeleafVariable(entry.getKey(), entry.getValue(), element), PsiSubstitutor.EMPTY)) continue;
            return false;
        }
        return itType == null || processor.processVariable((PsiVariable)new ThymeleafVariable("current", itType, element), PsiSubstitutor.EMPTY);
    }

    static {
        map.put("index", (PsiType)PsiType.INT);
        map.put("count", (PsiType)PsiType.INT);
        map.put("size", (PsiType)PsiType.INT);
        map.put("even", (PsiType)PsiType.BOOLEAN);
        map.put("odd", (PsiType)PsiType.BOOLEAN);
        map.put("first", (PsiType)PsiType.BOOLEAN);
        map.put("last", (PsiType)PsiType.BOOLEAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterateExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIterateExpressionType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMapEntryType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStatVariable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processStatusVariableDeclarations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getIterateExpressionType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ThymeleafStatusVariable
    extends ThymeleafVariable {
        @Nullable
        private final PsiType myItType;

        ThymeleafStatusVariable(String s, ThymesElExpression navigationElement, @Nullable PsiType itType) {
            super(s, (PsiType)PsiType.VOID, navigationElement);
            this.myItType = itType;
        }

        @Override
        public boolean processDeclarations(@NotNull ThymeleafElementProcessor processor) {
            if (processor == null) {
                ThymeleafStatusVariable.$$$reportNull$$$0(0);
            }
            return ThymeleafIterateVariablesProvider.processStatusVariableDeclarations(processor, this.myItType, this.getNavigationElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider$ThymeleafStatusVariable", "processDeclarations"));
        }
    }
}

