/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.injectors;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafExpressionsInjector
implements MultiHostInjector {
    private static final Map<Condition<String>, ThymeleafLanguage> injectors = new HashMap();

    private static Condition<String> createAttrNameCondition(String ... attrNames) {
        return localName -> {
            for (String name : attrNames) {
                if (!localName.equals(name)) continue;
                return true;
            }
            return false;
        };
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        int endOffset;
        if (registrar == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(1);
        }
        if (!ThymeleafCommonUtil.hasThymeleafLibrary(host.getProject())) {
            return;
        }
        ThymeleafLanguage languageToInject = this.getLanguageToInject((XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)host, XmlAttribute.class));
        if (languageToInject != null && (endOffset = host.getTextLength() - 1) > 0) {
            registrar.startInjecting((Language)languageToInject).addPlace(null, null, (PsiLanguageInjectionHost)host, TextRange.create((int)1, (int)endOffset)).doneInjecting();
        }
    }

    @Nullable
    public ThymeleafLanguage getLanguageToInject(@Nullable XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            return null;
        }
        String attrName = this.getThymeleafAttrName(xmlAttribute);
        if (attrName != null) {
            for (Map.Entry<Condition<String>, ThymeleafLanguage> entry : injectors.entrySet()) {
                if (!entry.getKey().value((Object)attrName)) continue;
                return entry.getValue();
            }
            String namespace = xmlAttribute.getNamespace();
            for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(xmlAttribute.getProject())) {
                for (String ns : dialect.getNamespaces()) {
                    if (!ns.equals(namespace)) continue;
                    return dialect.getLanguage();
                }
            }
            return ThymeleafLanguage.EXPRESSIONS;
        }
        return null;
    }

    @Nullable
    public String getThymeleafAttrName(@NotNull XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(2);
        }
        String localName = xmlAttribute.getLocalName();
        if (ThymeleafCommonUtil.isThymeleafNamespace(xmlAttribute.getNamespace(), xmlAttribute.getProject())) {
            return localName;
        }
        return ThymeleafExpressionsInjector.getThymeleafAttrNameHtml5(xmlAttribute);
    }

    @Nullable
    public static String getThymeleafAttrNameHtml5(@NotNull XmlAttribute xmlAttribute) {
        String prefix;
        String prefixByNamespace;
        if (xmlAttribute == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(3);
        }
        String localName = xmlAttribute.getLocalName();
        XmlTag tag = xmlAttribute.getParent();
        if (tag != null && (prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(tag)) != null && localName.startsWith(prefix = "data-" + prefixByNamespace + "-")) {
            return localName.substring(prefix.length());
        }
        return null;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class);
        if (list == null) {
            ThymeleafExpressionsInjector.$$$reportNull$$$0(4);
        }
        return list;
    }

    static {
        injectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("each"), ThymeleafLanguage.EACH_EXPRESSIONS);
        injectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("href", "src", "action"), ThymeleafLanguage.URL_EXPRESSIONS);
        injectors.put(ThymeleafExpressionsInjector.createAttrNameCondition("include", "remove", "replace", "fragment", "substituteby"), ThymeleafLanguage.TEMPLATES_EXPRESSIONS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/injectors/ThymeleafExpressionsInjector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafAttrName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafAttrNameHtml5";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

