/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J2\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J(\u0010'\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J/\u0010.\u001a\u00020/2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b2J\u0014\u00103\u001a\u00020\u0014*\u0002042\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "variableTypeAndInitializerResolver", "Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "checkLocalVariableDeclaration", "", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "initializeWithDefaultGetterSetter", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;", "process", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "property", "typingContext", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingFacade;", "resolveLocalVariableDescriptor", "variable", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveLocalVariableDescriptorWithType", "Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveLocalVariableDescriptorWithType$frontend", "updateAccessorFlagsFromResolvedCallForDelegatedProperty", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "frontend"})
public final class LocalVariableResolver {
    private final ModifiersChecker modifiersChecker;
    private final IdentifierChecker identifierChecker;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final AnnotationResolver annotationResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;

    @NotNull
    public final Pair<KotlinTypeInfo, VariableDescriptor> process(@NotNull KtProperty property, @NotNull ExpressionTypingContext typingContext, @NotNull LexicalScope scope2, @NotNull ExpressionTypingFacade facade) {
        KotlinTypeInfo typeInfo;
        KtExpression initializer2;
        KtPropertyAccessor setter2;
        KtPropertyAccessor getter2;
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)typingContext, (String)"typingContext");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        Object Context2 = ((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(scope2);
        Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"typingContext.replaceCon\u2026DENT).replaceScope(scope)");
        ExpressionTypingContext context = (ExpressionTypingContext)Context2;
        KtTypeReference receiverTypeRef = property.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on((KtTypeReference)((PsiElement)receiverTypeRef)));
        }
        if ((getter2 = property.getGetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
        }
        if ((setter2 = property.getSetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
        }
        KtVariableDeclaration ktVariableDeclaration = property;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        VariableDescriptor propertyDescriptor = this.resolveLocalVariableDescriptor(scope2, ktVariableDeclaration, dataFlowInfo, bindingTrace);
        KtExpression delegateExpression = property.getDelegateExpression();
        if (delegateExpression != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.LocalDelegatedProperties)) {
                BindingTrace bindingTrace2 = context.trace;
                KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
                if (ktPropertyDelegate == null) {
                    Intrinsics.throwNpe();
                }
                bindingTrace2.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)ktPropertyDelegate, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.LocalDelegatedProperties), (Object)this.languageVersionSettings)));
            }
            if (propertyDescriptor instanceof VariableDescriptorWithAccessors) {
                DataFlowInfo dataFlowInfo2 = typingContext.dataFlowInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo2, (String)"typingContext.dataFlowInfo");
                VariableDescriptorWithAccessors variableDescriptorWithAccessors = (VariableDescriptorWithAccessors)propertyDescriptor;
                LexicalScope lexicalScope = typingContext.scope;
                Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"typingContext.scope");
                BindingTrace bindingTrace3 = typingContext.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace3, (String)"typingContext.trace");
                this.delegatedPropertyResolver.resolvePropertyDelegate(dataFlowInfo2, property, variableDescriptorWithAccessors, delegateExpression, lexicalScope, bindingTrace3);
                VariableAccessorDescriptor variableAccessorDescriptor = ((VariableDescriptorWithAccessors)propertyDescriptor).getGetter();
                if (variableAccessorDescriptor != null) {
                    BindingTrace bindingTrace4 = typingContext.trace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace4, (String)"typingContext.trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor, bindingTrace4);
                }
                VariableAccessorDescriptor variableAccessorDescriptor2 = ((VariableDescriptorWithAccessors)propertyDescriptor).getSetter();
                if (variableAccessorDescriptor2 != null) {
                    BindingTrace bindingTrace5 = typingContext.trace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace5, (String)"typingContext.trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor2, bindingTrace5);
                }
            }
        }
        if ((initializer2 = property.getInitializer()) != null) {
            KotlinType kotlinType = propertyDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"propertyDescriptor.type");
            KotlinType outType = kotlinType;
            KotlinTypeInfo kotlinTypeInfo = facade.getTypeInfo(initializer2, (ExpressionTypingContext)context.replaceExpectedType(outType));
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinTypeInfo, (String)"facade.getTypeInfo(initi\u2026aceExpectedType(outType))");
            typeInfo = kotlinTypeInfo;
            DataFlowInfo dataFlowInfo3 = typeInfo.getDataFlowInfo();
            KotlinType type2 = typeInfo.getType();
            if (type2 != null) {
                DataFlowValue initializerDataFlowValue = this.dataFlowValueFactory.createDataFlowValue(initializer2, type2, context);
                if (!propertyDescriptor.isVar() && initializerDataFlowValue.getCanBeBound()) {
                    context.trace.record(BindingContext.BOUND_INITIALIZER_VALUE, propertyDescriptor, initializerDataFlowValue);
                }
                if (property.getTypeReference() == null) {
                    BindingTrace bindingTrace6 = context.trace;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace6, (String)"context.trace");
                    BindingContext bindingContext2 = bindingTrace6.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.trace.bindingContext");
                    DataFlowValue variableDataFlowValue = this.dataFlowValueFactory.createDataFlowValueForProperty(property, propertyDescriptor, bindingContext2, DescriptorUtils.getContainingModuleOrNull(scope2.getOwnerDescriptor()));
                    typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo3.assign(variableDataFlowValue, initializerDataFlowValue, this.languageVersionSettings));
                }
            }
        } else {
            typeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        this.checkLocalVariableDeclaration(context, propertyDescriptor, property);
        return new Pair((Object)typeInfo.replaceType(this.dataFlowAnalyzer.checkStatementType(property, context)), (Object)propertyDescriptor);
    }

    private final void checkLocalVariableDeclaration(ExpressionTypingContext context, VariableDescriptor descriptor2, KtProperty ktProperty) {
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, descriptor2);
        this.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(ktProperty, descriptor2);
        KtDeclaration ktDeclaration = ktProperty;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
        this.identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(bindingTrace2, ktProperty, descriptor2);
    }

    private final VariableDescriptor resolveLocalVariableDescriptor(LexicalScope scope2, KtVariableDeclaration variable2, DataFlowInfo dataFlowInfo, BindingTrace trace) {
        VariableDescriptorWithInitializerImpl result2;
        KotlinType type2;
        DeclarationDescriptor containingDeclaration2 = scope2.getOwnerDescriptor();
        if (KtPsiUtil.isScriptDeclaration(variable2)) {
            PropertyDescriptorImpl propertyDescriptorImpl = PropertyDescriptorImpl.create(containingDeclaration2, this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable2.getModifierList(), trace), Modality.FINAL, Visibilities.INTERNAL, variable2.isVar(), KtPsiUtil.safeName(variable2.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variable2), false, false, false, false, false, variable2 instanceof KtProperty && ((KtProperty)variable2).hasDelegate());
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptorImpl, (String)"PropertyDescriptorImpl.c\u2026sDelegate()\n            )");
            PropertyDescriptorImpl propertyDescriptor = propertyDescriptorImpl;
            type2 = this.variableTypeAndInitializerResolver.resolveType(propertyDescriptor, scope2, variable2, dataFlowInfo, trace, true);
            DeclarationDescriptor declarationDescriptor = containingDeclaration2;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ScriptDescriptor");
            }
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ScriptDescriptor)declarationDescriptor).getThisAsReceiverParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"(containingDeclaration a\u2026).thisAsReceiverParameter");
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            propertyDescriptor.setType(type2, CollectionsKt.emptyList(), receiverParameter, null);
            this.initializeWithDefaultGetterSetter(propertyDescriptor);
            trace.record(BindingContext.VARIABLE, variable2, propertyDescriptor);
            result2 = propertyDescriptor;
        } else {
            LocalVariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptorWithType$frontend(scope2, variable2, null, trace);
            type2 = this.variableTypeAndInitializerResolver.resolveType(variableDescriptor, scope2, variable2, dataFlowInfo, trace, true);
            variableDescriptor.setOutType(type2);
            result2 = variableDescriptor;
        }
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(result2, scope2, variable2, dataFlowInfo, type2, trace);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return result2;
    }

    private final void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter2;
        PropertyGetterDescriptorImpl getter2 = propertyDescriptor.getGetter();
        if (getter2 == null && !Visibilities.isPrivate(propertyDescriptor.getVisibility())) {
            getter2 = DescriptorFactory.createDefaultGetter(propertyDescriptor, Annotations.Companion.getEMPTY());
            getter2.initialize(propertyDescriptor.getType());
        }
        if ((setter2 = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter2 = DescriptorFactory.createDefaultSetter(propertyDescriptor, Annotations.Companion.getEMPTY(), Annotations.Companion.getEMPTY());
        }
        propertyDescriptor.initialize(getter2, setter2);
    }

    @NotNull
    public final LocalVariableDescriptor resolveLocalVariableDescriptorWithType$frontend(@NotNull LexicalScope scope2, @NotNull KtVariableDeclaration variable2, @Nullable KotlinType type2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        boolean hasDelegate = variable2 instanceof KtProperty && ((KtProperty)variable2).hasDelegate();
        boolean hasLateinit = variable2.hasModifier(KtTokens.LATEINIT_KEYWORD);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, variable2.getModifierList(), trace), UnderscoreUtilKt.isSingleUnderscore(variable2) ? Name.special("<underscore local var>") : KtPsiUtil.safeName(variable2.getName()), type2, variable2.isVar(), hasDelegate, hasLateinit, KotlinSourceElementKt.toSourceElement(variable2));
        trace.record(BindingContext.VARIABLE, variable2, variableDescriptor);
        return variableDescriptor;
    }

    private final void updateAccessorFlagsFromResolvedCallForDelegatedProperty(@NotNull VariableAccessorDescriptor $receiver, BindingTrace trace) {
        if ($receiver instanceof FunctionDescriptorImpl) {
            FunctionDescriptor resultingDescriptor;
            ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, $receiver);
            FunctionDescriptor functionDescriptor2 = resultingDescriptor = resolvedCall2 != null ? (FunctionDescriptor)resolvedCall2.getResultingDescriptor() : null;
            if (resultingDescriptor != null) {
                ((FunctionDescriptorImpl)((Object)$receiver)).setSuspend(resultingDescriptor.isSuspend());
            }
        }
    }

    public LocalVariableResolver(@NotNull ModifiersChecker modifiersChecker, @NotNull IdentifierChecker identifierChecker, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull AnnotationResolver annotationResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkParameterIsNotNull((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkParameterIsNotNull((Object)variableTypeAndInitializerResolver, (String)"variableTypeAndInitializerResolver");
        Intrinsics.checkParameterIsNotNull((Object)delegatedPropertyResolver, (String)"delegatedPropertyResolver");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.modifiersChecker = modifiersChecker;
        this.identifierChecker = identifierChecker;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.annotationResolver = annotationResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }
}

