/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0086\b\u0018\u0000 V2\u00020\u0001:\u0001VB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0016\u0010*\u001a\n +*\u0004\u0018\u00010\u00030\u00032\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\n +*\u0004\u0018\u00010/0/J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b1J\u0013\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u0003H\u00c6\u0001J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0000J\u000e\u00106\u001a\u0002042\u0006\u00107\u001a\u00020\u0005J\u0006\u00108\u001a\u00020\u0014J\u0006\u00109\u001a\u00020\u0000J\u0006\u0010:\u001a\u000204J\u0006\u0010;\u001a\u000204J\u0013\u0010<\u001a\u00020\u00142\b\u0010=\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u001a\u0010>\u001a\u0002042\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040@J\b\u0010A\u001a\u00020BH\u0016J\u000e\u0010C\u001a\n +*\u0004\u0018\u00010\u00030\u0003J\u000e\u0010D\u001a\n +*\u0004\u0018\u00010E0EJ\u001a\u0010F\u001a\u0002042\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002040@J\u001a\u0010H\u001a\u0002042\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002040@J\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\n +*\u0004\u0018\u00010-0-J\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00050MJ\u000e\u0010N\u001a\u0002042\u0006\u00105\u001a\u00020\u0000J\b\u0010O\u001a\u00020\u0005H\u0016J\u0016\u0010P\u001a\n +*\u0004\u0018\u00010\u00030\u00032\u0006\u0010,\u001a\u00020-J\u0014\u0010Q\u001a\u0002042\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00050SJ\u000e\u0010T\u001a\u0002042\u0006\u0010U\u001a\u00020\u0005R\u0011\u0010\r\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012R\u0011\u0010'\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000fR\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012\u00a8\u0006W"}, d2={"Lorg/jetbrains/kotlin/konan/file/File;", "", "parent", "Ljava/nio/file/Path;", "child", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "path", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "javaPath", "(Ljava/nio/file/Path;)V", "absoluteFile", "getAbsoluteFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "exists", "", "getExists", "()Z", "extension", "getExtension", "isAbsolute", "isDirectory", "isFile", "getJavaPath$kotlin_native_library_reader", "()Ljava/nio/file/Path;", "listFiles", "", "getListFiles", "()Ljava/util/List;", "listFilesOrEmpty", "getListFilesOrEmpty", "name", "getName", "getParent", "parentFile", "getParentFile", "getPath", "appendBytes", "kotlin.jvm.PlatformType", "bytes", "", "bufferedReader", "Ljava/io/BufferedReader;", "component1", "component1$kotlin_native_library_reader", "copy", "copyTo", "", "destination", "createAsSymlink", "target", "delete", "deleteOnExit", "deleteOnExitRecursively", "deleteRecursively", "equals", "other", "forEachLine", "action", "Lkotlin/Function1;", "hashCode", "", "mkdirs", "outputStream", "Ljava/io/OutputStream;", "postorder", "task", "preorder", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readStrings", "", "recursiveCopyTo", "toString", "writeBytes", "writeLines", "lines", "", "writeText", "text", "Companion", "kotlin-native-library-reader"})
public final class File {
    @NotNull
    private final Path javaPath;
    private static final String pathSeparator;
    public static final Companion Companion;

    @NotNull
    public final String getPath() {
        return ((Object)this.javaPath).toString();
    }

    @NotNull
    public final String getAbsolutePath() {
        return ((Object)this.javaPath.toAbsolutePath()).toString();
    }

    @NotNull
    public final File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    @NotNull
    public final String getName() {
        return ((Object)this.javaPath.getFileName()).toString();
    }

    @NotNull
    public final String getExtension() {
        return StringsKt.substringAfterLast((String)this.getName(), (char)'.', (String)"");
    }

    @NotNull
    public final String getParent() {
        return ((Object)this.javaPath.getParent()).toString();
    }

    @NotNull
    public final File getParentFile() {
        Path path2 = this.javaPath.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"javaPath.parent");
        return new File(path2);
    }

    public final boolean getExists() {
        return Files.exists(this.javaPath, new LinkOption[0]);
    }

    public final boolean isDirectory() {
        return Files.isDirectory(this.javaPath, new LinkOption[0]);
    }

    public final boolean isFile() {
        return Files.isRegularFile(this.javaPath, new LinkOption[0]);
    }

    public final boolean isAbsolute() {
        return this.javaPath.isAbsolute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getListFiles() {
        Iterable stream2;
        AutoCloseable $receiver$iv = Files.newDirectoryStream(this.javaPath);
        boolean closed$iv = false;
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            DirectoryStream directoryStream = stream2 = (DirectoryStream)$receiver$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryStream, (String)"stream");
            Iterable iterable = $receiver$iv2 = (Iterable)directoryStream;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                File file = new File((Path)v1);
                collection.add(file);
            }
            stream2 = (List)destination$iv$iv;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $receiver$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $receiver$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $receiver$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return stream2;
    }

    @NotNull
    public final List<File> getListFilesOrEmpty() {
        return this.getExists() ? this.getListFiles() : CollectionsKt.emptyList();
    }

    @NotNull
    public final File child(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return new File(this, name2);
    }

    public final void copyTo(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Files.copy(this.javaPath, destination.javaPath, StandardCopyOption.REPLACE_EXISTING);
    }

    public final void recursiveCopyTo(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Path sourcePath = this.javaPath;
        Path destPath = destination.javaPath;
        FileKt.recursiveCopyTo(sourcePath, destPath);
    }

    public final Path mkdirs() {
        return Files.createDirectories(this.javaPath, new FileAttribute[0]);
    }

    public final boolean delete() {
        return Files.deleteIfExists(this.javaPath);
    }

    public final void deleteRecursively() {
        this.postorder((Function1<? super Path, Unit>)((Function1)deleteRecursively.1.INSTANCE));
    }

    public final void deleteOnExitRecursively() {
        this.preorder((Function1<? super Path, Unit>)((Function1)deleteOnExitRecursively.1.INSTANCE));
    }

    public final void preorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1 $task;

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attrs) {
                Path path2 = file;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@Nullable Path dir, @Nullable BasicFileAttributes attrs) {
                Path path2 = dir;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
    }

    public final void postorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1 $task;

            @NotNull
            public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attrs) {
                Path path2 = file;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@Nullable Path dir, @Nullable IOException exc) {
                Path path2 = dir;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                this.$task.invoke((Object)path2);
                return FileVisitResult.CONTINUE;
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final File deleteOnExit() {
        this.javaPath.toFile().deleteOnExit();
        return this;
    }

    public final byte[] readBytes() {
        return Files.readAllBytes(this.javaPath);
    }

    public final Path writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return Files.write(this.javaPath, bytes, new OpenOption[0]);
    }

    public final Path appendBytes(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return Files.write(this.javaPath, bytes, StandardOpenOption.APPEND);
    }

    public final void writeLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        Files.write(this.javaPath, lines, new OpenOption[0]);
    }

    public final void writeText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.writeLines(CollectionsKt.listOf((Object)text2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachLine(@NotNull Function1<? super String, Unit> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        AutoCloseable $receiver$iv = Files.lines(this.javaPath);
        boolean closed$iv = false;
        try {
            Stream lines = (Stream)$receiver$iv;
            lines.forEach((Consumer)new Consumer<String>(action2){
                final /* synthetic */ Function1 $action$inlined;
                {
                    this.$action$inlined = function1;
                }

                public final void accept(String it) {
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    this.$action$inlined.invoke((Object)string);
                }
            });
            lines = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $receiver$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $receiver$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $receiver$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    public final void createAsSymlink(@NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Path targetPath = Paths.get(target, new String[0]);
        if (Files.isSymbolicLink(this.javaPath) && Intrinsics.areEqual((Object)Files.readSymbolicLink(this.javaPath), (Object)targetPath)) {
            return;
        }
        Files.createSymbolicLink(this.javaPath, targetPath, new FileAttribute[0]);
    }

    @NotNull
    public String toString() {
        return this.getPath();
    }

    public final BufferedReader bufferedReader() {
        return Files.newBufferedReader(this.javaPath);
    }

    public final OutputStream outputStream() {
        return Files.newOutputStream(this.javaPath, new OpenOption[0]);
    }

    @NotNull
    public final PrintWriter printWriter() {
        Object object;
        java.io.File file = this.javaPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"javaPath.toFile()");
        java.io.File file2 = file;
        Charset charset = Charsets.UTF_8;
        java.io.File file3 = file2;
        int n = 8192;
        Object object2 = object = file3;
        object2 = new FileOutputStream((java.io.File)object2);
        object = new OutputStreamWriter((OutputStream)object2, charset);
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        return new PrintWriter(writer);
    }

    @NotNull
    public final List<String> readStrings() {
        List list2;
        List list3 = list2 = (List)new ArrayList();
        this.forEachLine((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(list3){
            final /* synthetic */ List $list;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$list.add(it);
            }
            {
                this.$list = list2;
                super(1);
            }
        }));
        return list2;
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (!(object instanceof File)) {
            object = null;
        }
        File file = (File)object;
        if (file == null) {
            return false;
        }
        File otherFile = file;
        return Intrinsics.areEqual((Object)otherFile.javaPath.toAbsolutePath(), (Object)this.javaPath.toAbsolutePath());
    }

    public int hashCode() {
        return ((Object)this.javaPath.toAbsolutePath()).hashCode();
    }

    @NotNull
    public final Path getJavaPath$kotlin_native_library_reader() {
        return this.javaPath;
    }

    public File(@NotNull Path javaPath) {
        Intrinsics.checkParameterIsNotNull((Object)javaPath, (String)"javaPath");
        this.javaPath = javaPath;
    }

    public File(@NotNull Path parent2, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Path path2 = parent2.resolve(child);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"parent.resolve(child)");
        this(path2);
    }

    public File(@NotNull File parent2, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Path path2 = parent2.javaPath.resolve(child);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"parent.javaPath.resolve(child)");
        this(path2);
    }

    public File(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Path path3 = Paths.get(path2, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(path)");
        this(path3);
    }

    public File(@NotNull String parent2, @NotNull String child) {
        Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Path path2 = Paths.get(parent2, child);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(parent, child)");
        this(path2);
    }

    static {
        Companion = new Companion(null);
        pathSeparator = java.io.File.pathSeparator;
    }

    @NotNull
    public final Path component1$kotlin_native_library_reader() {
        return this.javaPath;
    }

    @NotNull
    public final File copy(@NotNull Path javaPath) {
        Intrinsics.checkParameterIsNotNull((Object)javaPath, (String)"javaPath");
        return new File(javaPath);
    }

    @NotNull
    public static /* synthetic */ File copy$default(File file, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            path2 = file.javaPath;
        }
        return file.copy(path2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0011\u0010\u000e\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/konan/file/File$Companion;", "", "()V", "javaHome", "Lorg/jetbrains/kotlin/konan/file/File;", "getJavaHome", "()Lorg/jetbrains/kotlin/konan/file/File;", "pathSeparator", "", "kotlin.jvm.PlatformType", "getPathSeparator", "()Ljava/lang/String;", "userDir", "getUserDir", "userHome", "getUserHome", "kotlin-native-library-reader"})
    public static final class Companion {
        @NotNull
        public final File getUserDir() {
            String string = System.getProperty("user.dir");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"user.dir\")");
            return new File(string);
        }

        @NotNull
        public final File getUserHome() {
            String string = System.getProperty("user.home");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"user.home\")");
            return new File(string);
        }

        @NotNull
        public final File getJavaHome() {
            String string = System.getProperty("java.home");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"java.home\")");
            return new File(string);
        }

        public final String getPathSeparator() {
            return pathSeparator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

