/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.naming.NameSuggestion;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.ClassTranslator;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.expression.StringTemplateTranslator;
import org.jetbrains.kotlin.js.translate.expression.TryTranslator;
import org.jetbrains.kotlin.js.translate.expression.WhenTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.general.TranslatorVisitor;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.UnaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslationUtils;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallableReferenceTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.js.translate.utils.mutator.CoercionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public final class ExpressionVisitor
extends TranslatorVisitor<JsNode> {
    private static final FqName primitiveClassesFqName = new FqName("kotlin.reflect.js.internal.PrimitiveClasses");

    @Override
    protected JsNode emptyResult(@NotNull TranslationContext context) {
        return new JsNullLiteral();
    }

    @Override
    @NotNull
    public JsNode visitConstantExpression(@NotNull KtConstantExpression expression2, @NotNull TranslationContext context) {
        return ExpressionVisitor.translateConstantExpression(expression2, context).source(expression2);
    }

    @NotNull
    private static JsNode translateConstantExpression(@NotNull KtConstantExpression expression2, @NotNull TranslationContext context) {
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context.bindingContext());
        assert (compileTimeValue != null) : ErrorReportingUtils.message((PsiElement)expression2, "Expression is not compile time value: " + expression2.getText() + " ");
        JsExpression result2 = Translation.translateConstant(compileTimeValue, expression2, context);
        if (result2 == null) {
            throw new AssertionError((Object)ErrorReportingUtils.message((PsiElement)expression2, "Unsupported constant expression: " + expression2.getText() + " "));
        }
        return result2;
    }

    @Override
    @NotNull
    public JsNode visitBlockExpression(@NotNull KtBlockExpression jetBlock, @NotNull TranslationContext context) {
        List<KtExpression> statements = jetBlock.getStatements();
        JsBlock jsBlock = new JsBlock();
        for (KtExpression statement2 : statements) {
            JsNode jsNode = Translation.translateExpression(statement2, context, jsBlock);
            JsStatement jsStatement = JsAstUtils.convertToStatement(jsNode);
            if (JsAstUtils.isEmptyStatement(jsStatement)) continue;
            jsBlock.getStatements().add(jsStatement);
        }
        if (statements.isEmpty()) {
            ClassDescriptor unitClass = context.getCurrentModule().getBuiltIns().getUnit();
            jsBlock.getStatements().add(JsAstUtils.asSyntheticStatement(ReferenceTranslator.translateAsValueReference(unitClass, context)));
        }
        return jsBlock;
    }

    @Override
    public JsNode visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull TranslationContext context) {
        KtExpression jetInitializer = multiDeclaration.getInitializer();
        assert (jetInitializer != null) : "Initializer for multi declaration must be not null";
        JsExpression initializer2 = Translation.translateAsExpression(jetInitializer, context);
        JsName parameterName2 = JsScope.declareTemporary();
        JsVars tempVarDeclaration = JsAstUtils.newVar(parameterName2, initializer2);
        MetadataProperties.setSynthetic(tempVarDeclaration, true);
        context.addStatementToCurrentBlock(tempVarDeclaration);
        return DestructuringDeclarationTranslator.translate(multiDeclaration, JsAstUtils.pureFqn(parameterName2, null), context);
    }

    @Override
    @NotNull
    public JsNode visitReturnExpression(@NotNull KtReturnExpression jetReturnExpression, @NotNull TranslationContext context) {
        JsReturn jsReturn;
        KtExpression returned = jetReturnExpression.getReturnedExpression();
        KtDeclarationWithBody parent2 = (KtDeclarationWithBody)PsiTreeUtil.getParentOfType((PsiElement)jetReturnExpression, KtDeclarationWithBody.class);
        if (parent2 instanceof KtSecondaryConstructor) {
            ClassDescriptor classDescriptor2 = context.getClassDescriptor();
            assert (classDescriptor2 != null) : "Missing class descriptor in context while translating constructor: " + PsiUtilsKt.getTextWithLocation((PsiElement)jetReturnExpression);
            JsExpression ref = ReferenceTranslator.translateAsValueReference(classDescriptor2.getThisAsReceiverParameter(), context);
            return new JsReturn(ref.source(jetReturnExpression));
        }
        FunctionDescriptor returnTarget = ExpressionVisitor.getNonLocalReturnTarget(jetReturnExpression, context);
        if (returned == null) {
            jsReturn = new JsReturn(null);
        } else {
            JsExpression jsReturnExpression = Translation.translateAsExpression(returned, context);
            KotlinType returnedType = context.bindingContext().getType(returned);
            assert (returnedType != null) : "Resolved return expression is expected to have type: " + PsiUtilsKt.getTextWithLocation((PsiElement)jetReturnExpression);
            CallableDescriptor returnTargetOrCurrentFunction = returnTarget;
            if (returnTargetOrCurrentFunction == null) {
                returnTargetOrCurrentFunction = (CallableDescriptor)context.getDeclarationDescriptor();
            }
            if (returnTargetOrCurrentFunction != null) {
                jsReturnExpression = TranslationUtils.coerce(context, jsReturnExpression, TranslationUtils.getReturnTypeForCoercion(returnTargetOrCurrentFunction));
            }
            jsReturn = new JsReturn(jsReturnExpression);
        }
        MetadataProperties.setReturnTarget(jsReturn, returnTarget);
        return jsReturn.source(jetReturnExpression);
    }

    @Nullable
    private static FunctionDescriptor getNonLocalReturnTarget(@NotNull KtReturnExpression expression2, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptor2 = context.getDeclarationDescriptor();
        assert (descriptor2 instanceof CallableMemberDescriptor) : "Return expression can only be inside callable declaration: " + PsiUtilsKt.getTextWithLocation((PsiElement)expression2);
        KtSimpleNameExpression target = expression2.getTargetLabel();
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (target == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    return (FunctionDescriptor)BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                }
            } else {
                PsiElement element3 = context.bindingContext().get(BindingContext.LABEL_TARGET, target);
                descriptor2 = context.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
            }
        }
        assert (descriptor2 == null || descriptor2 instanceof FunctionDescriptor) : "Function descriptor expected to be target of return label: " + PsiUtilsKt.getTextWithLocation((PsiElement)expression2);
        return (FunctionDescriptor)descriptor2;
    }

    @Override
    @NotNull
    public JsNode visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @NotNull TranslationContext context) {
        KtExpression expressionInside = expression2.getExpression();
        if (expressionInside != null) {
            return Translation.translateExpression(expressionInside, context);
        }
        return JsEmpty.INSTANCE;
    }

    @Override
    @NotNull
    public JsNode visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        return BinaryOperationTranslator.translate(expression2, context);
    }

    @Override
    @NotNull
    public JsNode visitProperty(@NotNull KtProperty expression2, @NotNull TranslationContext context) {
        VariableDescriptor descriptor2 = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, expression2);
        JsExpression initializer2 = TranslationUtils.translateInitializerForProperty(expression2, context);
        KtExpression delegateExpression = expression2.getDelegateExpression();
        JsName name2 = context.getNameForDescriptor(descriptor2);
        if (delegateExpression != null) {
            initializer2 = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context, expression2);
            assert (initializer2 != null) : "Initializer must be non-null for property with delegate";
        } else if (context.isBoxedLocalCapturedInClosure(descriptor2)) {
            JsNameRef alias = Namer.getCapturedVarAccessor(name2.makeRef());
            initializer2 = JsAstUtils.wrapValue(alias, initializer2 == null ? new JsNullLiteral() : initializer2);
        }
        return JsAstUtils.newVar(name2, initializer2).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, @NotNull TranslationContext context) {
        return CallableReferenceTranslator.INSTANCE.translate(expression2, context);
    }

    @Override
    public JsNode visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, TranslationContext context) {
        KtExpression receiverExpression = expression2.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = context.bindingContext().get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
            JsExpression primitiveExpression;
            JsExpression receiver = Translation.translateAsExpression(receiverExpression, context);
            receiver = TranslationUtils.coerce(context, receiver, context.getCurrentModule().getBuiltIns().getAnyType());
            if (ExpressionVisitor.isPrimitiveClassLiteral(lhs.getType()) && (primitiveExpression = ExpressionVisitor.getPrimitiveClass(context, lhs.getType())) != null) {
                return JsAstUtils.newSequence(Arrays.asList(receiver, primitiveExpression));
            }
            return new JsInvocation((JsExpression)context.namer().kotlin("getKClassFromExpression"), receiver);
        }
        JsExpression primitiveExpression = ExpressionVisitor.getPrimitiveClass(context, lhs.getType());
        if (primitiveExpression != null) {
            return primitiveExpression;
        }
        return new JsInvocation(context.getReferenceToIntrinsic("getKClass"), UtilsKt.getReferenceToJsClass(lhs.getType(), context));
    }

    private static JsExpression getPrimitiveClass(@NotNull TranslationContext context, @NotNull KotlinType type2) {
        if (!context.getConfig().isAtLeast(LanguageVersion.KOTLIN_1_2) || ExpressionVisitor.findPrimitiveClassesObject(context) == null) {
            return null;
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof ClassDescriptor) {
            FunctionClassDescriptor functionClassDescriptor;
            FqName fqName2 = DescriptorUtilsKt.getFqNameSafe(descriptor2);
            switch (fqName2.asString()) {
                case "kotlin.Boolean": 
                case "kotlin.Byte": 
                case "kotlin.Short": 
                case "kotlin.Int": 
                case "kotlin.Float": 
                case "kotlin.Double": 
                case "kotlin.String": 
                case "kotlin.Array": 
                case "kotlin.Any": 
                case "kotlin.Throwable": 
                case "kotlin.Number": 
                case "kotlin.Nothing": 
                case "kotlin.BooleanArray": 
                case "kotlin.CharArray": 
                case "kotlin.ByteArray": 
                case "kotlin.ShortArray": 
                case "kotlin.IntArray": 
                case "kotlin.LongArray": 
                case "kotlin.FloatArray": 
                case "kotlin.DoubleArray": {
                    return ExpressionVisitor.getKotlinPrimitiveClassRef(context, StringUtil.decapitalize((String)fqName2.shortName().asString()) + "Class");
                }
            }
            if (descriptor2 instanceof FunctionClassDescriptor && (functionClassDescriptor = (FunctionClassDescriptor)descriptor2).getFunctionKind() == FunctionClassDescriptor.Kind.Function) {
                ClassDescriptor primitivesObject = ExpressionVisitor.findPrimitiveClassesObject(context);
                assert (primitivesObject != null);
                FunctionDescriptor function2 = DescriptorUtils.getFunctionByName(primitivesObject.getUnsubstitutedMemberScope(), Name.identifier("functionClass"));
                JsNameRef functionRef = JsAstUtils.pureFqn(context.getInlineableInnerNameForDescriptor(function2), null);
                return new JsInvocation((JsExpression)functionRef, new JsIntLiteral(functionClassDescriptor.getArity()));
            }
        }
        return null;
    }

    @NotNull
    private static JsExpression getKotlinPrimitiveClassRef(@NotNull TranslationContext context, @NotNull String name2) {
        ClassDescriptor primitivesObject = ExpressionVisitor.findPrimitiveClassesObject(context);
        assert (primitivesObject != null);
        PropertyDescriptor property = DescriptorUtils.getPropertyByName(primitivesObject.getUnsubstitutedMemberScope(), Name.identifier(name2));
        return JsAstUtils.pureFqn(context.getInlineableInnerNameForDescriptor(property), null);
    }

    private static boolean isPrimitiveClassLiteral(@NotNull KotlinType type2) {
        return KotlinBuiltIns.isPrimitiveType(type2) || KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2);
    }

    @Nullable
    private static ClassDescriptor findPrimitiveClassesObject(@NotNull TranslationContext context) {
        return FindClassInModuleKt.findClassAcrossModuleDependencies(context.getCurrentModule(), ClassId.topLevel(primitiveClassesFqName));
    }

    @Override
    @NotNull
    public JsNode visitCallExpression(@NotNull KtCallExpression expression2, @NotNull TranslationContext context) {
        return CallExpressionTranslator.translate(expression2, null, context).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitIfExpression(@NotNull KtIfExpression expression2, @NotNull TranslationContext context) {
        JsStatement elseStatement;
        assert (expression2.getCondition() != null) : "condition should not ne null: " + expression2.getText();
        JsExpression testExpression = Translation.translateAsExpression(expression2.getCondition(), context);
        KotlinType type2 = context.bindingContext().getType(expression2);
        boolean isKotlinExpression = BindingContextUtilsKt.isUsedAsExpression(expression2, context.bindingContext());
        KtExpression thenExpression = expression2.getThen();
        KtExpression elseExpression = expression2.getElse();
        JsStatement thenStatement = thenExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(thenExpression, context) : null;
        JsStatement jsStatement = elseStatement = elseExpression != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(elseExpression, context) : null;
        if (type2 != null) {
            if (thenStatement != null) {
                thenStatement = LastExpressionMutator.mutateLastExpression(thenStatement, new CoercionMutator(type2, context));
            }
            if (elseStatement != null) {
                elseStatement = LastExpressionMutator.mutateLastExpression(elseStatement, new CoercionMutator(type2, context));
            }
        }
        if (isKotlinExpression) {
            boolean canBeJsExpression;
            JsExpression jsThenExpression = JsAstUtils.extractExpressionFromStatement(thenStatement);
            JsExpression jsElseExpression = JsAstUtils.extractExpressionFromStatement(elseStatement);
            boolean bl = canBeJsExpression = jsThenExpression != null && jsElseExpression != null;
            if (canBeJsExpression) {
                return new JsConditional(testExpression, jsThenExpression, jsElseExpression).source(expression2);
            }
        }
        if (thenStatement == null) {
            thenStatement = JsEmpty.INSTANCE;
        }
        JsIf ifStatement = new JsIf(testExpression, thenStatement, elseStatement);
        return ifStatement.source(expression2);
    }

    @Override
    @NotNull
    public JsExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context) {
        return ReferenceTranslator.translateSimpleName(expression2, context).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitWhileExpression(@NotNull KtWhileExpression expression2, @NotNull TranslationContext context) {
        return LoopTranslator.createWhile(false, expression2, context);
    }

    @Override
    @NotNull
    public JsNode visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, @NotNull TranslationContext context) {
        return LoopTranslator.createWhile(true, expression2, context);
    }

    @Override
    @NotNull
    public JsNode visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context) {
        JsStringLiteral stringLiteral2 = ExpressionVisitor.resolveAsStringConstant(expression2, context);
        if (stringLiteral2 != null) {
            return stringLiteral2.source(expression2);
        }
        return ExpressionVisitor.resolveAsTemplate(expression2, context).source(expression2);
    }

    @NotNull
    private static JsNode resolveAsTemplate(@NotNull KtStringTemplateExpression expression2, @NotNull TranslationContext context) {
        return StringTemplateTranslator.translate(expression2, context);
    }

    @Nullable
    private static JsStringLiteral resolveAsStringConstant(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        Object value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression2);
        if (value == null) {
            return null;
        }
        assert (value instanceof String) : "Compile time constant template should be a String constant.";
        String constantString = (String)value;
        return new JsStringLiteral(constantString);
    }

    @Override
    @NotNull
    public JsNode visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, @NotNull TranslationContext context) {
        return QualifiedExpressionTranslator.translateQualifiedExpression(expression2, context);
    }

    @Override
    public JsNode visitLabeledExpression(@NotNull KtLabeledExpression expression2, @NotNull TranslationContext context) {
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        if (BindingContextUtilsKt.isUsedAsExpression(expression2, context.bindingContext())) {
            return Translation.translateAsExpression(baseExpression, context).source(expression2);
        }
        JsScope scope2 = context.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsFunctionScope functionScope = (JsFunctionScope)scope2;
        String labelIdent = ExpressionVisitor.getReferencedName(expression2.getTargetLabel());
        JsName labelName2 = functionScope.enterLabel(labelIdent, NameSuggestion.sanitizeName(labelIdent));
        JsStatement baseStatement = Translation.translateAsStatement(baseExpression, context);
        functionScope.exitLabel();
        return new JsLabel(labelName2, baseStatement).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitPrefixExpression(@NotNull KtPrefixExpression expression2, @NotNull TranslationContext context) {
        return UnaryOperationTranslator.translate(expression2, context).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitPostfixExpression(@NotNull KtPostfixExpression expression2, @NotNull TranslationContext context) {
        return UnaryOperationTranslator.translate(expression2, context).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitIsExpression(@NotNull KtIsExpression expression2, @NotNull TranslationContext context) {
        return Translation.patternTranslator(context).translateIsExpression(expression2).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @NotNull TranslationContext context) {
        return QualifiedExpressionTranslator.translateQualifiedExpression(expression2, context).source(expression2);
    }

    @Override
    @Nullable
    public JsNode visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context) {
        return WhenTranslator.translate(expression2, context);
    }

    @Override
    @NotNull
    public JsNode visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull TranslationContext context) {
        JsExpression jsExpression = PatternTranslator.isCastExpression(expression2) ? PatternTranslator.newInstance(context).translateCastExpression(expression2) : Translation.translateAsExpression(expression2.getLeft(), context);
        return jsExpression.source(expression2);
    }

    private static String getReferencedName(KtSimpleNameExpression expression2) {
        return expression2.getReferencedName().replaceAll("^@", "").replaceAll("(?:^`(.*)`$)", "$1");
    }

    private static JsNameRef getTargetLabel(KtExpressionWithLabel expression2, TranslationContext context) {
        KtSimpleNameExpression labelElement = expression2.getTargetLabel();
        if (labelElement == null) {
            return null;
        }
        String labelIdent = ExpressionVisitor.getReferencedName(labelElement);
        JsScope scope2 = context.scope();
        assert (scope2 instanceof JsFunctionScope) : "Labeled statement is unexpected outside of function scope";
        JsName labelName2 = ((JsFunctionScope)scope2).findLabel(labelIdent);
        assert (labelName2 != null);
        return labelName2.makeRef();
    }

    @Override
    @NotNull
    public JsNode visitBreakExpression(@NotNull KtBreakExpression expression2, @NotNull TranslationContext context) {
        return new JsBreak(ExpressionVisitor.getTargetLabel(expression2, context)).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitContinueExpression(@NotNull KtContinueExpression expression2, @NotNull TranslationContext context) {
        return new JsContinue(ExpressionVisitor.getTargetLabel(expression2, context)).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull TranslationContext context) {
        return new LiteralFunctionTranslator(context).translate(expression2.getFunctionLiteral()).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitNamedFunction(@NotNull KtNamedFunction expression2, @NotNull TranslationContext context) {
        boolean isExpression;
        JsExpression alias = new LiteralFunctionTranslator(context).translate(expression2);
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor(context.bindingContext(), expression2);
        JsNameRef nameRef = (JsNameRef)ReferenceTranslator.translateAsValueReference(descriptor2, context);
        assert (nameRef.getName() != null);
        if (InlineUtil.isInline(descriptor2)) {
            MetadataProperties.setStaticRef(nameRef.getName(), alias);
        }
        JsExpression result2 = (isExpression = BindingContextUtilsKt.isUsedAsExpression(expression2, context.bindingContext())) ? alias : JsAstUtils.newVar(nameRef.getName(), alias);
        return result2.source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitThisExpression(@NotNull KtThisExpression expression2, @NotNull TranslationContext context) {
        DeclarationDescriptor thisExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression2.getInstanceReference());
        assert (thisExpression != null) : "This expression must reference a descriptor: " + expression2.getText();
        return context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(thisExpression)).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context) {
        return AccessTranslationUtils.translateAsGet(expression2, context);
    }

    @Override
    @NotNull
    public JsNode visitSuperExpression(@NotNull KtSuperExpression expression2, @NotNull TranslationContext context) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, context.bindingContext());
        return context.getDispatchReceiver((ReceiverParameterDescriptor)resolvedCall2.getResultingDescriptor());
    }

    @Override
    @NotNull
    public JsNode visitForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context) {
        return LoopTranslator.translateForExpression(expression2, context).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitTryExpression(@NotNull KtTryExpression expression2, @NotNull TranslationContext context) {
        return new TryTranslator(expression2, context).translate();
    }

    @Override
    @NotNull
    public JsNode visitThrowExpression(@NotNull KtThrowExpression expression2, @NotNull TranslationContext context) {
        KtExpression thrownExpression = expression2.getThrownExpression();
        assert (thrownExpression != null) : "Thrown expression must not be null";
        return new JsThrow(Translation.translateAsExpression(thrownExpression, context)).source(expression2);
    }

    @Override
    @NotNull
    public JsNode visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, @NotNull TranslationContext context) {
        ResolvedCall<FunctionDescriptor> superCall;
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), expression2.getObjectDeclaration());
        ExpressionVisitor.translateClassOrObject(expression2.getObjectDeclaration(), descriptor2, context);
        JsExpression constructor2 = ReferenceTranslator.translateAsTypeReference(descriptor2, context);
        List<DeclarationDescriptor> closure = context.getClassOrConstructorClosure(descriptor2);
        ArrayList<JsExpression> closureArgs = new ArrayList<JsExpression>();
        if (closure != null) {
            for (DeclarationDescriptor capturedValue : closure) {
                closureArgs.add(context.getArgumentForClosureConstructor(capturedValue));
                if (!(capturedValue instanceof TypeParameterDescriptor)) continue;
                closureArgs.add(context.getTypeArgumentForClosureConstructor((TypeParameterDescriptor)capturedValue));
            }
        }
        if ((superCall = BindingUtils.getSuperCall(context.bindingContext(), expression2.getObjectDeclaration())) != null) {
            closureArgs.addAll(CallArgumentTranslator.translate(superCall, null, context).getTranslateArguments());
        }
        return new JsNew(constructor2, closureArgs);
    }

    @Override
    public JsNode visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, TranslationContext context) {
        for (KtAnnotationEntry entry : expression2.getAnnotationEntries()) {
            KtExpression baseExpression;
            KotlinRetention retention;
            ClassDescriptor classifierDescriptor;
            AnnotationDescriptor descriptor2 = context.bindingContext().get(BindingContext.ANNOTATION, entry);
            if (descriptor2 == null || (classifierDescriptor = DescriptorUtilsKt.getAnnotationClass(descriptor2)) == null || (retention = DescriptorUtilsKt.getAnnotationRetention(classifierDescriptor)) != KotlinRetention.SOURCE || (baseExpression = expression2.getBaseExpression()) == null) continue;
            return baseExpression.accept(this, context);
        }
        return (JsNode)super.visitAnnotatedExpression(expression2, context);
    }

    @Override
    public JsNode visitClass(@NotNull KtClass klass2, TranslationContext context) {
        ClassDescriptor descriptor2 = BindingUtils.getClassDescriptor(context.bindingContext(), klass2);
        ExpressionVisitor.translateClassOrObject(klass2, descriptor2, context);
        return JsEmpty.INSTANCE;
    }

    @Override
    public JsNode visitTypeAlias(@NotNull KtTypeAlias typeAlias2, TranslationContext data) {
        return JsEmpty.INSTANCE;
    }

    private static void translateClassOrObject(@NotNull KtClassOrObject declaration2, @NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        TranslationContext classContext = context.innerWithUsageTracker(descriptor2);
        ClassTranslator.translate(declaration2, classContext);
    }
}

