/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.roots;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinResourceRootType;
import org.jetbrains.kotlin.config.KotlinSourceRootType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005*\u00020\b\u001a\u0014\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00070\u0007*\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"migrateNonJvmSourceFolders", "", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "getMigratedSourceRootTypeWithProperties", "Lkotlin/Pair;", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "Lorg/jetbrains/jps/model/JpsElement;", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRoot;", "getOrCreateProperties", "kotlin.jvm.PlatformType", "idea"})
public final class ProjectRootUtilsKt {
    private static final JpsElement getOrCreateProperties(@NotNull JpsModuleSourceRoot $receiver) {
        JpsElement jpsElement;
        block6: {
            block5: {
                jpsElement = $receiver.getProperties($receiver.getRootType());
                if (jpsElement == null) break block5;
                JpsElement jpsElement2 = jpsElement;
                JpsElement it = jpsElement2;
                JpsElement jpsElement3 = it;
                if (!(jpsElement3 instanceof JpsElementBase)) {
                    jpsElement3 = null;
                }
                JpsElementBase jpsElementBase = (JpsElementBase)jpsElement3;
                if (jpsElementBase != null) {
                    jpsElementBase.setParent(null);
                }
                if ((jpsElement = jpsElement2) != null) break block6;
            }
            jpsElement = (JpsElement)$receiver.getRootType().createDefaultProperties();
        }
        return jpsElement;
    }

    @Nullable
    public static final Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> getMigratedSourceRootTypeWithProperties(@NotNull JpsModuleSourceRoot $receiver) {
        JpsElementType jpsElementType;
        JpsModuleSourceRootType currentRootType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JpsModuleSourceRootType jpsModuleSourceRootType = $receiver.getRootType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRootType, (String)"rootType");
        JpsModuleSourceRootType jpsModuleSourceRootType2 = currentRootType = jpsModuleSourceRootType;
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaSourceRootType.SOURCE)) {
            jpsElementType = (JpsElementType)KotlinSourceRootType.Source.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaSourceRootType.TEST_SOURCE)) {
            jpsElementType = (JpsElementType)KotlinSourceRootType.TestSource.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaResourceRootType.RESOURCE)) {
            jpsElementType = (JpsElementType)KotlinResourceRootType.Resource.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaResourceRootType.TEST_RESOURCE)) {
            jpsElementType = (JpsElementType)KotlinResourceRootType.TestResource.INSTANCE;
        } else {
            return null;
        }
        if (jpsElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.jps.model.module.JpsModuleSourceRootType<org.jetbrains.jps.model.JpsElement>");
        }
        JpsModuleSourceRootType newSourceRootType = (JpsModuleSourceRootType)jpsElementType;
        return TuplesKt.to((Object)newSourceRootType, (Object)ProjectRootUtilsKt.getOrCreateProperties($receiver));
    }

    /*
     * WARNING - void declaration
     */
    public static final void migrateNonJvmSourceFolders(@NotNull ModifiableRootModel modifiableRootModel) {
        Intrinsics.checkParameterIsNotNull((Object)modifiableRootModel, (String)"modifiableRootModel");
        ContentEntry[] contentEntryArray = modifiableRootModel.getContentEntries();
        int n = contentEntryArray.length;
        for (int j = 0; j < n; ++j) {
            ContentEntry contentEntry;
            ContentEntry contentEntry2 = contentEntry = contentEntryArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry2, (String)"contentEntry");
            SourceFolder[] sourceFolderArray = contentEntry2.getSourceFolders();
            int n2 = sourceFolderArray.length;
            for (int k = 0; k < n2; ++k) {
                void newSourceRootType;
                String url;
                Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> pair2;
                SourceFolder sourceFolder;
                SourceFolder sourceFolder2 = sourceFolder = sourceFolderArray[k];
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolder2, (String)"sourceFolder");
                JpsModuleSourceRoot jpsModuleSourceRoot = sourceFolder2.getJpsElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRoot, (String)"sourceFolder.jpsElement");
                if (ProjectRootUtilsKt.getMigratedSourceRootTypeWithProperties(jpsModuleSourceRoot) == null) {
                    continue;
                }
                JpsModuleSourceRootType jpsModuleSourceRootType = (JpsModuleSourceRootType)pair2.component1();
                JpsElement properties2 = (JpsElement)pair2.component2();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolder.getUrl(), (String)"sourceFolder.url");
                contentEntry.removeSourceFolder(sourceFolder);
                contentEntry.addSourceFolder(url, (JpsModuleSourceRootType)newSourceRootType, properties2);
            }
        }
    }
}

