/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CompilerSettingsKt;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeModuleExperimentalFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "module", "Lcom/intellij/openapi/module/Module;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/name/FqName;)V", "compilerArgument", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "Companion", "idea"})
public final class MakeModuleExperimentalFix
extends KotlinQuickFixAction<KtFile> {
    private final String compilerArgument;
    private final Module module;
    private final FqName annotationFqName;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Add '-Xuse-experimental=" + this.annotationFqName + "' to module " + this.module.getName() + " compiler arguments";
    }

    @NotNull
    public String getFamilyName() {
        return "Make module experimental";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(project);
        try {
            CompilerSettings compilerSettings;
            KotlinFacet facet = FacetUtilsKt.getOrCreateFacet$default(this.module, (IdeModifiableModelsProvider)modelsProvider, false, null, true, 4, null);
            KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
            CompilerSettings compilerSettings2 = facetSettings.getCompilerSettings();
            if (compilerSettings2 == null) {
                CompilerSettings compilerSettings3;
                CompilerSettings it = compilerSettings3 = new CompilerSettings();
                facetSettings.setCompilerSettings(it);
                compilerSettings2 = compilerSettings3;
            }
            CompilerSettings compilerSettings4 = compilerSettings = compilerSettings2;
            compilerSettings4.setAdditionalArguments(compilerSettings4.getAdditionalArguments() + ' ' + this.compilerArgument);
            facetSettings.updateMergedArguments();
            RootUtilsKt.invalidateProjectRoots(project);
        }
        finally {
            modelsProvider.dispose();
        }
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        boolean bl;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            if (Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(this.module), (Object)BuildSystemType.JPS.INSTANCE) ^ true) {
                return false;
            }
            KotlinFacet kotlinFacet = KotlinFacet.Companion.get(this.module);
            if (kotlinFacet == null) {
                return true;
            }
            KotlinFacet facet = kotlinFacet;
            KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
            CompilerSettings compilerSettings = facetSettings.getCompilerSettings();
            if (compilerSettings == null) {
                return true;
            }
            CompilerSettings compilerSettings2 = compilerSettings;
            if (Intrinsics.areEqual((Object)this.annotationFqName, (Object)ExperimentalUsageChecker.Companion.getEXPERIMENTAL_FQ_NAME()) ^ true) {
                bl = !CompilerSettingsKt.getAdditionalArgumentsAsList((CompilerSettings)compilerSettings2).contains(this.compilerArgument);
            } else {
                Iterable $receiver$iv = CompilerSettingsKt.getAdditionalArgumentsAsList((CompilerSettings)compilerSettings2);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!(StringsKt.startsWith$default((String)it, (String)"-Xuse-experimental=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"-Xexperimental=", (boolean)false, (int)2, null))) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    public MakeModuleExperimentalFix(@NotNull KtFile file, @NotNull Module module, @NotNull FqName annotationFqName) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)annotationFqName, (String)"annotationFqName");
        super((PsiElement)file);
        this.module = module;
        this.annotationFqName = annotationFqName;
        this.compilerArgument = "-Xuse-experimental=" + this.annotationFqName;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeModuleExperimentalFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiFile psiFile = psiElement2.getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile = (KtFile)psiFile;
            if (ktFile == null) {
                return null;
            }
            KtFile containingKtFile = ktFile;
            Module module = ProjectStructureUtilKt.getModule((PsiElement)containingKtFile);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            return new MakeModuleExperimentalFix(containingKtFile, module2, ExperimentalUsageChecker.Companion.getEXPERIMENTAL_FQ_NAME());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

