/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualClassFix;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.MultiTargetPlatformKt;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/OptionalExpectationInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class OptionalExpectationInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return VisitorWrappersKt.classOrObjectVisitor((Function1<? super KtClassOrObject, Unit>)((Function1)new Function1<KtClassOrObject, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtClassOrObject classOrObject) {
                Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
                if (!(classOrObject instanceof KtClass) || !classOrObject.isAnnotation()) {
                    return;
                }
                if (!PsiUtilsKt.hasExpectModifier(classOrObject)) {
                    return;
                }
                ClassDescriptor classDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(classOrObject, null, 1, null);
                if (classDescriptor2 == null) {
                    return;
                }
                ClassDescriptor descriptor2 = classDescriptor2;
                if (!descriptor2.getAnnotations().hasAnnotation(ExpectedActualDeclarationChecker.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME())) {
                    return;
                }
                List<ModuleDescriptor> implementingModules2 = MultiplatformUtilKt.getImplementingDescriptors(ResolutionUtils.findModuleDescriptor(classOrObject));
                if (implementingModules2.isEmpty()) {
                    return;
                }
                for (ModuleDescriptor actualModuleDescriptor : implementingModules2) {
                    MultiTargetPlatform.Specific platform2;
                    ModuleSourceInfo moduleSourceInfo;
                    ModuleInfo moduleInfo2;
                    Object displayedName;
                    MultiTargetPlatform multiTargetPlatform;
                    Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> compatibility;
                    if (ExpectedActualResolver.INSTANCE.findActualForExpected(descriptor2, actualModuleDescriptor) == null) {
                        continue;
                    }
                    if (!ExpectedActualDeclarationChecker.INSTANCE.allStrongIncompatibilities(compatibility)) {
                        boolean bl;
                        block18: {
                            Iterator<T> destination$iv;
                            Iterable $receiver$iv;
                            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map2 = compatibility;
                            Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> map3 = map2;
                            Object object = ExpectedActualResolver.Compatibility.Compatible.INSTANCE;
                            if (map3.containsKey(object)) continue;
                            map2 = compatibility.values();
                            object = new HashSet<E>();
                            for (E element$iv : $receiver$iv) {
                                List it = (List)element$iv;
                                Iterable list$iv = it;
                                CollectionsKt.addAll((Collection)((Object)destination$iv), (Iterable)list$iv);
                            }
                            $receiver$iv = (Iterable)((Object)destination$iv);
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl = true;
                            } else {
                                destination$iv = $receiver$iv.iterator();
                                while (destination$iv.hasNext()) {
                                    T element$iv = destination$iv.next();
                                    MemberDescriptor actual = (MemberDescriptor)element$iv;
                                    Map<ExpectedActualResolver.Compatibility, List<MemberDescriptor>> expectedOnes = ExpectedActualResolver.INSTANCE.findExpectedForActual(actual, DescriptorUtilsKt.getModule(descriptor2));
                                    if (expectedOnes != null && expectedOnes.keySet().contains(ExpectedActualResolver.Compatibility.Compatible.INSTANCE)) continue;
                                    bl = false;
                                    break block18;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) continue;
                    }
                    if (!((multiTargetPlatform = MultiTargetPlatformKt.getMultiTargetPlatform(actualModuleDescriptor)) instanceof MultiTargetPlatform.Specific)) {
                        multiTargetPlatform = null;
                    }
                    if ((MultiTargetPlatform.Specific)multiTargetPlatform == null) {
                        continue;
                    }
                    Object object = actualModuleDescriptor.getCapability(ModuleInfo.Companion.getCapability());
                    if (object == null || (object = object.getDisplayedName()) == null) {
                        object = displayedName = "";
                    }
                    if (!((moduleInfo2 = actualModuleDescriptor.getCapability(ModuleInfo.Companion.getCapability())) instanceof ModuleSourceInfo)) {
                        moduleInfo2 = null;
                    }
                    if ((moduleSourceInfo = (ModuleSourceInfo)moduleInfo2) == null || (moduleSourceInfo = moduleSourceInfo.getModule()) == null) {
                        continue;
                    }
                    ModuleSourceInfo actualModule = moduleSourceInfo;
                    PsiElement psiElement2 = ((KtClass)classOrObject).getNameIdentifier();
                    if (psiElement2 == null) {
                        psiElement2 = classOrObject;
                    }
                    this.$holder.registerProblem(psiElement2, "Optionally expected annotation has no actual annotation in module " + (String)displayedName + " for platform " + platform2.getPlatform(), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new CreateActualClassFix(classOrObject, (Module)actualModule, platform2), ((KtClass)classOrObject).getContainingFile())});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

