/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.text.VersionComparatorUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.idea.configuration.ExternalLibraryInfo;
import org.jetbrains.kotlin.idea.configuration.LibraryUtilsKt;
import org.jetbrains.kotlin.idea.configuration.MigrationInfo;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.LibInfo;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\u00020\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"BUILD_SRC_FOLDER_NAME", "", "KOTLIN_GROUP_ID", "collectMaxCompilerSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lcom/intellij/openapi/project/Project;", "maxKotlinLibVersion", "Lorg/jetbrains/kotlin/idea/versions/LibInfo;", "isKotlinModule", "", "Lcom/intellij/openapi/module/Module;", "isLanguageVersionUpdate", "Lorg/jetbrains/kotlin/idea/configuration/MigrationInfo;", "old", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "new", "idea"})
public final class KotlinMigrationProjectComponentKt {
    private static final String BUILD_SRC_FOLDER_NAME = "buildSrc";
    private static final String KOTLIN_GROUP_ID = "org.jetbrains.kotlin";

    public static final boolean isLanguageVersionUpdate(@NotNull MigrationInfo $receiver, @NotNull LanguageVersion old, @NotNull LanguageVersion languageVersion) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)languageVersion, (String)"new");
        return $receiver.getOldLanguageVersion().compareTo((Enum)old) <= 0 && $receiver.getNewLanguageVersion().compareTo((Enum)languageVersion) >= 0;
    }

    private static final LibInfo maxKotlinLibVersion(Project project) {
        return (LibInfo)ApplicationUtilsKt.runReadAction((Function0)new Function0<LibInfo>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final LibInfo invoke() {
                void var1_1;
                LibInfo maxStdlibInfo = null;
                CommonProcessors.CollectUniquesProcessor allLibProcessor = new CommonProcessors.CollectUniquesProcessor();
                ProjectRootManager.getInstance((Project)this.$project).orderEntries().forEachLibrary((Processor)allLibProcessor);
                for (Library library : allLibProcessor.getResults()) {
                    ExternalLibraryInfo libraryInfo;
                    if (!ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)KotlinLibraryUtilKt.getGRADLE_SYSTEM_ID()) && !ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)KotlinLibraryUtilKt.getMAVEN_SYSTEM_ID())) continue;
                    Library library2 = library;
                    Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
                    String string = library2.getName();
                    if (string == null) continue;
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)" org.jetbrains.kotlin:kotlin-stdlib", (boolean)false, (int)2, null)) {
                        continue;
                    }
                    if (LibraryUtilsKt.parseExternalLibraryName(library) == null) {
                        continue;
                    }
                    if (maxStdlibInfo != null && VersionComparatorUtil.COMPARATOR.compare(libraryInfo.getVersion(), maxStdlibInfo.getVersion()) <= 0) continue;
                    maxStdlibInfo = new LibInfo("org.jetbrains.kotlin", libraryInfo.getArtifactId(), libraryInfo.getVersion());
                }
                return var1_1;
            }
            {
                this.$project = project;
                super(0);
            }
        });
    }

    private static final LanguageVersionSettings collectMaxCompilerSettings(Project project) {
        return (LanguageVersionSettings)ApplicationUtilsKt.runReadAction((Function0)new Function0<LanguageVersionSettingsImpl>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final LanguageVersionSettingsImpl invoke() {
                ApiVersion apiVersion;
                ApiVersion maxApiVersion = null;
                LanguageVersion maxLanguageVersion = null;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                int n = moduleArray.length;
                for (int j = 0; j < n; ++j) {
                    Module module;
                    Module module2 = module = moduleArray[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
                    if (!KotlinMigrationProjectComponentKt.access$isKotlinModule(module2)) continue;
                    LanguageVersionSettings languageVersionSettings = PlatformKt.getLanguageVersionSettings(module);
                    if (maxApiVersion == null || languageVersionSettings.getApiVersion().compareTo(maxApiVersion) > 0) {
                        maxApiVersion = languageVersionSettings.getApiVersion();
                    }
                    if (maxLanguageVersion != null && languageVersionSettings.getLanguageVersion().compareTo((Enum)maxLanguageVersion) <= 0) continue;
                    maxLanguageVersion = languageVersionSettings.getLanguageVersion();
                }
                LanguageVersion languageVersion = maxLanguageVersion;
                if (languageVersion == null) {
                    languageVersion = LanguageVersion.LATEST_STABLE;
                }
                if ((apiVersion = maxApiVersion) == null) {
                    apiVersion = ApiVersion.LATEST_STABLE;
                }
                return new LanguageVersionSettingsImpl(languageVersion, apiVersion, null, null, 12, null);
            }
            {
                this.$project = project;
                super(0);
            }
        });
    }

    private static final boolean isKotlinModule(@NotNull Module $receiver) {
        if ($receiver.isDisposed()) {
            return false;
        }
        return KotlinFacet.Companion.get($receiver) != null;
    }

    @Nullable
    public static final /* synthetic */ LibInfo access$maxKotlinLibVersion(@NotNull Project project) {
        return KotlinMigrationProjectComponentKt.maxKotlinLibVersion(project);
    }

    @NotNull
    public static final /* synthetic */ LanguageVersionSettings access$collectMaxCompilerSettings(@NotNull Project project) {
        return KotlinMigrationProjectComponentKt.collectMaxCompilerSettings(project);
    }

    public static final /* synthetic */ boolean access$isKotlinModule(@NotNull Module $receiver) {
        return KotlinMigrationProjectComponentKt.isKotlinModule($receiver);
    }
}

