/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PackageCodegenImpl;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class SamWrapperCodegen {
    private static final String FUNCTION_FIELD_NAME = "function";
    private final GenerationState state;
    private final boolean isInsideInline;
    private final KotlinTypeMapper typeMapper;
    private final SamType samType;
    private final MemberCodegen<?> parentCodegen;
    private final int visibility;
    public static final String SAM_WRAPPER_SUFFIX = "$0";

    public SamWrapperCodegen(@NotNull GenerationState state, @NotNull SamType samType, @NotNull MemberCodegen<?> parentCodegen, boolean isInsideInline) {
        this.state = state;
        this.isInsideInline = isInsideInline;
        this.typeMapper = state.getTypeMapper();
        this.samType = samType;
        this.parentCodegen = parentCodegen;
        this.visibility = isInsideInline ? 1 : 0;
    }

    @NotNull
    public Type genWrapper(@NotNull KtFile file, @NotNull CallableMemberDescriptor contextDescriptor) {
        FqName fqName2 = this.getWrapperName(file, contextDescriptor);
        Type asmType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fqName2);
        KotlinType functionType2 = this.samType.getKotlinFunctionType();
        ClassDescriptorImpl classDescriptor2 = new ClassDescriptorImpl(this.samType.getJavaClassDescriptor().getContainingDeclaration(), fqName2.shortName(), Modality.FINAL, ClassKind.CLASS, Collections.singleton(this.samType.getType()), SourceElement.NO_SOURCE, false, LockBasedStorageManager.NO_LOCKS);
        SimpleFunctionDescriptor erasedInterfaceFunction = this.samType.getOriginalAbstractMethod().copy(classDescriptor2, Modality.FINAL, Visibilities.PUBLIC, CallableMemberDescriptor.Kind.SYNTHESIZED, false);
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), asmType, (PsiFile)file);
        cv.defineClass((PsiElement)file, this.state.getClassFileVersion(), 0x30 | this.visibility, asmType.getInternalName(), null, AsmTypes.OBJECT_TYPE.getInternalName(), new String[]{this.typeMapper.mapType(this.samType.getType()).getInternalName()});
        cv.visitSource(file.getName(), null);
        WriteAnnotationUtilKt.writeSyntheticClassMetadata(cv, this.state);
        Type functionAsmType = this.typeMapper.mapType(functionType2);
        cv.newField(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), 4114, FUNCTION_FIELD_NAME, functionAsmType.getDescriptor(), null, null);
        this.generateConstructor(asmType, functionAsmType, cv);
        this.generateMethod(asmType, functionAsmType, cv, erasedInterfaceFunction, functionType2);
        cv.done();
        return asmType;
    }

    private void generateConstructor(Type ownerType, Type functionType2, ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(JvmDeclarationOriginKt.OtherOrigin(this.samType.getJavaClassDescriptor()), this.visibility, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{functionType2}), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.invokespecial(AsmTypes.OBJECT_TYPE.getInternalName(), "<init>", "()V", false);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.load(1, functionType2);
            iv.putfield(ownerType.getInternalName(), FUNCTION_FIELD_NAME, functionType2.getDescriptor());
            iv.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)iv, "constructor of SAM wrapper");
        }
    }

    private void generateMethod(Type ownerType, Type functionType2, ClassBuilder cv, SimpleFunctionDescriptor erasedInterfaceFunction, KotlinType functionJetType) {
        FunctionCodegen codegen = new FunctionCodegen(this.state.getRootContext().intoClass((ClassDescriptor)erasedInterfaceFunction.getContainingDeclaration(), OwnerKind.IMPLEMENTATION, this.state), cv, this.state, this.parentCodegen);
        SimpleFunctionDescriptor invokeFunction = functionJetType.getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.FROM_BACKEND).iterator().next().getOriginal();
        StackValue.Field functionField = StackValue.field(functionType2, ownerType, FUNCTION_FIELD_NAME, false, StackValue.none());
        codegen.genSamDelegate(erasedInterfaceFunction, invokeFunction, functionField);
        SimpleFunctionDescriptor originalInterfaceErased = this.samType.getOriginalAbstractMethod();
        SimpleFunctionDescriptorImpl descriptorForBridges = SimpleFunctionDescriptorImpl.create(erasedInterfaceFunction.getContainingDeclaration(), erasedInterfaceFunction.getAnnotations(), originalInterfaceErased.getName(), CallableMemberDescriptor.Kind.DECLARATION, erasedInterfaceFunction.getSource());
        descriptorForBridges.initialize((ReceiverParameterDescriptor)null, originalInterfaceErased.getDispatchReceiverParameter(), originalInterfaceErased.getTypeParameters(), (List)originalInterfaceErased.getValueParameters(), originalInterfaceErased.getReturnType(), Modality.OPEN, originalInterfaceErased.getVisibility());
        DescriptorUtilsKt.setSingleOverridden(descriptorForBridges, originalInterfaceErased);
        codegen.generateBridges(descriptorForBridges);
    }

    @NotNull
    private FqName getWrapperName(@NotNull KtFile containingFile, CallableMemberDescriptor contextDescriptor) {
        FqName outermostOwner;
        boolean hasPackagePartClass = CollectionsKt.any(CodegenUtil.getDeclarationsToGenerate(containingFile, this.state.getBindingContext()), PackageCodegenImpl::isFilePartDeclaration);
        FqName filePartFqName = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile).getFileClassFqName();
        if (hasPackagePartClass) {
            outermostOwner = filePartFqName;
        } else {
            ClassDescriptor outermostClassifier = SamWrapperCodegen.getOutermostParentClass(contextDescriptor);
            if (outermostClassifier == null) {
                throw new IllegalStateException("Can't find outermost parent class for " + contextDescriptor);
            }
            String internalName = this.typeMapper.mapType(outermostClassifier).getInternalName();
            outermostOwner = filePartFqName.parent().child(Name.identifier(StringsKt.substringAfterLast((String)internalName, (char)'/', (String)internalName)));
        }
        String shortName = String.format("%s$sam%s$%s$0", outermostOwner.shortName().asString(), this.isInsideInline ? "$i" : "", DescriptorUtils.getFqNameSafe(this.samType.getJavaClassDescriptor()).asString().replace('.', '_'));
        return outermostOwner.parent().child(Name.identifier(shortName));
    }

    private static ClassDescriptor getOutermostParentClass(CallableMemberDescriptor contextDescriptor) {
        ClassDescriptor next2;
        ClassDescriptor parent2 = DescriptorUtils.getParentOfType(contextDescriptor, ClassDescriptor.class, true);
        do {
            if ((next2 = DescriptorUtils.getParentOfType(parent2, ClassDescriptor.class, true)) == null) continue;
            parent2 = next2;
        } while (next2 != null);
        return parent2;
    }
}

