/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.persistence.integration.utils.IntegrationUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringHibernateSessionFactoryProvider
implements PersistencePackagesProvider {
    private static final Key<CachedValue<List<PersistencePackage>>> SPRING_SESSION_FACTORIES_KEY = Key.create((String)"SPRING_SESSION_FACTORIES_KEY");

    @NotNull
    public List<PersistencePackage> getPersistencePackages(PersistenceFacet facet) {
        Module module = facet.getModule();
        if (!(facet instanceof HibernateFacet) || !module.isLoaded() || module.isDisposed() || !SpringCommonUtils.hasSpringFacet((Module)module) || DumbService.isDumb((Project)module.getProject())) {
            List<PersistencePackage> list = Collections.emptyList();
            if (list == null) {
                SpringHibernateSessionFactoryProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        Project project = module.getProject();
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, SPRING_SESSION_FACTORIES_KEY, () -> {
            HashSet result = new HashSet();
            SpringManager springManager = SpringManager.getInstance((Project)project);
            SpringModel springModel = springManager.getCombinedModel(module);
            PsiClass sessionFactoryClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.hibernate.SessionFactory");
            if (sessionFactoryClass != null) {
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)sessionFactoryClass).withInheritors().effectiveBeanTypes();
                for (SpringBeanPointer bean : SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters)) {
                    Function<Pair<SpringBeanPointer, PersistenceFacet>, PersistencePackage> provider = IntegrationUtil.getProvider(bean, IntegrationUtil.myProviders, true);
                    if (provider == null) continue;
                    PersistencePackage unit = (PersistencePackage)provider.fun((Object)Pair.create((Object)bean, (Object)facet));
                    if (bean.isAbstract()) continue;
                    result.add(unit);
                }
            }
            ArrayList factories = new ArrayList(result);
            HashSet dependencies = new HashSet();
            dependencies.addAll(ContainerUtil.newArrayList((Object[])SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsDependencies()));
            dependencies.addAll(SpringModelVisitorUtils.getConfigFiles((CommonSpringModel)springModel));
            return CachedValueProvider.Result.create(factories, (Object[])springManager.getModelsDependencies(module, ArrayUtil.toObjectArray((Collection)dependencies)));
        }, false);
        if (list == null) {
            SpringHibernateSessionFactoryProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/hibernate/SpringHibernateSessionFactoryProvider", "getPersistencePackages"));
    }
}

