/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiDisposerMethodInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(0);
        }
        List<PsiMethod> methods = CdiCommonUtils.getDisposerMethods(aClass);
        for (PsiMethod method : methods) {
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) continue;
            if (method.getModifierList().hasModifierProperty("abstract")) {
                holder.registerProblem((PsiElement)nameIdentifier, CdiInspectionBundle.message("CdiDisposerMethodInspection.non.abstract.disposer.method", new Object[0]), new LocalQuickFix[0]);
            }
            if (CdiDisposerMethodInspection.getDisposeParameters(method).size() <= 1) continue;
            holder.registerProblem((PsiElement)nameIdentifier, CdiInspectionBundle.message("CdiDisposerMethodInspection.too.many.dispose.parameters", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static Set<PsiParameter> getDisposeParameters(@NotNull PsiMethod method) {
        if (method == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(1);
        }
        HashSet<PsiParameter> disposedParameters = new HashSet<PsiParameter>();
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.inject.Disposes", (int)1)) continue;
            disposedParameters.add(psiParameter);
        }
        return disposedParameters;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.disposer.method.errors", new Object[0]);
        if (string == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiDisposerMethodInspection" == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(3);
        }
        return "CdiDisposerMethodInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            CdiDisposerMethodInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/highlighting/CdiDisposerMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/highlighting/CdiDisposerMethodInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDisposeParameters";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

