/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.managers;

import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.diagram.edges.CdiDependencyType;
import com.intellij.cdi.diagram.edges.CdiDiagramEdge;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class CdiDiagramColorManager
extends DiagramColorManagerBase {
    public Color getEdgeColor(DiagramEdge edge) {
        if (edge instanceof CdiDiagramEdge) {
            CdiDependencyType type = ((CdiDiagramEdge)edge).getDependencyType();
            switch (type) {
                case INJECTED: 
                case OUTJECTED: {
                    return DEFAULT_EDGE_COLOR;
                }
                case PRODUCES: {
                    return JBColor.BLUE.darker();
                }
            }
        }
        return super.getEdgeColor(edge);
    }

    public Color getNodeBackground(Project project, Object nodeElement, boolean selected) {
        if (nodeElement instanceof InjectionPointDescriptor) {
            return super.getNodeBackground(project, (Object)((InjectionPointDescriptor)nodeElement).getOwner(), selected);
        }
        return super.getNodeBackground(project, nodeElement, selected);
    }

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        Object element;
        if (node != null && (element = node.getIdentifyingElement()) instanceof CdiBeanPsiClassDescriptor && CdiCommonUtils.isDecorator((PsiClass)((CdiBeanPsiClassDescriptor)element).getIdentifyingElement())) {
            return JBColor.LIGHT_GRAY;
        }
        return super.getNodeHeaderColor(builder, node);
    }
}

