/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.ui;

import com.google.common.primitives.Ints;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainerModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianExistLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianLibraryModel;
import com.intellij.plugins.jboss.arquillian.configuration.remoteDebugger.ui.RemoteDebuggerPanel;
import com.intellij.plugins.jboss.arquillian.configuration.ui.AddExistLibraryAction;
import com.intellij.plugins.jboss.arquillian.configuration.ui.AddLibraryAction;
import com.intellij.plugins.jboss.arquillian.configuration.ui.AddMavenDependencyAction;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.action.OpenBrowserAction;
import org.jetbrains.annotations.NotNull;

public class ArquillianContainerSettings {
    @NotNull
    private final Project project;
    @NotNull
    private final ArquillianContainer container;
    @NotNull
    private final ArquillianContainerModel model;
    private JPanel mainPanel;
    private JPanel librariesPanel;
    private JPanel containerNamePanel;
    private JPanel bottomPanel;
    private JPanel remoteDebugPanel;
    private JBTextField runContainerQualifier;
    private JBTextField debugContainerQualifier;
    private RemoteDebuggerPanel remoteDebuggerPanel;
    private JBList repositoryLibraries;
    private LabeledComponent<RawCommandLineEditor> myVMParametersComponent;
    private EnvironmentVariablesComponent myEnvVariablesComponent;

    public ArquillianContainerSettings(@NotNull Project project, @NotNull ArquillianContainer container, final @NotNull ArquillianContainerModel model) {
        if (project == null) {
            ArquillianContainerSettings.$$$reportNull$$$0(0);
        }
        if (container == null) {
            ArquillianContainerSettings.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ArquillianContainerSettings.$$$reportNull$$$0(2);
        }
        this.project = project;
        this.container = container;
        this.model = model;
        this.$$$setupUI$$$();
        ListModel listModel = model.createListModel();
        this.repositoryLibraries.setModel(listModel);
        String descriptionUri = container.getDescriptionUri();
        if (descriptionUri == null) {
            this.containerNamePanel.add(new JLabel(container.getName()));
        } else {
            OpenBrowserAction linkAction = new OpenBrowserAction(descriptionUri);
            JXHyperlink hyperlink = new JXHyperlink((Action)linkAction);
            hyperlink.setText(container.getName());
            this.containerNamePanel.add((Component)hyperlink);
        }
        this.librariesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ArquillianBundle.message("arquillian.libraries.title", new Object[0])));
        this.initComponents();
        this.bottomPanel.setLayout((LayoutManager)new VerticalFlowLayout(1, 0, 5, true, false));
        this.bottomPanel.add((Component)this.myVMParametersComponent);
        this.bottomPanel.add((Component)this.myEnvVariablesComponent);
        this.debugContainerQualifier.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                model.getRemoteDebuggerModel().setDebugContainerQualifier(ArquillianContainerSettings.this.debugContainerQualifier.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$1", "textChanged"));
            }
        });
        this.debugContainerQualifier.setText(model.getRemoteDebuggerModel().getDebugContainerQualifier());
        this.runContainerQualifier.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                model.getRemoteDebuggerModel().setRunContainerQualifier(ArquillianContainerSettings.this.runContainerQualifier.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$2", "textChanged"));
            }
        });
        this.runContainerQualifier.setText(model.getRemoteDebuggerModel().getRunContainerQualifier());
    }

    private void initComponents() {
        this.myVMParametersComponent = LabeledComponent.create((JComponent)new RawCommandLineEditor(), (String)ExecutionBundle.message((String)"run.configuration.java.vm.parameters.label", (Object[])new Object[0]), (String)"West");
        ((RawCommandLineEditor)this.myVMParametersComponent.getComponent()).setText(this.model.getJvmParameters());
        ((RawCommandLineEditor)this.myVMParametersComponent.getComponent()).getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ArquillianContainerSettings.this.model.setJvmParameters(((RawCommandLineEditor)ArquillianContainerSettings.this.myVMParametersComponent.getComponent()).getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$3", "textChanged"));
            }
        });
        this.copyDialogCaption(this.myVMParametersComponent);
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        this.myEnvVariablesComponent.setLabelLocation("West");
        this.myEnvVariablesComponent.setEnvs(this.model.getEnvVariables());
        ((TextFieldWithBrowseButton)this.myEnvVariablesComponent.getComponent()).getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                ArquillianContainerSettings.this.model.setEnvVariables(ArquillianContainerSettings.this.myEnvVariablesComponent.getEnvs());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$4", "textChanged"));
            }
        });
        this.myEnvVariablesComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ArquillianContainerSettings.this.model.setEnvVariables(ArquillianContainerSettings.this.myEnvVariablesComponent.getEnvs());
            }
        });
        this.myVMParametersComponent.setAnchor((JComponent)this.myEnvVariablesComponent.getLabel());
        this.remoteDebuggerPanel = new RemoteDebuggerPanel(this.model.getRemoteDebuggerModel());
        this.remoteDebugPanel.add(this.remoteDebuggerPanel.getMainPanel());
    }

    protected void copyDialogCaption(LabeledComponent<RawCommandLineEditor> component) {
        RawCommandLineEditor rawCommandLineEditor = (RawCommandLineEditor)component.getComponent();
        rawCommandLineEditor.setDialogCaption(component.getRawText());
        component.getLabel().setLabelFor((Component)rawCommandLineEditor.getTextField());
    }

    private void createUIComponents() {
        this.repositoryLibraries = new JBList();
        this.repositoryLibraries.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                ArquillianLibraryModel model = (ArquillianLibraryModel)value;
                this.setText(model.getDescription());
                Icon icon = model.getIcon();
                this.setForeground((Color)(icon == null ? JBColor.RED : JBColor.BLACK));
                this.setIcon(icon);
                return this;
            }
        });
        this.repositoryLibraries.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                int index = ArquillianContainerSettings.this.repositoryLibraries.locationToIndex(evt.getPoint());
                ((ArquillianLibraryModel)ArquillianContainerSettings.this.model.getChildren().get(index)).editProperties(ArquillianContainerSettings.this.project);
                super.mouseClicked(evt);
            }
        });
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.repositoryLibraries).disableUpDownActions().setToolbarPosition(ActionToolbarPosition.RIGHT).setAddActionName(ArquillianBundle.message("arquillian.container.add.library", new Object[0])).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                return ArquillianContainerSettings.this.container.canChangeDependencyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$13", "isEnabled"));
            }
        }).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AddLibraryAction>("Library type", new AddLibraryAction[]{new AddExistLibraryAction(ArquillianContainerSettings.this.project), new AddMavenDependencyAction(ArquillianContainerSettings.this.project, button.getContextComponent())}){

                    public Icon getIconFor(AddLibraryAction action) {
                        return action.getIcon();
                    }

                    public boolean hasSubstep(AddLibraryAction action) {
                        return false;
                    }

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public PopupStep onChosen(AddLibraryAction selectedValue, boolean finalChoice) {
                        return this.doFinalStep(() -> ArquillianContainerSettings.this.addLibraries(selectedValue.execute()));
                    }

                    @NotNull
                    public String getTextFor(AddLibraryAction action) {
                        String string = action.getText();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$12$1", "getTextFor"));
                    }
                }).show(button.getPreferredPopupPoint());
            }
        }).setRemoveActionName(ArquillianBundle.message("arquillian.container.remove.library", new Object[0])).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                return ArquillianContainerSettings.this.container.canChangeDependencyList() && ArquillianContainerSettings.this.repositoryLibraries.getSelectedIndex() != -1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$11", "isEnabled"));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List items = JBIterable.from((Iterable)Ints.asList((int[])ArquillianContainerSettings.this.repositoryLibraries.getSelectedIndices())).transform(i -> (ArquillianLibraryModel)ArquillianContainerSettings.this.model.getChildren().get((int)i)).toList();
                for (ArquillianLibraryModel item : items) {
                    ArquillianContainerSettings.this.model.removeItem(item);
                }
            }
        }).setEditActionName(ArquillianBundle.message("arquillian.container.edit.library", new Object[0])).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                return ArquillianContainerSettings.this.repositoryLibraries.getSelectedIndices().length == 1 && !(ArquillianContainerSettings.this.repositoryLibraries.getSelectedValue() instanceof ArquillianExistLibraryModel);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings$9", "isEnabled"));
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ((ArquillianLibraryModel)ArquillianContainerSettings.this.repositoryLibraries.getSelectedValue()).editProperties(ArquillianContainerSettings.this.project);
            }
        });
        this.librariesPanel = toolbarDecorator.createPanel();
    }

    private void addLibraries(Collection<ArquillianLibraryModel> libraries) {
        if (libraries == null) {
            return;
        }
        for (ArquillianLibraryModel library : libraries) {
            this.model.addItem(library);
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "container";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/intellij/plugins/jboss/arquillian/configuration/ui/ArquillianContainerSettings";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JPanel jPanel;
        JBTextField jBTextField2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(5, 5, 5, 5), 0, 0, false, false));
        JPanel jPanel5 = this.librariesPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 200), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ArquillianBundle").getString("arquillian.container.name.label"));
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.containerNamePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 5, -1));
        jPanel6.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null, 1));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.bottomPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel4.add((Component)jBTabbedPane, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Run", null, jPanel7, null);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 5, 5, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.runContainerQualifier = jBTextField2 = new JBTextField();
        jPanel8.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, new Dimension(200, -1), null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ArquillianBundle").getString("arquillian.container.qualifier"));
        jPanel8.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel7.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Debug", null, jPanel9, null);
        this.remoteDebugPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 5, 5, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.debugContainerQualifier = jBTextField = new JBTextField();
        jPanel10.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, new Dimension(200, -1), null, null));
        Spacer spacer5 = new Spacer();
        jPanel10.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ArquillianBundle").getString("arquillian.container.qualifier"));
        jPanel10.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

