/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.container;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerParameter;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianMavenCoordinates;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainerModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.util.xmlb.Converter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArquillianContainer {
    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Scope getScope();

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public abstract String getDescriptionUri();

    @NotNull
    public abstract ArquillianContainerState createDefaultState(Project var1, String var2);

    @NotNull
    public abstract List<ArquillianMavenCoordinates> getDependencies();

    public abstract List<ArquillianContainerParameter> getParameters();

    public abstract JPanel createSettingsPanel(Project var1, ArquillianContainerModel var2);

    public abstract boolean canChangeDependencyList();

    class ScopeConverter
    extends Converter<Scope> {
        ScopeConverter() {
        }

        @Nullable
        public Scope fromString(@NotNull String value) {
            if (value == null) {
                ScopeConverter.$$$reportNull$$$0(0);
            }
            return Scope.fromString(value);
        }

        @NotNull
        public String toString(@NotNull Scope scope) {
            if (scope == null) {
                ScopeConverter.$$$reportNull$$$0(1);
            }
            String string = scope.getDescription();
            if (string == null) {
                ScopeConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainer$ScopeConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainer$ScopeConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Scope implements Comparable<Scope>
    {
        Manual(ArquillianBundle.message("arquillian.manual.configuration.name", new Object[0]), 1000),
        Embedded(ArquillianBundle.message("arquillian.embedded.configuration.name", new Object[0]), 2000),
        Managed(ArquillianBundle.message("arquillian.managed.configuration.name", new Object[0]), 3000),
        Remote(ArquillianBundle.message("arquillian.remote.configuration.name", new Object[0]), 4000);

        private static final Map<String, Scope> values;
        private final String description;
        private final int weight;

        private Scope(String description, int weight) {
            this.description = description;
            this.weight = weight;
        }

        public static Scope fromString(String strScope) {
            Scope scope = values.get(strScope);
            return scope == null ? Manual : scope;
        }

        public String getDescription() {
            return this.description;
        }

        public int getWeight() {
            return this.weight;
        }

        static {
            values = new HashMap<String, Scope>();
            for (Scope scope : Scope.values()) {
                values.put(scope.getDescription(), scope);
            }
        }
    }
}

