/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.tools.GroovyClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.groovy.compiler.rt.CompilerMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCompilerWrapper {
    private static final String LINKAGE_ERROR = "A groovyc error occurred while trying to load one of the classes in project dependencies, please ensure it's present. See the message and the stack trace below for reference\n\n";
    private static final String INCOMPATIBLE_CLASS_CHANGE_ERROR = "A groovyc error occurred while trying to load one of the classes in project dependencies. Please ensure its version is compatible with other jars (including Groovy ones) in the dependencies. See the message and the stack trace below for reference\n\n";
    private final List<? super CompilerMessage> collector;
    private boolean forStubs;
    private static final String LINE_AT = " @ line ";

    public GroovyCompilerWrapper(List<? super CompilerMessage> collector, boolean forStubs) {
        this.collector = collector;
        this.forStubs = forStubs;
    }

    public void onContinuation() {
        this.forStubs = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutputItem> compile(CompilationUnit unit, int throughPhase) {
        block20: {
            try {
                unit.compile(throughPhase);
                List<OutputItem> list = this.getCompiledFiles(unit);
                return list;
            }
            catch (CompilationFailedException e) {
                this.processCompilationException((Exception)((Object)e));
            }
            catch (IOException e) {
                this.processException(e, "");
            }
            catch (GroovyBugError e) {
                this.processException(e, "");
            }
            catch (NoClassDefFoundError e) {
                String className = e.getMessage();
                if (className.contains("org/apache/ivy/")) {
                    this.addMessageWithoutLocation("Cannot @Grab without Ivy, please add it to your module dependencies (NoClassDefFoundError: " + className + ")", true);
                    break block20;
                }
                throw e;
            }
            catch (TypeNotPresentException e) {
                this.processException(e, LINKAGE_ERROR);
            }
            catch (IncompatibleClassChangeError e) {
                this.processException(e, INCOMPATIBLE_CLASS_CHANGE_ERROR);
            }
            catch (LinkageError e) {
                if (e.getCause() instanceof GroovyRuntimeException) {
                    this.processException(e, GroovyCompilerWrapper.getExceptionMessage((GroovyRuntimeException)e.getCause()));
                } else {
                    this.processException(e, LINKAGE_ERROR);
                }
            }
            finally {
                this.addWarnings(unit.getErrorCollector());
            }
        }
        return Collections.emptyList();
    }

    private List<OutputItem> getCompiledFiles(CompilationUnit compilationUnit) throws IOException {
        File targetDirectory = compilationUnit.getConfiguration().getTargetDirectory();
        if (this.forStubs) {
            return GroovyCompilerWrapper.getStubOutputItems(compilationUnit, targetDirectory);
        }
        TreeSet<String> allClasses = new TreeSet<String>();
        List listOfClasses = compilationUnit.getClasses();
        for (GroovyClass listOfClass : listOfClasses) {
            allClasses.add(listOfClass.getName());
        }
        ArrayList<OutputItem> compiledFiles = new ArrayList<OutputItem>();
        for (SourceUnit sourceUnit : compilationUnit) {
            String fileName = sourceUnit.getName();
            ModuleNode ast = sourceUnit.getAST();
            List topLevelClasses = ast.getClasses();
            for (ClassNode classNode : topLevelClasses) {
                String className;
                String topLevel = classNode.getName();
                String nested = topLevel + "$";
                SortedSet<String> tail = allClasses.tailSet(topLevel);
                Iterator tailItr = tail.iterator();
                while (tailItr.hasNext() && ((className = (String)tailItr.next()).equals(topLevel) || className.startsWith(nested))) {
                    tailItr.remove();
                    compiledFiles.add(new OutputItem(targetDirectory, className.replace('.', '/') + ".class", fileName));
                }
            }
        }
        return compiledFiles;
    }

    @NotNull
    static List<OutputItem> getStubOutputItems(CompilationUnit compilationUnit, final File stubDirectory) {
        final ArrayList<OutputItem> compiledFiles = new ArrayList<OutputItem>();
        compilationUnit.applyToPrimaryClassNodes(new CompilationUnit.PrimaryClassNodeOperation(){

            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                OutputItem item;
                String topLevel = classNode.getName();
                String fileName = source.getName();
                if (fileName.startsWith("file:")) {
                    try {
                        fileName = new URL(fileName).getFile();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (new File((item = new OutputItem(stubDirectory, topLevel.replace('.', '/') + ".java", fileName)).getOutputPath()).exists()) {
                    compiledFiles.add(item);
                }
            }
        });
        ArrayList<OutputItem> arrayList = compiledFiles;
        if (arrayList == null) {
            GroovyCompilerWrapper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private void addWarnings(ErrorCollector errorCollector) {
        for (int i = 0; i < errorCollector.getWarningCount(); ++i) {
            WarningMessage warning = errorCollector.getWarning(i);
            this.collector.add(new CompilerMessage("warning", warning.getMessage(), null, -1, -1));
        }
    }

    private void processCompilationException(Exception exception) {
        if (exception instanceof MultipleCompilationErrorsException) {
            MultipleCompilationErrorsException multipleCompilationErrorsException = (MultipleCompilationErrorsException)exception;
            ErrorCollector errorCollector = multipleCompilationErrorsException.getErrorCollector();
            for (int i = 0; i < errorCollector.getErrorCount(); ++i) {
                this.processException(errorCollector.getError(i));
            }
        } else {
            this.processException(exception, "");
        }
    }

    private void processException(Message message) {
        if (message instanceof SyntaxErrorMessage) {
            SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)message;
            this.addErrorMessage(syntaxErrorMessage.getCause());
        } else if (message instanceof ExceptionMessage) {
            ExceptionMessage exceptionMessage = (ExceptionMessage)message;
            this.processException(exceptionMessage.getCause(), "");
        } else if (message instanceof SimpleMessage) {
            this.addErrorMessage((SimpleMessage)message);
        } else {
            this.addMessageWithoutLocation("An unknown error occurred: " + message, true);
        }
    }

    private void processException(Throwable exception, String prefix) {
        if (exception instanceof GroovyRuntimeException) {
            this.addErrorMessage((GroovyRuntimeException)exception);
            return;
        }
        if (this.forStubs) {
            this.collector.add(new CompilerMessage("information", "Groovyc stub generation failed", null, -1, -1));
        }
        StringWriter writer = new StringWriter();
        writer.append(prefix);
        if (!prefix.endsWith("\n")) {
            writer.append("\n\n");
        }
        exception.printStackTrace(new PrintWriter(writer));
        this.collector.add(new CompilerMessage(this.forStubs ? "information" : "error", writer.toString(), null, -1, -1));
    }

    private void addMessageWithoutLocation(String message, boolean error) {
        this.collector.add(new CompilerMessage(error ? "error" : "warning", message, null, -1, -1));
    }

    private void addErrorMessage(SyntaxException exception) {
        String message = exception.getMessage();
        String justMessage = message.substring(0, message.lastIndexOf(LINE_AT));
        this.collector.add(new CompilerMessage("error", justMessage, exception.getSourceLocator(), exception.getLine(), exception.getStartColumn()));
    }

    private void addErrorMessage(GroovyRuntimeException exception) {
        ASTNode astNode = exception.getNode();
        ModuleNode module = exception.getModule();
        if (module == null) {
            module = GroovyCompilerWrapper.findModule(astNode);
        }
        String moduleName = module == null ? "<no module>" : module.getDescription();
        int lineNumber = astNode == null ? -1 : astNode.getLineNumber();
        int columnNumber = astNode == null ? -1 : astNode.getColumnNumber();
        this.collector.add(new CompilerMessage("error", GroovyCompilerWrapper.getExceptionMessage(exception), moduleName, lineNumber, columnNumber));
    }

    @NotNull
    private static String getExceptionMessage(GroovyRuntimeException exception) {
        if (exception.getCause() instanceof ClassNotFoundException) {
            String className = exception.getCause().getMessage();
            String string = "An error occurred while trying to load a required class " + className + ". Please ensure it's present in the project dependencies. See the message and the stack trace below for reference\n\n" + GroovyCompilerWrapper.getStackTrace(exception);
            if (string == null) {
                GroovyCompilerWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }
        String message = exception.getMessageWithoutLocationText();
        String string = message == null ? GroovyCompilerWrapper.getStackTrace(exception) : message;
        if (string == null) {
            GroovyCompilerWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getStackTrace(GroovyRuntimeException exception) {
        String message;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        exception.printStackTrace(writer);
        String string = message = stringWriter.getBuffer().toString();
        if (string == null) {
            GroovyCompilerWrapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static ModuleNode findModule(ASTNode node) {
        ClassNode declaringClass;
        if (node instanceof ModuleNode) {
            return (ModuleNode)node;
        }
        if (node instanceof ClassNode) {
            return ((ClassNode)node).getModule();
        }
        if (node instanceof AnnotatedNode && (declaringClass = ((AnnotatedNode)node).getDeclaringClass()) != null) {
            return declaringClass.getModule();
        }
        return null;
    }

    private void addErrorMessage(SimpleMessage message) {
        this.addMessageWithoutLocation(message.getMessage(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/groovy/compiler/rt/GroovyCompilerWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOutputItems";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrace";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class OutputItem {
        private final String myOutputPath;
        private final String mySourceFileName;

        public OutputItem(File targetDirectory, String outputPath, String sourceFileName) {
            this.myOutputPath = targetDirectory.getAbsolutePath().replace(File.separatorChar, '/') + "/" + outputPath;
            this.mySourceFileName = sourceFileName;
        }

        public String getOutputPath() {
            return this.myOutputPath;
        }

        public String getSourceFile() {
            return this.mySourceFileName;
        }
    }
}

