/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.PathsList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.FileIndexUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.run.JetRunConfiguration;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationEditor;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinRunConfiguration
extends JetRunConfiguration {
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    public boolean PASS_PARENT_ENVS = true;
    private Map<String, String> myEnvs = new LinkedHashMap<String, String>();

    public KotlinRunConfiguration(String name, JavaRunConfigurationModule runConfigurationModule, ConfigurationFactory factory) {
        super(name, runConfigurationModule, factory);
        runConfigurationModule.init();
    }

    public Collection<Module> getValidModules() {
        return Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules());
    }

    @Nullable
    public GlobalSearchScope getSearchScope() {
        return SearchScopeProvider.createSearchScope((Module[])this.getModules());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new KotlinRunConfigurationEditor(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        this.readModule(element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getEnvs());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        this.writeModule(element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getEnvs());
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    public void setVMParameters(String value) {
        this.VM_PARAMETERS = value;
    }

    public String getVMParameters() {
        return this.VM_PARAMETERS;
    }

    public void setProgramParameters(String value) {
        this.PROGRAM_PARAMETERS = value;
    }

    public String getProgramParameters() {
        return this.PROGRAM_PARAMETERS;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.PASS_PARENT_ENVS = passParentEnvs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.myEnvs;
        if (map2 == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(2);
        }
        this.myEnvs = envs;
    }

    public boolean isPassParentEnvs() {
        return this.PASS_PARENT_ENVS;
    }

    public String getRunClass() {
        return this.MAIN_CLASS_NAME;
    }

    public void setRunClass(String value) {
        this.MAIN_CLASS_NAME = value;
    }

    public String getPackage() {
        return null;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String path) {
        this.ALTERNATIVE_JRE_PATH = path;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null) {
            throw new RuntimeConfigurationError("Module not specified");
        }
        if (StringUtil.isEmpty((String)this.MAIN_CLASS_NAME)) {
            throw new RuntimeConfigurationError("No main class specified");
        }
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Module)module, (String)this.MAIN_CLASS_NAME);
        if (psiClass == null) {
            throw new RuntimeConfigurationWarning("Class '" + this.MAIN_CLASS_NAME + "' not found in module " + ((JavaRunConfigurationModule)this.getConfigurationModule()).getModuleName());
        }
        if (KotlinRunConfiguration.findMainFun(psiClass) == null) {
            throw new RuntimeConfigurationWarning("The class " + this.MAIN_CLASS_NAME + " has no main method");
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(3);
        }
        if (executionEnvironment == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(4);
        }
        return new MyJavaCommandLineState(this, executionEnvironment);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        String fqNameBeingRenamed = element instanceof KtDeclarationContainer ? KotlinRunConfigurationProducer.Companion.getStartClassFqName((KtDeclarationContainer)element) : (element instanceof PsiPackage ? ((PsiPackage)element).getQualifiedName() : null);
        if (fqNameBeingRenamed == null || !this.MAIN_CLASS_NAME.equals(fqNameBeingRenamed) && !this.MAIN_CLASS_NAME.startsWith(fqNameBeingRenamed + ".")) {
            return null;
        }
        if (element instanceof KtDeclarationContainer) {
            return new RefactoringElementAdapter(){

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (oldQualifiedName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    KotlinRunConfiguration.this.updateMainClassName(newElement);
                }

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    KotlinRunConfiguration.this.updateMainClassName(newElement);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/kotlin/idea/run/KotlinRunConfiguration$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        final String nameSuffix = this.MAIN_CLASS_NAME.substring(fqNameBeingRenamed.toString().length());
        return new RefactoringElementAdapter(){

            protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                KotlinRunConfiguration.this.updateMainClassNameWithSuffix(newElement, nameSuffix);
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                if (newElement == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (oldQualifiedName == null) {
                    2.$$$reportNull$$$0(2);
                }
                KotlinRunConfiguration.this.updateMainClassNameWithSuffix(newElement, nameSuffix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldQualifiedName";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/idea/run/KotlinRunConfiguration$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementRenamedOrMoved";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "undoElementMovedOrRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void updateMainClassName(PsiElement element) {
        KtDeclarationContainer container = KotlinRunConfigurationProducer.Companion.getEntryPointContainer(element);
        String name = KotlinRunConfigurationProducer.Companion.getStartClassFqName(container);
        if (name != null) {
            this.MAIN_CLASS_NAME = name;
        }
    }

    private void updateMainClassNameWithSuffix(PsiElement element, String suffix) {
        if (element instanceof PsiPackage) {
            this.MAIN_CLASS_NAME = ((PsiPackage)element).getQualifiedName() + suffix;
        }
    }

    public String suggestedName() {
        if (StringUtil.isEmpty((String)this.MAIN_CLASS_NAME)) {
            return null;
        }
        return this.MAIN_CLASS_NAME;
    }

    @NotNull
    private static Collection<KtNamedFunction> getMainFunCandidates(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(5);
        }
        List list2 = CollectionsKt.filterNotNull((Iterable)ArraysKt.map((Object[])psiClass.getAllMethods(), (Function1)new Function1<PsiMethod, KtNamedFunction>(){

            public KtNamedFunction invoke(PsiMethod method) {
                if (!(method instanceof KtLightMethod)) {
                    return null;
                }
                if (!method.getName().equals("main")) {
                    return null;
                }
                KtDeclaration declaration2 = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
                return declaration2 instanceof KtNamedFunction ? (KtNamedFunction)declaration2 : null;
            }
        }));
        if (list2 == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    private static KtNamedFunction findMainFun(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            KotlinRunConfiguration.$$$reportNull$$$0(7);
        }
        for (KtNamedFunction function : KotlinRunConfiguration.getMainFunCandidates(psiClass)) {
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)function, (BodyResolveMode)BodyResolveMode.FULL);
            MainFunctionDetector mainFunctionDetector2 = new MainFunctionDetector(bindingContext2, PlatformKt.getLanguageVersionSettings((KtElement)function));
            if (!mainFunctionDetector2.isMain(function)) continue;
            return function;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/run/KotlinRunConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/run/KotlinRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainFunCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMainFunCandidates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMainFun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyJavaCommandLineState
    extends BaseJavaApplicationCommandLineState<KotlinRunConfiguration> {
        public MyJavaCommandLineState(@NotNull KotlinRunConfiguration configuration, ExecutionEnvironment environment) {
            if (configuration == null) {
                MyJavaCommandLineState.$$$reportNull$$$0(0);
            }
            super(environment, (RunConfigurationBase)configuration);
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            JavaParameters params = new JavaParameters();
            JavaRunConfigurationModule module = (JavaRunConfigurationModule)((KotlinRunConfiguration)this.myConfiguration).getConfigurationModule();
            int classPathType = (Integer)DumbService.getInstance((Project)module.getProject()).computeWithAlternativeResolveEnabled(() -> this.getClasspathType((RunConfigurationModule)module));
            String jreHome = ((KotlinRunConfiguration)this.myConfiguration).ALTERNATIVE_JRE_PATH_ENABLED ? ((KotlinRunConfiguration)this.myConfiguration).ALTERNATIVE_JRE_PATH : null;
            JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params, (int)classPathType, (String)jreHome);
            this.setupJavaParameters(params);
            params.setMainClass(((KotlinRunConfiguration)this.myConfiguration).getRunClass());
            MyJavaCommandLineState.setupModulePath(params, module);
            return params;
        }

        private int getClasspathType(RunConfigurationModule configurationModule) throws CantRunException {
            VirtualFile virtualFileForMainFun;
            Module module = configurationModule.getModule();
            if (module == null) {
                throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
            }
            String runClass = ((KotlinRunConfiguration)this.myConfiguration).getRunClass();
            if (runClass == null) {
                throw new CantRunException(String.format("Run class should be defined for configuration '%s'", ((KotlinRunConfiguration)this.myConfiguration).getName()));
            }
            PsiClass psiClass = JavaExecutionUtil.findMainClass((Module)module, (String)runClass);
            if (psiClass == null) {
                throw CantRunException.classNotFound((String)runClass, (Module)module);
            }
            KtNamedFunction mainFun = KotlinRunConfiguration.findMainFun(psiClass);
            if (mainFun == null) {
                throw new CantRunException(this.noFunctionFoundMessage(psiClass));
            }
            Module classModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)mainFun);
            if (classModule == null) {
                classModule = module;
            }
            if ((virtualFileForMainFun = mainFun.getContainingFile().getVirtualFile()) == null) {
                throw new CantRunException(this.noFunctionFoundMessage(psiClass));
            }
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)classModule).getFileIndex();
            if (fileIndex.isInSourceContent(virtualFileForMainFun)) {
                if (FileIndexUtilsKt.isInTestSourceContentKotlinAware((FileIndex)fileIndex, (VirtualFile)virtualFileForMainFun)) {
                    return 7;
                }
                return 3;
            }
            List entriesForFile = fileIndex.getOrderEntriesForFile(virtualFileForMainFun);
            for (OrderEntry entry : entriesForFile) {
                if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.TEST) continue;
                return 7;
            }
            return 3;
        }

        @NotNull
        private String noFunctionFoundMessage(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                MyJavaCommandLineState.$$$reportNull$$$0(1);
            }
            FqName classFqName = new FqName(psiClass.getQualifiedName());
            if (psiClass instanceof KtLightClassForSourceDeclaration) {
                String string = String.format("Function 'main' not found in class '%s'", classFqName);
                if (string == null) {
                    MyJavaCommandLineState.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = String.format("Top-level function 'main' not found in package '%s'", classFqName.parent());
            if (string == null) {
                MyJavaCommandLineState.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static void setupModulePath(JavaParameters params, JavaRunConfigurationModule module) {
            PsiJavaModule mainModule;
            if (JavaSdkUtil.isJdkAtLeast((Sdk)params.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (mainModule = (PsiJavaModule)DumbService.getInstance((Project)module.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByElement((PsiElement)module.findClass(params.getMainClass())))) != null) {
                params.setModuleName(mainModule.getName());
                PathsList classPath = params.getClassPath();
                PathsList modulePath = params.getModulePath();
                modulePath.addAll(classPath.getPathList());
                classPath.clear();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/run/KotlinRunConfiguration$MyJavaCommandLineState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/run/KotlinRunConfiguration$MyJavaCommandLineState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "noFunctionFoundMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "noFunctionFoundMessage";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

