/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTableRow;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPsiElementBase;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;

public class GherkinTableImpl
extends GherkinPsiElementBase
implements GherkinTable {
    private static final TokenSet HEADER_ROW_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.TABLE_HEADER_ROW});

    public GherkinTableImpl(@NotNull ASTNode node) {
        if (node == null) {
            GherkinTableImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    protected void acceptGherkin(GherkinElementVisitor gherkinElementVisitor) {
        gherkinElementVisitor.visitTable(this);
    }

    @Override
    @Nullable
    public GherkinTableRow getHeaderRow() {
        ASTNode node = this.getNode();
        ASTNode tableNode = node.findChildByType(HEADER_ROW_TOKEN_SET);
        return tableNode == null ? null : (GherkinTableRow)tableNode.getPsi();
    }

    @Override
    @NotNull
    public List<GherkinTableRow> getDataRows() {
        ArrayList<GherkinTableRow> result = new ArrayList<GherkinTableRow>();
        GherkinTableRow[] rows = (GherkinTableRow[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GherkinTableRow.class);
        if (rows != null) {
            for (GherkinTableRow row : rows) {
                if (row instanceof GherkinTableHeaderRowImpl) continue;
                result.add(row);
            }
        }
        ArrayList<GherkinTableRow> arrayList = result;
        if (arrayList == null) {
            GherkinTableImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        int result = 0;
        GherkinTableRow headerRow = this.getHeaderRow();
        if (headerRow != null) {
            result = headerRow.getColumnWidth(columnIndex);
        }
        for (GherkinTableRow row : this.getDataRows()) {
            result = Math.max(result, row.getColumnWidth(columnIndex));
        }
        return result;
    }

    public String toString() {
        return "GherkinTable";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinTableImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/impl/GherkinTableImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataRows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

