/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.UriUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SetContextFolderFix;
import com.intellij.psi.jsp.WebDirectoryElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFileReferenceHelper
extends FileReferenceHelper {
    private static final int MAX_DEPTH = 2;

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(0);
        }
        String string = WebUtil.trimURL((String)url);
        if (string == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        SetContextFolderFix[] contextFolderFix;
        Pair<VirtualFile, String> pair;
        ArrayList<LocalQuickFix> list = new ArrayList<LocalQuickFix>();
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int count = fileReferenceSet.getAllReferences().length;
        WebFacet webFacet = this.getWebFacet(reference);
        if (webFacet != null && count != 0 && reference.getIndex() == count - 1 && fileReferenceSet.isAbsolutePathReference() && (pair = this.findWebRootCandidate(fileReferenceSet.getPathString(), webFacet)) != null) {
            list.add(this.doRegisterFix(pair, webFacet));
        }
        if (webFacet != null && (contextFolderFix = SetContextFolderFix.create(reference, webFacet)) != null) {
            for (SetContextFolderFix fix : contextFolderFix) {
                list.add(fix);
            }
        }
        ArrayList<LocalQuickFix> arrayList = list;
        if (arrayList == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public WebDirectoryElement getPsiFileSystemItem(Project project, @NotNull VirtualFile file) {
        WebFacet webFacet;
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(3);
        }
        if ((webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(project).findWebDirectoryByFile(file, webFacet);
    }

    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file) {
        WebFacet webFacet;
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(4);
        }
        if ((webFacet = WebUtil.getWebFacet((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        return WebDirectoryUtil.getWebDirectoryUtil(project).findWebDirectoryElementByPath("/", webFacet);
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module thisModule) {
        if (thisModule == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(5);
        }
        WebDirectoryUtil util = WebDirectoryUtil.getWebDirectoryUtil(thisModule.getProject());
        ArrayList<PsiFileSystemItem> list = new ArrayList<PsiFileSystemItem>();
        WebUtil.getWebUtil().visitAllFacets(thisModule, facet -> {
            WebDirectoryElement directoryElement = util.findWebDirectoryElementByPath("/", (WebFacet)facet);
            if (directoryElement != null) {
                list.add((PsiFileSystemItem)directoryElement);
            }
        });
        ArrayList<PsiFileSystemItem> arrayList = list;
        if (arrayList == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        Module module;
        WebDirectoryElement parent;
        WebDirectoryElement item;
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(7);
        }
        if ((item = this.getPsiFileSystemItem(project, file)) != null && (parent = item.getParent()) != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null) {
            String path = parent.getPath();
            Collection collection = WebUtil.getWebUtil().getContextsByPath(path, module);
            if (collection == null) {
                WebFileReferenceHelper.$$$reportNull$$$0(8);
            }
            return collection;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(10);
        }
        return WebUtil.isInsideWebRoots((VirtualFile)file, (Project)project);
    }

    @Nullable
    protected Pair<VirtualFile, String> findWebRootCandidate(String path, WebFacet webFacet) {
        ContentEntry[] contentEntries;
        List webRoots = webFacet.getWebRoots();
        Module module = webFacet.getModule();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            VirtualFile webRootCandidate;
            VirtualFile virtualFile = entry.getFile();
            if (virtualFile == null || (webRootCandidate = WebFileReferenceHelper.scan(virtualFile, path.split("/"), entry, webRoots, 0)) == null) continue;
            VirtualFile base = webRootCandidate;
            String mapTo = "/";
            int pos = 0;
            for (WebRoot webRoot : webRoots) {
                if (!webRoot.getRelativePath().equals(mapTo)) continue;
                if ((pos = path.indexOf(47, pos + 1)) == -1) {
                    return null;
                }
                mapTo = path.substring(0, pos);
                webRootCandidate = UriUtil.findRelativeFile((String)mapTo, (VirtualFile)base);
                if (webRootCandidate != null) continue;
                return null;
            }
            return Pair.create((Object)webRootCandidate, (Object)mapTo);
        }
        return null;
    }

    @Nullable
    protected WebFacet getWebFacet(FileReference reference) {
        PsiElement element = reference.getElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        Iterator iterator = WebFacet.getInstances((Module)module).iterator();
        return iterator.hasNext() ? (WebFacet)iterator.next() : null;
    }

    protected LocalQuickFix doRegisterFix(Pair<VirtualFile, String> pair, WebFacet webFacet) {
        return new AddWebRootIntentionAction((VirtualFile)pair.first, (String)pair.second, webFacet);
    }

    @Nullable
    private static VirtualFile scan(@NotNull VirtualFile file, String[] path, ContentEntry contentEntry, List<WebRoot> webRoots, int depth) {
        if (file == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(11);
        }
        if (!file.isDirectory()) {
            return null;
        }
        boolean containsWebRoot = false;
        for (WebRoot root : webRoots) {
            VirtualFile rootFile = root.getFile();
            if (Comparing.equal((Object)file, (Object)rootFile)) {
                return null;
            }
            if (rootFile == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)rootFile, (boolean)false)) continue;
            containsWebRoot = true;
            break;
        }
        if (!containsWebRoot && WebFileReferenceHelper.findRelativeFile(path, file) != null) {
            boolean valid = true;
            for (VirtualFile entry : contentEntry.getExcludeFolderFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)entry, (boolean)false)) continue;
                valid = false;
                break;
            }
            if (valid) {
                return file;
            }
        }
        if (depth < 2) {
            for (VirtualFile child : file.getChildren()) {
                VirtualFile result = WebFileReferenceHelper.scan(child, path, contentEntry, webRoots, depth + 1);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static VirtualFile findRelativeFile(@NotNull String[] path, @NotNull VirtualFile base) {
        if (path == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(12);
        }
        if (base == null) {
            WebFileReferenceHelper.$$$reportNull$$$0(13);
        }
        VirtualFile result = base;
        for (String file : path) {
            if ((result = result.findChild(file)) != null) continue;
            return base;
        }
        return base;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisModule";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "trimUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trimUrl";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileSystemItem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddWebRootIntentionAction
    implements IntentionAction,
    LocalQuickFix {
        private final VirtualFile myWebRootCandidate;
        private final String myMapTo;
        private final WebFacet myWebFacet;

        AddWebRootIntentionAction(@NotNull VirtualFile webRootCandidate, @NotNull String mapTo, @NotNull WebFacet webFacet) {
            if (webRootCandidate == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(0);
            }
            if (mapTo == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(1);
            }
            if (webFacet == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(2);
            }
            this.myWebRootCandidate = webRootCandidate;
            this.myMapTo = mapTo;
            this.myWebFacet = webFacet;
        }

        @NotNull
        public String getText() {
            String string = J2EEBundle.message((String)"add.web.root", (Object[])new Object[]{this.myWebRootCandidate.getPath()});
            if (string == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = this.getText();
            if (string == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = J2EEBundle.message((String)"web.root.family", (Object[])new Object[0]);
            if (string == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(6);
            }
            if (descriptor == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(7);
            }
            this.invoke(project, null, null);
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(8);
            }
            return true;
        }

        public final void invoke(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                AddWebRootIntentionAction.$$$reportNull$$$0(9);
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> this.myWebFacet.addWebRoot(this.myWebRootCandidate, this.myMapTo));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "webRootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapTo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "webFacet";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/WebFileReferenceHelper$AddWebRootIntentionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

