/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddJpaProviderSupport
extends DefaultActionGroup
implements DumbAware {
    public AddJpaProviderSupport() {
        for (final JpaImplementationProvider provider : JpaImplementationProvider.EP_NAME.getExtensionList()) {
            this.add(new AnAction(provider.getProviderName(), provider.getProviderName(), provider.getProviderIcon()){

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PersistenceUnit unit = AddJpaProviderSupport.getPersistenceUnit(e);
                    e.getPresentation().setEnabledAndVisible(unit != null);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Project project = e.getProject();
                    PersistenceUnit unit = AddJpaProviderSupport.getPersistenceUnit(e);
                    if (project == null || unit == null) {
                        return;
                    }
                    RawConnectionConfig info = AddJpaProviderSupport.findConnectionInfo(project, unit);
                    Credentials credentials = info == null ? null : DatabaseCredentials.getInstance().getCredentials((DasDataSource)info);
                    WriteCommandAction.writeCommandAction((Project)unit.getManager().getProject(), (PsiFile[])new PsiFile[]{unit.getContainingFile()}).run(() -> {
                        if (info != null) {
                            provider.setConnectionProperties(project, unit, info, credentials);
                        } else {
                            provider.setDefaultProperties(unit);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/jpa/actions/AddJpaProviderSupport$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.setPopup(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddJpaProviderSupport.$$$reportNull$$$0(0);
        }
        PersistenceUnit unit = AddJpaProviderSupport.getPersistenceUnit(e);
        e.getPresentation().setEnabledAndVisible(unit != null);
    }

    @Nullable
    private static RawConnectionConfig findConnectionInfo(@NotNull Project project, @NotNull PersistenceUnit unit) {
        if (project == null) {
            AddJpaProviderSupport.$$$reportNull$$$0(1);
        }
        if (unit == null) {
            AddJpaProviderSupport.$$$reportNull$$$0(2);
        }
        List facets = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceFacets((PersistencePackage)unit);
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
        for (PersistenceFacet facet : facets) {
            DbDataSource dataSource;
            RawConnectionConfig info;
            String id = facet.getDataSourceId((PersistencePackage)unit);
            if (id == null || (info = (dataSource = dbPsiFacade.findDataSource(id)) == null ? null : dataSource.getConnectionConfig()) == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    private static PersistenceUnit getPersistenceUnit(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (file == null || editor == null) {
            return null;
        }
        DomElement element = DomUtil.getDomElement((Editor)editor, (PsiFile)file);
        return element == null ? null : (PersistenceUnit)element.getParentOfType(PersistenceUnit.class, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/actions/AddJpaProviderSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findConnectionInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

