/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.view.JamDeleteHandler;
import com.intellij.javaee.model.xml.persistence.mapping.Entity;
import com.intellij.jpa.JpaObjectDeleteHandler;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomMetaData;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;

public class JpaApplicationComponent {
    public JpaApplicationComponent(CommonModelManager commonModelManager) {
        JpqlLanguage.JPQL.getDisplayName();
        MetaRegistry.addMetadataBinding((ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                XmlTag tag = (XmlTag)element;
                DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
                return domElement instanceof Entity && ((Entity)domElement).getName().getXmlTag() == null;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }), XmlEntityMetaData.class);
        ElementPresentationManager.registerNameProvider(o -> {
            if (o instanceof PersistentEntity) {
                return (String)((PersistentEntity)o).getName().getValue();
            }
            if (o instanceof PersistentObject) {
                return PsiNameHelper.getShortClassName((String)StringUtil.notNullize((String)((PersistentObject)o).getClazz().getStringValue()));
            }
            return null;
        });
        commonModelManager.registerDeleteHandler((JamDeleteHandler)new JpaObjectDeleteHandler());
        commonModelManager.registerDeleteHandler(new JamDeleteHandler(){

            public void addPsiElements(CommonModelElement element, Collection<? super PsiElement> result) {
                if (element instanceof PersistentAttribute) {
                    result.addAll(JpaUtil.getAttributePsiMembers((PersistentAttribute)element));
                }
            }
        });
    }

    public static class XmlEntityMetaData
    extends DomMetaData<Entity> {
        protected GenericDomValue getNameElement(Entity entity) {
            return entity.getClazz();
        }

        public void setName(String name) throws IncorrectOperationException {
            ((Entity)this.getElement()).getName().setValue((Object)name);
        }
    }
}

