/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.ui.packaging.LibrariesAndModulesCollector;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeArtifactDependenciesChecker {
    protected final ArtifactType myArtifactType;
    private final ArtifactProblemsHolder myManager;
    protected final PackagingElementResolvingContext myContext;

    public JavaeeArtifactDependenciesChecker(ArtifactProblemsHolder manager, ArtifactType artifactType) {
        this.myContext = manager.getContext();
        this.myManager = manager;
        this.myArtifactType = artifactType;
    }

    protected void checkDependencies(LibrariesAndModulesCollector[] collectors, final CompositePackagingElement<?> elementWithManifest, Map<VirtualFile, String> jarsToRelativePaths, PackagingElementPath pathToElement, LibrariesAndModulesCollector ... availableElementsCollectors) {
        final Artifact artifact = pathToElement.findLastArtifact(this.myContext);
        THashSet checkedModules = new THashSet();
        LibrariesAndModulesCollector[] allCollectors = (LibrariesAndModulesCollector[])ArrayUtil.mergeArrays((Object[])collectors, (Object[])availableElementsCollectors);
        for (LibrariesAndModulesCollector collector : collectors) {
            for (Pair<Module, List<PackagingElement<?>>> pair : collector.getUsedModules()) {
                Module module = (Module)pair.getFirst();
                if (!checkedModules.add(module) || !JavaeeArtifactDependenciesChecker.shouldProcessRecursively(module)) continue;
                ModuleRootModel rootModel = this.myContext.getModulesProvider().getRootModel(module);
                ArrayList<MissingElementInArtifactProblem> problems = new ArrayList<MissingElementInArtifactProblem>();
                rootModel.orderEntries().productionOnly().runtimeOnly().forEach(entry -> {
                    if (entry instanceof LibraryOrderEntry) {
                        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry;
                        Library library = libraryEntry.getLibrary();
                        if (library == null || !this.isSuitableForModule(library, module) || JavaeeArtifactDependenciesChecker.containsLibrary(allCollectors, library) || JavaeeArtifactTypeBase.isStandardJavaeeLibary(library)) {
                            return true;
                        }
                        List<VirtualFile> missingRoots = JavaeeArtifactDependenciesChecker.getMissingRoots(allCollectors, library.getFiles(OrderRootType.CLASSES));
                        if (!missingRoots.isEmpty()) {
                            String message;
                            final ArrayList<String> classpath = new ArrayList<String>();
                            boolean allJarsFound = true;
                            for (VirtualFile missingRoot : missingRoots) {
                                String path = (String)jarsToRelativePaths.get(missingRoot);
                                if (path != null) {
                                    classpath.add(path);
                                    continue;
                                }
                                allJarsFound = false;
                            }
                            if (allJarsFound) {
                                message = StringUtil.first((String)StringUtil.join(classpath, (String)", "), (int)50, (boolean)true) + (classpath.size() > 1 ? " are " : " is ") + "missing from the classpath of '" + elementWithManifest.getName() + "'";
                                ArtifactProblemQuickFix fix = new ArtifactProblemQuickFix("Add jars to the classpath"){

                                    public void performFix(ArtifactEditorContext artifactEditorContext) {
                                        ArtifactEditor editor = artifact != null ? artifactEditorContext.getOrCreateEditor(artifact) : artifactEditorContext.getThisArtifactEditor();
                                        editor.addToClasspath(elementWithManifest, classpath);
                                    }
                                };
                                this.myManager.registerWarning(message, "jars-missing-from-classpath", (List)pair.getSecond(), new ArtifactProblemQuickFix[]{fix});
                            } else {
                                message = "Library '" + LibraryUtil.getPresentableName((Library)library) + "' required for module '" + module.getName() + "' is missing from the artifact";
                                problems.add(new MissingLibraryInArtifactProblem(module, library, message, libraryEntry, (List)pair.getSecond()));
                            }
                        }
                    } else if (entry instanceof ModuleOrderEntry) {
                        ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)entry;
                        Module dependency = moduleOrderEntry.getModule();
                        if (dependency == null || !(ModuleType.get((Module)dependency) instanceof JavaModuleType)) {
                            return true;
                        }
                        if (!JavaeeArtifactDependenciesChecker.containsModule(allCollectors, dependency)) {
                            String errorMessage = "Module '" + dependency.getName() + "' required for module '" + module.getName() + "' is missing from the artifact";
                            problems.add(new MissingModuleInArtifactProblem(module, dependency, errorMessage, moduleOrderEntry, (List)pair.getSecond()));
                        }
                    }
                    return true;
                });
                AddAllDependenciesQuickFix addAllDependenciesFix = null;
                if (problems.size() > 1) {
                    addAllDependenciesFix = new AddAllDependenciesQuickFix(problems, module);
                }
                for (MissingElementInArtifactProblem problem : problems) {
                    problem.registerWarning(this.myManager, addAllDependenciesFix);
                }
            }
        }
    }

    private static boolean shouldProcessRecursively(Module module) {
        for (OrderEnumerationHandler.Factory factory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
            if (!factory.isApplicable(module) || factory.createHandler(module).shouldProcessDependenciesRecursively()) continue;
            return false;
        }
        return true;
    }

    private boolean isSuitableForModule(@NotNull Library library, @NotNull Module module) {
        PersistentLibraryKind kind;
        if (library == null) {
            JavaeeArtifactDependenciesChecker.$$$reportNull$$$0(0);
        }
        if (module == null) {
            JavaeeArtifactDependenciesChecker.$$$reportNull$$$0(1);
        }
        if ((kind = ((LibraryEx)library).getKind()) == null) {
            return true;
        }
        return LibraryType.findByKind((LibraryKind)kind).isSuitableModule(module, this.myContext.getFacetsProvider());
    }

    @NotNull
    private static ArtifactProblemQuickFix createSetDependencyScopeFix(final Module module, final OrderEntry entry, final DependencyScope scope) {
        ArtifactProblemQuickFix artifactProblemQuickFix = new ArtifactProblemQuickFix("Change '" + entry.getPresentableName() + "' scope to '" + scope.toString() + "'"){

            public void performFix(ArtifactEditorContext artifactEditorContext) {
                ModifiableRootModel model = artifactEditorContext.getOrCreateModifiableRootModel(module);
                for (OrderEntry orderEntry : model.getOrderEntries()) {
                    if (orderEntry.compareTo((Object)entry) != 0) continue;
                    ((ExportableOrderEntry)orderEntry).setScope(scope);
                    break;
                }
            }
        };
        if (artifactProblemQuickFix == null) {
            JavaeeArtifactDependenciesChecker.$$$reportNull$$$0(2);
        }
        return artifactProblemQuickFix;
    }

    private static boolean containsModule(LibrariesAndModulesCollector[] collectors, Module module) {
        for (LibrariesAndModulesCollector collector : collectors) {
            for (Pair<Module, List<PackagingElement<?>>> pair : collector.getUsedModules()) {
                if (!((Module)pair.getFirst()).equals(module)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsLibrary(LibrariesAndModulesCollector[] collectors, Library library) {
        for (LibrariesAndModulesCollector collector : collectors) {
            if (!collector.getIncludedLibraries().contains(library)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsLibraryFile(LibrariesAndModulesCollector[] collectors, VirtualFile file) {
        for (LibrariesAndModulesCollector collector : collectors) {
            if (!collector.getIncludedLibraryFiles().contains(file)) continue;
            return true;
        }
        return false;
    }

    private static List<VirtualFile> getMissingRoots(LibrariesAndModulesCollector[] collectors, VirtualFile[] roots) {
        SmartList missingRoots = new SmartList();
        for (VirtualFile file : roots) {
            if (JavaeeArtifactDependenciesChecker.containsLibraryFile(collectors, file)) continue;
            missingRoots.add(file);
        }
        return missingRoots;
    }

    public void processWebApplication(CompositePackagingElement<?> warRoot, PackagingElementPath pathToWar, Map<VirtualFile, String> jarsToRelativePaths, LibrariesAndModulesCollector ... availableElementsCollectors) {
        LibrariesAndModulesCollector classesCollector = new LibrariesAndModulesCollector(this.myContext, this.myArtifactType, false);
        ArtifactUtil.processDirectoryChildren(warRoot, (PackagingElementPath)pathToWar, (String)"WEB-INF/classes", (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementProcessor)classesCollector);
        LibrariesAndModulesCollector jarsCollector = new LibrariesAndModulesCollector(this.myContext, this.myArtifactType, true);
        ArtifactUtil.processDirectoryChildren(warRoot, (PackagingElementPath)pathToWar, (String)"WEB-INF/lib", (PackagingElementResolvingContext)this.myContext, (ArtifactType)this.myArtifactType, (PackagingElementProcessor)jarsCollector);
        this.checkDependencies(new LibrariesAndModulesCollector[]{classesCollector, jarsCollector}, warRoot, jarsToRelativePaths, pathToWar, availableElementsCollectors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ui/packaging/JavaeeArtifactDependenciesChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ui/packaging/JavaeeArtifactDependenciesChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetDependencyScopeFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForModule";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddAllDependenciesQuickFix
    extends ArtifactProblemQuickFix {
        private final List<MissingElementInArtifactProblem> myProblems;

        AddAllDependenciesQuickFix(List<MissingElementInArtifactProblem> problems, Module module) {
            super("Add all missing dependencies of '" + module.getName() + "' to the artifact");
            this.myProblems = problems;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            for (MissingElementInArtifactProblem problem : this.myProblems) {
                ArtifactProblemQuickFix fix = problem.getIncludeRecursivelyFix();
                if (fix != null) {
                    fix.performFix(artifactEditorContext);
                    continue;
                }
                problem.performFix(artifactEditorContext);
            }
        }
    }

    private static class MissingLibraryInArtifactProblem
    extends MissingElementInArtifactProblem {
        private final Library myLibrary;

        MissingLibraryInArtifactProblem(Module module, Library library, String message, LibraryOrderEntry libraryEntry, List<PackagingElement<?>> moduleElementPath) {
            super("Add '" + LibraryUtil.getPresentableName((Library)library) + "' to the artifact", "library-missing-from-artifact", (ExportableOrderEntry)libraryEntry, module, moduleElementPath, message);
            this.myLibrary = library;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            artifactEditorContext.getThisArtifactEditor().putLibraryIntoDefaultLocation(this.myLibrary);
        }
    }

    private static class AddModuleDependenciesRecursivelyQuickFix
    extends ArtifactProblemQuickFix {
        private final Module myModule;

        AddModuleDependenciesRecursivelyQuickFix(Module module) {
            super("Add '" + module.getName() + "' and all its dependencies to the artifact");
            this.myModule = module;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)this.myModule).using((RootModelProvider)artifactEditorContext.getModulesProvider()).productionOnly().runtimeOnly().withoutSdk().recursively();
            enumerator.forEachModule(module -> {
                artifactEditorContext.getThisArtifactEditor().putModuleIntoDefaultLocation(module);
                return true;
            });
            enumerator.forEachLibrary(library -> {
                artifactEditorContext.getThisArtifactEditor().putLibraryIntoDefaultLocation(library);
                return true;
            });
        }
    }

    private static class MissingModuleInArtifactProblem
    extends MissingElementInArtifactProblem {
        private final Module myDependency;

        MissingModuleInArtifactProblem(Module module, Module dependency, String errorMessage, ModuleOrderEntry moduleOrderEntry, List<PackagingElement<?>> moduleElementPath) {
            super("Add '" + dependency.getName() + "' to the artifact", "module-missing-from-artifact", (ExportableOrderEntry)moduleOrderEntry, module, moduleElementPath, errorMessage);
            this.myDependency = dependency;
        }

        public void performFix(ArtifactEditorContext artifactEditorContext) {
            artifactEditorContext.getThisArtifactEditor().putModuleIntoDefaultLocation(this.myDependency);
        }

        @Override
        @Nullable
        public ArtifactProblemQuickFix getIncludeRecursivelyFix() {
            return new AddModuleDependenciesRecursivelyQuickFix(this.myDependency);
        }
    }

    private static abstract class MissingElementInArtifactProblem
    extends ArtifactProblemQuickFix {
        private final String myProblemTypeId;
        private final ExportableOrderEntry myOrderEntry;
        private final Module myModule;
        private final List<PackagingElement<?>> myModuleElementPath;
        private final String myErrorMessage;

        private MissingElementInArtifactProblem(String actionName, String problemTypeId, ExportableOrderEntry orderEntry, Module module, List<PackagingElement<?>> moduleElementPath, String errorMessage) {
            super(actionName);
            this.myProblemTypeId = problemTypeId;
            this.myOrderEntry = orderEntry;
            this.myModule = module;
            this.myModuleElementPath = moduleElementPath;
            this.myErrorMessage = errorMessage;
        }

        public void registerWarning(@NotNull ArtifactProblemsHolder problemsHolder, @Nullable ArtifactProblemQuickFix addAllFix) {
            if (problemsHolder == null) {
                MissingElementInArtifactProblem.$$$reportNull$$$0(0);
            }
            Object[] scopeFixes = new ArtifactProblemQuickFix[]{JavaeeArtifactDependenciesChecker.createSetDependencyScopeFix(this.myModule, (OrderEntry)this.myOrderEntry, DependencyScope.TEST), JavaeeArtifactDependenciesChecker.createSetDependencyScopeFix(this.myModule, (OrderEntry)this.myOrderEntry, DependencyScope.PROVIDED)};
            List includeFixes = ContainerUtil.packNullables((Object[])new ArtifactProblemQuickFix[]{this, this.getIncludeRecursivelyFix(), addAllFix});
            ArtifactProblemQuickFix[] fixes = (ArtifactProblemQuickFix[])ArrayUtil.mergeArrays((Object[])includeFixes.toArray(new ArtifactProblemQuickFix[0]), (Object[])scopeFixes);
            problemsHolder.registerWarning(this.myErrorMessage, this.myProblemTypeId, this.myModuleElementPath, fixes);
        }

        @Nullable
        public ArtifactProblemQuickFix getIncludeRecursivelyFix() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/javaee/ui/packaging/JavaeeArtifactDependenciesChecker$MissingElementInArtifactProblem", "registerWarning"));
        }
    }
}

