/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReloadResourcesUpdatingPolicy
extends UpdatingPolicy {
    private static final Logger LOG = Logger.getInstance(ReloadResourcesUpdatingPolicy.class);
    @NonNls
    private static final String ID = "update-resources";

    public static UpdatingPolicy getInstance() {
        return UpdatingRunningApplicationUtil.findPolicy(ID);
    }

    public ReloadResourcesUpdatingPolicy() {
        super(ID);
    }

    @Override
    public String getDescription() {
        return J2EEBundle.message((String)"updating.policy.update.resources", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailableOnFrameDeactivation() {
        return true;
    }

    @Override
    public boolean isAvailableForConfiguration(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(0);
        }
        return UpdatingRunningApplicationUtil.isResourcesReloadingSupported(commonModel);
    }

    @Override
    public void runUpdate(@NotNull Project project, @Nullable Executor executor, @NotNull J2EEServerInstance serverInstance, @NotNull ProcessHandler processHandler, boolean onFrameDeactivation) {
        if (project == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(1);
        }
        if (serverInstance == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(3);
        }
        CommonModel model = serverInstance.getCommonModel();
        CompileScope scope = ReloadResourcesUpdatingPolicy.createCompileScope(project, model);
        UpdatingRunningApplicationUtil.updateOpenedFilesAndStartCompilation(project, model.getArtifactsToBuild(), () -> {
            if (project == null) {
                ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(4);
            }
            if (serverInstance == null) {
                ReloadResourcesUpdatingPolicy.$$$reportNull$$$0(5);
            }
            UpdatingRunningApplicationUtil.startCompilation(project, scope, new UpdateResourceOnServerListener(serverInstance, false), onFrameDeactivation);
        });
    }

    public static CompileScope createCompileScope(Project project, CommonModel commonModel) {
        Set modules = ArtifactUtil.getModulesIncludedInArtifacts((Collection)commonModel.getDeployedArtifacts(), (Project)project);
        ModuleCompileScope modulesScope = new ModuleCompileScope(project, modules.toArray(Module.EMPTY_ARRAY), true);
        CompileScope scopeWithArtifacts = ArtifactCompileScope.createScopeWithArtifacts((CompileScope)modulesScope, (Collection)commonModel.getArtifactsToBuild());
        CompileScopeUtil.setResourcesScopeForExternalBuild((CompileScope)scopeWithArtifacts, modules.stream().map(Module::getName).collect(Collectors.toList()));
        return scopeWithArtifacts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonModel";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverInstance";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runUpdate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runUpdate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class UpdateResourceOnServerListener
    implements CompileStatusNotification {
        private final J2EEServerInstance myServerInstance;
        private final boolean myUpdateClassFiles;

        public UpdateResourceOnServerListener(J2EEServerInstance serverInstance, boolean updateClassFiles) {
            this.myServerInstance = serverInstance;
            this.myUpdateClassFiles = updateClassFiles;
        }

        public void finished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
            Set writtenPaths;
            if (compileContext == null) {
                UpdateResourceOnServerListener.$$$reportNull$$$0(0);
            }
            if (!aborted && errors == 0 && (writtenPaths = ArtifactsCompiler.getWrittenPaths((CompileContext)compileContext)) != null && this.myServerInstance instanceof DefaultServerInstance) {
                Set toUpdate;
                if (this.myUpdateClassFiles) {
                    toUpdate = writtenPaths;
                } else {
                    THashSet withoutClassFiles = new THashSet();
                    for (String path : writtenPaths) {
                        if (path.endsWith(".class")) continue;
                        withoutClassFiles.add(path);
                    }
                    toUpdate = withoutClassFiles;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating changed files on server '" + this.myServerInstance.getName() + "' (" + toUpdate.size() + "): ");
                    for (String path : toUpdate) {
                        LOG.debug(path);
                    }
                }
                ((DefaultServerInstance)this.myServerInstance).updateChangedFiles(toUpdate);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/javaee/run/execution/update/ReloadResourcesUpdatingPolicy$UpdateResourceOnServerListener", "finished"));
        }
    }
}

