/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.configuration.view;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.deployment.DeploymentView;
import com.intellij.javaee.deployment.DeploymentViewEx;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.view.JavaeeDeploymentActionConsoleContext;
import com.intellij.javaee.run.configuration.view.JavaeeDeploymentActionContext;
import com.intellij.javaee.run.execution.ConsoleViewWrapper;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.JavaeeConsoleView;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaeeConsoleViewImpl
extends ConsoleViewWrapper
implements ExecutionConsoleEx,
JavaeeConsoleView {
    @NonNls
    private static final String DEPLOYMENT_VIEW_ID = "Deployment";
    private final DeploymentViewEx myDeploymentView;
    private final AppServerIntegration myIntegration;
    private final J2EEProcess myJ2EEProcess;
    private final Executor myExecutor;

    public JavaeeConsoleViewImpl(Project project, CommonStrategy commonStrategy, J2EEProcess j2eeProcess, Executor executor, ConsoleView plainConsole) {
        super(plainConsole);
        this.myJ2EEProcess = j2eeProcess;
        this.myIntegration = commonStrategy.getIntegration();
        this.myExecutor = executor;
        this.myDeploymentView = DeploymentManagerEx.getInstanceEx(project).createDeploymentView(this.myIntegration, commonStrategy, j2eeProcess.getServerInstance());
        Disposer.register((Disposable)this, (Disposable)this.myDeploymentView);
    }

    public void buildUi(RunnerLayoutUi layoutUi) {
        boolean isDebug = this.myExecutor.getId().equals(DefaultDebugExecutor.EXECUTOR_ID);
        int tabIndex = isDebug ? 1 : 0;
        layoutUi.getDefaults().initTabDefaults(tabIndex, J2EEBundle.message((String)"run.tab.title.server", (Object[])new Object[0]), this.myIntegration.getIcon());
        Content output = layoutUi.createContent("ConsoleContent", this.getComponent(), J2EEBundle.message((String)"run.tab.title.output", (Object[])new Object[0]), null, this.getPreferredFocusableComponent());
        output.setActions((ActionGroup)new DefaultActionGroup(this.createConsoleActions()), "unknown", this.getComponent());
        layoutUi.addContent(output, tabIndex, PlaceInGrid.center, false);
        output.setCloseable(false);
        Content deployment = layoutUi.createContent(DEPLOYMENT_VIEW_ID, this.myDeploymentView.getComponent(), J2EEBundle.message((String)"run.tab.title.deployment", (Object[])new Object[0]), null, null);
        deployment.setHelpId(this.myDeploymentView.getHelpId());
        deployment.setActions((ActionGroup)this.myDeploymentView.createActionGroup(), "unknown", this.myDeploymentView.getComponent());
        deployment.setCloseable(false);
        layoutUi.addContent(deployment, tabIndex, PlaceInGrid.left, false);
        layoutUi.getOptions().setMoveToGridActionEnabled(true);
        JavaeeConsoleViewImpl.registerConsoleView(layoutUi, this);
    }

    public static void registerConsoleView(RunnerLayoutUi layoutUi, final JavaeeConsoleView consoleView) {
        layoutUi.getContentManager().addDataProvider((DataProvider)new TypeSafeDataProviderAdapter(new TypeSafeDataProvider(){

            public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (sink == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (key.equals(JavaeeConsoleView.KEY)) {
                    sink.put(JavaeeConsoleView.KEY, (Object)consoleView);
                } else if (key.equals(JavaeeDeploymentActionContext.KEY)) {
                    sink.put(JavaeeDeploymentActionContext.KEY, (Object)new JavaeeDeploymentActionConsoleContext(consoleView));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sink";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javaee/run/configuration/view/JavaeeConsoleViewImpl$1";
                objectArray[2] = "calcData";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        J2EEServerInstance serverInstance = consoleView.getServerInstance();
        if (serverInstance instanceof DefaultServerInstance) {
            ((DefaultServerInstance)serverInstance).registerAdditionalContent(layoutUi);
        }
    }

    @NotNull
    public String getExecutionConsoleId() {
        if ("JAVAEE_CONSOLE" == null) {
            JavaeeConsoleViewImpl.$$$reportNull$$$0(0);
        }
        return "JAVAEE_CONSOLE";
    }

    public JComponent getPreferredFocusableComponent() {
        return this.getComponent();
    }

    public ProcessHandler getProcessHandler() {
        return (ProcessHandler)this.myJ2EEProcess;
    }

    public DeploymentView getDeploymentView() {
        return this.myDeploymentView;
    }

    public J2EEServerInstance getServerInstance() {
        return this.myJ2EEProcess.getServerInstance();
    }

    public AppServerIntegration getIntegration() {
        return this.myIntegration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/configuration/view/JavaeeConsoleViewImpl", "getExecutionConsoleId"));
    }
}

