/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.transport;

import com.intellij.javaee.oss.transport.RemoteStagingTarget;
import com.intellij.javaee.oss.transport.TargetModelEditor;
import com.intellij.javaee.oss.transport.TransportTargetKind;
import com.intellij.javaee.transport.TransportHost;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.javaee.transport.TransportManagerConfigurable;
import com.intellij.javaee.transport.TransportManagerConfigurableListener;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.javaee.transport.TransportTargetConfigurable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class RemoteStagingTargetEditor<T> {
    private TransportTargetConfigurable myTransportTargetConfigurable;
    private JLabel myTargetLabel;
    private JPanel myMainPanel;
    private JPanel myTargetModelEditorPanel;
    private TargetModelEditor myTargetModelEditor;
    private TransportTarget myTransportTarget;

    public RemoteStagingTargetEditor(final TransportManagerConfigurable transportManagerConfigurable, String caption) {
        this.$$$setupUI$$$();
        this.myTransportTargetConfigurable.setParentConfigurable(transportManagerConfigurable);
        this.myTargetLabel.setText(caption);
        transportManagerConfigurable.addListener(new TransportManagerConfigurableListener(){

            @Override
            public void hostSelectionChanged() {
                TransportHost host = transportManagerConfigurable.getHost();
                RemoteStagingTargetEditor.this.myTargetModelEditorPanel.setVisible(host != null && RemoteStagingTargetEditor.this.getKind().isRequiredForHost(host));
            }
        });
        this.myTargetModelEditorPanel.setVisible(false);
    }

    public void resetEditorFrom(T model) {
        RemoteStagingTarget targetModel = this.getTargetModelEditor(model);
        this.myTargetModelEditor.resetEditorFrom(targetModel);
        TransportTarget transportTarget = targetModel.getTransportStagingTarget();
        this.myTransportTarget = RemoteStagingTargetEditor.getOrCreateTransportTarget(transportTarget);
        this.myTransportTargetConfigurable.setTarget(transportTarget);
    }

    public void applyEditorTo(T model) {
        RemoteStagingTarget targetModel = this.getTargetModelEditor(model);
        this.myTargetModelEditor.applyEditorTo(targetModel);
        targetModel.setTransportStagingTarget(this.myTransportTarget);
        this.myTransportTargetConfigurable.saveState();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void createUIComponents() {
        this.myTargetModelEditor = this.getKind().createTargetModelEditor();
        this.myTargetModelEditorPanel = this.myTargetModelEditor.getMainPanel();
    }

    private static TransportTarget getOrCreateTransportTarget(TransportTarget target) {
        return target == null || target.getId() == null ? TransportManager.createTarget() : target;
    }

    protected abstract RemoteStagingTarget getTargetModelEditor(T var1);

    protected abstract TransportTargetKind getKind();

    private /* synthetic */ void $$$setupUI$$$() {
        TransportTargetConfigurable transportTargetConfigurable;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 6, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 6, null, null, null));
        this.myTargetLabel = jLabel = new JLabel();
        jLabel.setText("<target>");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTransportTargetConfigurable = transportTargetConfigurable = new TransportTargetConfigurable();
        JComponent jComponent = transportTargetConfigurable.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = this.myTargetModelEditorPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

