/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.editor;

import com.intellij.javaee.oss.editor.JavaeeSection;
import com.intellij.javaee.oss.editor.JavaeeSectionInfo;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ClickListener;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.AbstractTableView;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeSectionView
implements CommittablePanel {
    private final SectionTableView view;
    private final JavaeeSection<?>[] sections;
    private final ColumnInfo<RowElement, ?>[] columns;
    private final List<RowElement> items = new ArrayList<RowElement>();
    private final Set<JavaeeSection<?>> expanded = new HashSet();
    private final Map<JavaeeSection<?>, JavaeeSectionInfo<DomElement>[]> mapped = new HashMap();
    private static final Component EXPANDED_ICON = JavaeeSectionView.createLabel(UIUtil.getTreeExpandedIcon());
    private static final Component COLLAPSED_ICON = JavaeeSectionView.createLabel(UIUtil.getTreeCollapsedIcon());
    private static final JavaeeSectionInfo<DomElement> EMPTY_COLUMN = new JavaeeSectionInfo<DomElement>(null){
        private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();

        public String valueOf(DomElement item) {
            return "";
        }

        @Override
        public TableCellRenderer getRenderer(DomElement item) {
            return this.renderer;
        }
    };

    public JavaeeSectionView(Project project, String empty, JavaeeSection<?> ... sections) {
        this.sections = (JavaeeSection[])sections.clone();
        this.view = new SectionTableView(project, empty);
        JTable table = this.view.getTable();
        table.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight());
        table.setShowVerticalLines(false);
        table.setIntercellSpacing(new Dimension(0, 1));
        this.installMouseListener(table);
        table.addKeyListener(this.createKeyListener(table));
        table.getTableHeader().setDefaultRenderer(this.createHeaderRenderer());
        ContainerUtil.addAll(this.expanded, (Object[])sections);
        this.columns = this.createColumnInfos();
        this.view.initialize();
        this.reset();
    }

    public void dispose() {
    }

    public void commit() {
    }

    public void reset() {
        this.items.clear();
        for (JavaeeSection<?> section : this.sections) {
            List<?> values = section.getValues();
            if (values.isEmpty()) continue;
            this.items.add(new SectionRowElement(section));
            if (!this.expanded.contains(section)) continue;
            for (DomElement value : values) {
                this.items.add(new DomRowElement(section, value));
            }
        }
        this.view.reset(this.columns, this.items);
    }

    public JComponent getComponent() {
        return this.view;
    }

    @NotNull
    private JavaeeSectionInfo<DomElement> getColumnInfo(JavaeeSection<?> section, int column) {
        JavaeeSectionInfo<DomElement>[] infos = this.mapped.get(section);
        JavaeeSectionInfo<DomElement> javaeeSectionInfo = column <= infos.length ? infos[column] : EMPTY_COLUMN;
        if (javaeeSectionInfo == null) {
            JavaeeSectionView.$$$reportNull$$$0(0);
        }
        return javaeeSectionInfo;
    }

    private void installMouseListener(final JTable table) {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                Point point = new Point(e.getPoint());
                int row = table.rowAtPoint(point);
                int col = table.columnAtPoint(point);
                if (row >= 0 && col >= 0) {
                    JComponent component = (JComponent)table.prepareRenderer(table.getCellRenderer(row, col), row, col);
                    Rectangle rect = table.getCellRect(row, col, true);
                    component.setSize(rect.getSize());
                    component.doLayout();
                    point.translate(-rect.x, -rect.y);
                    if (clickCount >= 2 || component.findComponentAt(point) instanceof IconLabel) {
                        ((RowElement)JavaeeSectionView.this.items.get(row)).handleDoubleClick();
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javaee/oss/editor/JavaeeSectionView$2", "onClick"));
            }
        }.installOn((Component)table);
    }

    private KeyAdapter createKeyListener(final JTable table) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                int row = table.getSelectedRow();
                if (row >= 0 && (event.getKeyCode() == 37 || event.getKeyCode() == 39)) {
                    ((RowElement)JavaeeSectionView.this.items.get(row)).handleLeftRight(event.getKeyCode() == 39);
                }
            }
        };
    }

    private DefaultTableCellRenderer createHeaderRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
                super.getTableCellRendererComponent(table, value, selected, focus, row, col);
                this.setBorder(null);
                return this;
            }
        };
    }

    private ColumnInfo<RowElement, ?>[] createColumnInfos() {
        this.mapped.clear();
        int num = 0;
        for (JavaeeSection<?> section : this.sections) {
            JavaeeSectionInfo<?>[] infos = section.createColumnInfos();
            this.mapped.put(section, infos);
            num = Math.max(num, infos.length);
        }
        ColumnInfo[] infos = new ColumnInfo[num + 1];
        infos[0] = this.createColumn();
        for (int i = 0; i < num; ++i) {
            infos[i + 1] = this.createColumn(i);
        }
        return infos;
    }

    private ColumnInfo<RowElement, Object> createColumn() {
        return new ColumnInfo<RowElement, Object>(null){

            @Nullable
            public Object valueOf(RowElement item) {
                return item;
            }

            public TableCellRenderer getRenderer(final RowElement item) {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
                        return item.getFirstComponent(table, selected, focus);
                    }
                };
            }
        };
    }

    private ColumnInfo<RowElement, String> createColumn(final int index) {
        return new ColumnInfo<RowElement, String>(null){

            @Nullable
            public String valueOf(RowElement item) {
                return item.getValue(index);
            }

            public void setValue(RowElement item, String value) {
                item.setValue(index, value);
            }

            public boolean isCellEditable(RowElement item) {
                return item.isEditable(index);
            }

            @Nullable
            public TableCellRenderer getRenderer(RowElement item) {
                return item.getRenderer(index);
            }

            @Nullable
            public TableCellEditor getEditor(RowElement item) {
                return item.getEditor(index);
            }
        };
    }

    private static Component createLabel(Icon icon) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new IconLabel(icon));
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/editor/JavaeeSectionView", "getColumnInfo"));
    }

    private static class IconLabel
    extends JLabel {
        private IconLabel(Icon icon) {
            super(icon);
        }
    }

    private class DomRowElement
    implements RowElement {
        private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        private final JavaeeSection<?> section;
        private final DomElement element;

        private DomRowElement(JavaeeSection<?> section, DomElement element) {
            this.section = section;
            this.element = element;
        }

        @Override
        @NotNull
        public JavaeeSection<?> getSection() {
            JavaeeSection<?> javaeeSection = this.section;
            if (javaeeSection == null) {
                DomRowElement.$$$reportNull$$$0(0);
            }
            return javaeeSection;
        }

        @Override
        @Nullable
        public Object getElement() {
            return this.element;
        }

        @Override
        public void handleDoubleClick() {
        }

        @Override
        public void handleLeftRight(boolean right) {
        }

        @Override
        public Component getFirstComponent(JTable table, boolean selected, boolean focus) {
            return this.renderer.getTableCellRendererComponent(table, null, selected, focus, 0, 0);
        }

        @Override
        @Nullable
        public String getValue(int column) {
            return (String)JavaeeSectionView.this.getColumnInfo(this.section, column).valueOf(this.element);
        }

        @Override
        public void setValue(int column, String value) {
            JavaeeSectionView.this.getColumnInfo(this.section, column).setValue(this.element, value);
        }

        @Override
        public boolean isEditable(int column) {
            return JavaeeSectionView.this.getColumnInfo(this.section, column).isCellEditable(this.element);
        }

        @Override
        @Nullable
        public TableCellRenderer getRenderer(int column) {
            return JavaeeSectionView.this.getColumnInfo(this.section, column).getRenderer(this.element);
        }

        @Override
        @Nullable
        public TableCellEditor getEditor(int column) {
            return JavaeeSectionView.this.getColumnInfo(this.section, column).getEditor(this.element);
        }

        @Override
        @NotNull
        public JComponent decorate(JComponent component, JTable table, int column, boolean selected) {
            Border border = BorderFactory.createEmptyBorder(0, 5, 0, column == 0 || column == 2 ? 5 : 0);
            if (column > 0) {
                border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, table.getGridColor()), border);
            }
            component.setBorder(border);
            JComponent jComponent = component;
            if (jComponent == null) {
                DomRowElement.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DomRowElement) {
                DomRowElement other = (DomRowElement)obj;
                return this.section.equals(other.getSection()) && this.element.equals(other.getElement());
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.section.hashCode() + this.element.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/javaee/oss/editor/JavaeeSectionView$DomRowElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorate";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class SectionRowElement
    implements RowElement {
        private final JavaeeSection<?> section;

        private SectionRowElement(JavaeeSection<?> section) {
            this.section = section;
        }

        @Override
        @NotNull
        public JavaeeSection<?> getSection() {
            JavaeeSection<?> javaeeSection = this.section;
            if (javaeeSection == null) {
                SectionRowElement.$$$reportNull$$$0(0);
            }
            return javaeeSection;
        }

        @Override
        @Nullable
        public Object getElement() {
            return null;
        }

        @Override
        public void handleDoubleClick() {
            if (JavaeeSectionView.this.expanded.remove(this.section) || JavaeeSectionView.this.expanded.add(this.section)) {
                JavaeeSectionView.this.reset();
            }
        }

        @Override
        public void handleLeftRight(boolean right) {
            if (right && JavaeeSectionView.this.expanded.add(this.section)) {
                JavaeeSectionView.this.reset();
            } else if (!right && JavaeeSectionView.this.expanded.remove(this.section)) {
                JavaeeSectionView.this.reset();
            }
        }

        @Override
        public Component getFirstComponent(JTable table, boolean selected, boolean focus) {
            return JavaeeSectionView.this.expanded.contains(this.section) ? EXPANDED_ICON : COLLAPSED_ICON;
        }

        @Override
        @Nullable
        public String getValue(int column) {
            return column == 0 || JavaeeSectionView.this.expanded.contains(this.section) ? JavaeeSectionView.this.getColumnInfo(this.section, column).getName() : null;
        }

        @Override
        public void setValue(int column, String value) {
        }

        @Override
        public boolean isEditable(int column) {
            return false;
        }

        @Override
        @Nullable
        public TableCellRenderer getRenderer(int column) {
            return null;
        }

        @Override
        @Nullable
        public TableCellEditor getEditor(int column) {
            return null;
        }

        @Override
        @NotNull
        public JComponent decorate(JComponent component, JTable table, int column, boolean selected) {
            Border border = BorderFactory.createEmptyBorder(0, 5, 0, column == 0 || column == 2 ? 5 : 0);
            Color background = selected ? StripeTableCellRenderer.darken((Color)table.getSelectionBackground()) : new Color(table.getTableHeader().getBackground().getRGB());
            component.setBackground(background);
            border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, background.darker()), border);
            if (JavaeeSectionView.this.expanded.contains(this.section)) {
                if (column > 1) {
                    border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, background.brighter()), border);
                }
                if (column > 0) {
                    border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, table.getGridColor()), border);
                }
            }
            component.setFont(component.getFont().deriveFont(1));
            component.setBorder(border);
            JComponent jComponent = component;
            if (jComponent == null) {
                SectionRowElement.$$$reportNull$$$0(1);
            }
            return jComponent;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SectionRowElement) {
                SectionRowElement other = (SectionRowElement)obj;
                return this.section.equals(other.getSection());
            }
            return false;
        }

        public int hashCode() {
            return this.section.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/javaee/oss/editor/JavaeeSectionView$SectionRowElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorate";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static interface RowElement {
        @NotNull
        public JavaeeSection<?> getSection();

        @Nullable
        public Object getElement();

        public void handleDoubleClick();

        public void handleLeftRight(boolean var1);

        public Component getFirstComponent(JTable var1, boolean var2, boolean var3);

        @Nullable
        public String getValue(int var1);

        public void setValue(int var1, String var2);

        public boolean isEditable(int var1);

        @Nullable
        public TableCellRenderer getRenderer(int var1);

        @Nullable
        public TableCellEditor getEditor(int var1);

        @NotNull
        public JComponent decorate(JComponent var1, JTable var2, int var3, boolean var4);
    }

    private class SectionTableView
    extends AbstractTableView<RowElement> {
        SectionTableView(Project project, String empty) {
            super(project, empty, null);
        }

        protected void adjustColumnWidths() {
            super.adjustColumnWidths();
            TableColumnModel model = this.getTable().getColumnModel();
            if (model.getColumnCount() > 0) {
                TableColumn column = model.getColumn(0);
                column.setMinWidth(column.getPreferredWidth());
                column.setMaxWidth(column.getPreferredWidth());
            }
        }

        protected void wrapValueSetting(@NotNull RowElement item, Runnable setter) {
            Object value;
            if (item == null) {
                SectionTableView.$$$reportNull$$$0(0);
            }
            if ((value = item.getElement()) instanceof DomElement && ((DomElement)value).isValid()) {
                setter.run();
                this.fireChanged();
            }
        }

        protected TableCellRenderer getTableCellRenderer(int row, int col, final TableCellRenderer renderer, Object value) {
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row, int col) {
                    Component component = renderer.getTableCellRendererComponent(table, value, selected, focus, row, col);
                    return ((RowElement)JavaeeSectionView.this.items.get(row)).decorate((JComponent)component, table, col, selected);
                }
            };
        }

        void initialize() {
            this.initializeTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/javaee/oss/editor/JavaeeSectionView$SectionTableView", "wrapValueSetting"));
        }
    }
}

