/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.cloud.server.config;

import com.intellij.javaee.oss.cloud.server.config.CloudConfigEditor;
import com.intellij.javaee.oss.cloud.server.config.TableItemEditor;
import com.intellij.javaee.oss.util.Column;
import com.intellij.javaee.oss.util.JTableWrapper;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableConfigEditor<T, D, R, C extends Column<R>, I, E extends TableItemEditor<I>>
extends CloudConfigEditor<T, D> {
    private JBTable myTable;
    private final JTableWrapper<R, C> myTableWrapper;
    private Project myProject;
    private D myDomain;
    private List<R> myRows;

    public TableConfigEditor(C[] columns) {
        this.myTableWrapper = new JTableWrapper(this.getTable(), columns);
        this.myRows = new ArrayList<R>();
    }

    private JBTable getTable() {
        if (this.myTable == null) {
            this.myTable = new JBTable();
        }
        return this.myTable;
    }

    @Override
    public void init(Project project, D domain) {
        this.myProject = project;
        this.myDomain = domain;
    }

    protected void resetEditorFrom(@NotNull T model) {
        if (model == null) {
            TableConfigEditor.$$$reportNull$$$0(0);
        }
        this.myRows = new ArrayList<R>();
        this.doResetEditorFrom(model, this.myRows);
        this.updateTable();
    }

    protected abstract void doResetEditorFrom(T var1, List<R> var2);

    protected void applyEditorTo(@NotNull T model) throws ConfigurationException {
        if (model == null) {
            TableConfigEditor.$$$reportNull$$$0(1);
        }
        this.doApplyEditorTo(model, this.myRows);
    }

    protected abstract void doApplyEditorTo(T var1, List<R> var2) throws ConfigurationException;

    protected final JPanel createTablePanel() {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.getTable());
        if (this.isAddRemoveAllowed()) {
            toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    TableConfigEditor.this.addRow();
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    TableConfigEditor.this.removeRow();
                }
            });
        }
        this.customizeTableToolbar(toolbarDecorator);
        return toolbarDecorator.createPanel();
    }

    protected void customizeTableToolbar(ToolbarDecorator toolbarDecorator) {
    }

    protected boolean isAddRemoveAllowed() {
        return true;
    }

    private void addRow() {
        E itemEditor = this.createItemEditor(this.myDomain);
        DialogWrapper dialog = new DialogWrapper(this.myProject, (TableItemEditor)itemEditor){
            final /* synthetic */ TableItemEditor val$itemEditor;
            {
                this.val$itemEditor = tableItemEditor;
                super(arg0);
                this.setTitle(this.val$itemEditor.getTitle());
                this.init();
            }

            protected JComponent createCenterPanel() {
                return this.val$itemEditor.getMainPanel();
            }

            protected void doOKAction() {
                Object newItem;
                try {
                    newItem = this.val$itemEditor.createNewItem();
                }
                catch (ConfigurationException ex) {
                    this.setErrorText(ex.getMessage(), this.val$itemEditor.getMainPanel());
                    return;
                }
                super.doOKAction();
                TableConfigEditor.this.myRows.add(TableConfigEditor.this.wrapItem2Row(newItem));
                TableConfigEditor.this.updateTable();
                int selectedIndex = TableConfigEditor.this.myRows.size() - 1;
                TableConfigEditor.this.myTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
            }
        };
        dialog.show();
    }

    private void removeRow() {
        int selectedIndex = this.myTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        this.myRows.remove(selectedIndex);
        this.updateTable();
    }

    private void updateTable() {
        this.myTableWrapper.setInputRows(this.myRows);
    }

    @Nullable
    protected final R getSelectedRow() {
        int selectedIndex = this.myTable.getSelectedRow();
        if (selectedIndex == -1) {
            return null;
        }
        return this.myRows.get(selectedIndex);
    }

    protected abstract E createItemEditor(D var1);

    protected abstract R wrapItem2Row(I var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "model";
        objectArray2[1] = "com/intellij/javaee/oss/cloud/server/config/TableConfigEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

