/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.actions;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.generation.actions.GenerateInterceptorMethods;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.j2ee.JavaeeDataContextWrapper;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.Interceptor;
import com.intellij.javaee.module.view.JavaeeAbstractAction;
import com.intellij.javaee.module.view.ejb.InterceptorBindingsDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaeeIcons;
import org.jetbrains.annotations.NotNull;

public class CreateInterceptorAction
extends JavaeeAbstractAction {
    public CreateInterceptorAction() {
        super(J2EEBundle.message((String)"action.name.create.interceptor", (Object[])new Object[0]), "", JavaeeIcons.EJB_INTERCEPTOR_CLASS_ICON);
    }

    protected boolean isActive(@NotNull AnActionEvent e) {
        JavaeeDataContextWrapper dataContextWrapper;
        if (e == null) {
            CreateInterceptorAction.$$$reportNull$$$0(0);
        }
        if (!(dataContextWrapper = new JavaeeDataContextWrapper(e)).canCreateSomething(EjbFacet.ID)) {
            return false;
        }
        EjbFacet ejbFacet = (EjbFacet)dataContextWrapper.getFacet(EjbFacet.ID);
        return ejbFacet != null && EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)EjbUtil.getVersion(ejbFacet)) <= 0;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JavaeeDataContextWrapper dataContextWrapper;
        EjbFacet ejbFacet;
        if (e == null) {
            CreateInterceptorAction.$$$reportNull$$$0(1);
        }
        if ((ejbFacet = (EjbFacet)(dataContextWrapper = new JavaeeDataContextWrapper(e)).getFacet(EjbFacet.ID)) == null) {
            return;
        }
        Project project = ejbFacet.getModule().getProject();
        PsiClass psiClass = this.createInterceptorClass(ejbFacet.getModule());
        if (psiClass != null) {
            String psiClassQName = psiClass.getQualifiedName();
            CreateInterceptorAction.createInterceptorMetadata(ejbFacet.getXmlRoot(), psiClassQName);
            Editor editor1 = CodeInsightUtil.positionCursorAtLBrace((Project)project, (PsiFile)psiClass.getContainingFile(), (PsiClass)psiClass);
            if (editor1 != null) {
                new GenerateInterceptorMethods().actionPerformedImpl(project, editor1);
            }
            InterceptorBindingsDialog interceptorDialog = new InterceptorBindingsDialog(project, psiClassQName, ejbFacet);
            interceptorDialog.show();
        }
    }

    public static void createInterceptorMetadata(EjbJar ejbJar, String interceptorClassName) {
        if (ejbJar == null || !CommonRefactoringUtil.checkReadOnlyStatus((Project)ejbJar.getPsiManager().getProject(), (PsiElement)ejbJar.getXmlTag())) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)ejbJar.getPsiManager().getProject()).run(() -> {
            Interceptor interceptor = ejbJar.getInterceptors().addInterceptor();
            interceptor.getInterceptorClass().setStringValue(interceptorClassName);
        });
    }

    private PsiClass createInterceptorClass(Module module) {
        Project project = module.getProject();
        CreateClassDialog dialog = new CreateClassDialog(project, J2EEBundle.message((String)"dialog.title.new.typename", (Object[])new Object[]{J2EEBundle.message((String)"ejb.interceptor.type", (Object[])new Object[0])}), "", "", (ClassKind)CreateClassKind.CLASS, true, module);
        if (!dialog.showAndGet()) {
            return null;
        }
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        PsiClass targetClass = (PsiClass)WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
            try {
                return JavaDirectoryService.getInstance().createClass(targetDirectory, dialog.getClassName());
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]), (String)CreateInterceptorAction.filterMessage(e.getMessage())));
                return null;
            }
        });
        return targetClass;
    }

    protected static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart((String)message, (String)"java.io.IOException:");
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/javaee/module/view/ejb/actions/CreateInterceptorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

