/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb;

import com.intellij.javaee.EjbDataHolder;
import com.intellij.javaee.EjbType;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.javaee.module.view.ejb.ejbLevel.EjbClassesPropertiesPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.JComponent;

public class CreateNewEjbDialog
extends DialogWrapper {
    private final EjbDataHolder myEjbInfo;
    private final EjbClassesPropertiesPanel myEjbClassesPropertiesPanel;

    public CreateNewEjbDialog(Project project, EjbDataHolder ejbInfo, EjbFacet ejbFacet) {
        super(project, true);
        this.myEjbInfo = ejbInfo;
        this.myEjbClassesPropertiesPanel = new EjbClassesPropertiesPanel(ejbFacet.getMergedRoot(), this.myEjbInfo, project, true, true){

            @Override
            protected void updateOKAction() {
                CreateNewEjbDialog.this.setOKActionEnabled(this.isOKActionEnabled());
            }
        };
        this.setTitle(J2EEBundle.message((String)"dialog.title.new.typename", (Object[])new Object[]{this.getCreatedTypeName()}));
        this.init();
    }

    private String getCreatedTypeName() {
        switch (this.myEjbInfo.getEjbType()) {
            case Entity: {
                if (this.myEjbInfo.getPersistenceType() == PersistenceType.BEAN) {
                    return J2EEBundle.message((String)"ejb.type.bmp.entity.bean", (Object[])new Object[0]);
                }
                if (this.myEjbInfo.getPersistenceType() == PersistenceType.CONTAINER) {
                    return J2EEBundle.message((String)"ejb.type.cmp.entity.bean", (Object[])new Object[0]);
                }
                return J2EEBundle.message((String)"ejb.type.entity.bean", (Object[])new Object[0]);
            }
            case Session: {
                if (this.myEjbInfo.getSessionType() == SessionType.STATEFUL) {
                    return J2EEBundle.message((String)"ejb.type.stateful.bean", (Object[])new Object[0]);
                }
                if (this.myEjbInfo.getSessionType() == SessionType.STATELESS) {
                    return J2EEBundle.message((String)"ejb.type.stateless.bean", (Object[])new Object[0]);
                }
                if (this.myEjbInfo.getSessionType() == SessionType.SINGLETON) {
                    return J2EEBundle.message((String)"ejb.type.singleton.bean", (Object[])new Object[0]);
                }
                return J2EEBundle.message((String)"ejb.type.session.bean", (Object[])new Object[0]);
            }
        }
        return J2EEBundle.message((String)"ejb.type.message.bean", (Object[])new Object[0]);
    }

    protected String getHelpId() {
        if (this.myEjbInfo.getEjbType() == EjbType.Message) {
            return "reference.javaee.new-message-bean";
        }
        if (this.myEjbInfo.getEjbType() == EjbType.Session) {
            return "reference.javaee.new-session-bean";
        }
        if (this.myEjbInfo.getPersistenceType() == PersistenceType.BEAN) {
            return "reference.javaee.new-bmp-bean";
        }
        return "reference.javaee.new-cmp-bean";
    }

    protected void doOKAction() {
        this.myEjbClassesPropertiesPanel.saveEjbInfo();
        if (this.myEjbClassesPropertiesPanel.isDataValid()) {
            super.doOKAction();
        }
    }

    public EjbDataHolder getEjbInfo() {
        return this.myEjbInfo;
    }

    protected JComponent createCenterPanel() {
        return this.myEjbClassesPropertiesPanel.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEjbClassesPropertiesPanel.getPreferredFocusedComponent();
    }
}

