/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.framework;

import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfiguration;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaeeFrameworkDetector<F extends JavaeeFacet, C extends JavaeeFacetConfiguration>
extends FacetBasedFrameworkDetector<F, C> {
    protected JavaeeFrameworkDetector(@NotNull String detectorId) {
        if (detectorId == null) {
            JavaeeFrameworkDetector.$$$reportNull$$$0(0);
        }
        super(detectorId);
    }

    protected void setupConfiguration(C configuration, VirtualFile file) {
    }

    @NotNull
    public abstract JavaeeFacetType<F, C> getFacetType();

    @NotNull
    public List<Pair<C, Collection<VirtualFile>>> createConfigurations(@NotNull Collection<VirtualFile> files, @NotNull Collection<C> existentFacetConfigurations) {
        if (files == null) {
            JavaeeFrameworkDetector.$$$reportNull$$$0(1);
        }
        if (existentFacetConfigurations == null) {
            JavaeeFrameworkDetector.$$$reportNull$$$0(2);
        }
        ArrayList<Pair<C, Collection<VirtualFile>>> result = new ArrayList<Pair<C, Collection<VirtualFile>>>();
        FacetType facetType = this.getFacetType();
        block0: for (VirtualFile file : files) {
            ConfigFileMetaData descriptorMetaData = facetType.getMainDescriptorMetaData();
            for (JavaeeFacetConfiguration configuration : existentFacetConfigurations) {
                ConfigFileInfo configFile = configuration.getDescriptorsConfiguration().getConfigFileInfo(descriptorMetaData);
                if (configFile == null || !configFile.getUrl().equals(file.getUrl())) continue;
                continue block0;
            }
            JavaeeFacetConfiguration configuration = (JavaeeFacetConfiguration)facetType.createDefaultConfiguration();
            configuration.getDescriptorsConfiguration().addConfigFile(descriptorMetaData, file.getUrl());
            this.setupConfiguration(configuration, file);
            result.add(Pair.create((Object)configuration, Collections.singletonList(file)));
        }
        ArrayList<Pair<C, Collection<VirtualFile>>> arrayList = result;
        if (arrayList == null) {
            JavaeeFrameworkDetector.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.XML;
        if (languageFileType == null) {
            JavaeeFrameworkDetector.$$$reportNull$$$0(4);
        }
        return languageFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existentFacetConfigurations";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/framework/JavaeeFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/framework/JavaeeFrameworkDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurations";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

