/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.ui.packaging.JavaeeFacetClassesPackagingElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeFrameworkSupportProvider<F extends JavaeeFacet>
extends FacetBasedFrameworkSupportProvider<F> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.facet.JavaeeFrameworkSupportProvider");
    private final ConfigFileMetaData myMetaData;
    private final String myRelativeDescriptorBaseDir;
    private final JavaeeFacetType<F, ?> myFacetType;

    protected JavaeeFrameworkSupportProvider(JavaeeFacetType<F, ?> facetType, ConfigFileMetaData metaData, @NotNull @NonNls String relativeDescriptorBaseDir) {
        if (relativeDescriptorBaseDir == null) {
            JavaeeFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        super(facetType);
        this.myFacetType = facetType;
        this.myMetaData = metaData;
        this.myRelativeDescriptorBaseDir = relativeDescriptorBaseDir;
        LOG.assertTrue(this.myRelativeDescriptorBaseDir.length() == 0 || this.myRelativeDescriptorBaseDir.startsWith("/"));
    }

    @NotNull
    public String[] getProjectCategories() {
        String[] stringArray = new String[]{JavaeeUtil.JAVAEE_FRAMEWORK_GROUP};
        if (stringArray == null) {
            JavaeeFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            JavaeeFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        if (facetsProvider == null) {
            JavaeeFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        if (super.isSupportAlreadyAdded(module, facetsProvider)) {
            return true;
        }
        String url = this.getDescriptorUrl((ModuleRootModel)ModuleRootManager.getInstance((Module)module));
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        return file != null;
    }

    protected void setupConfiguration(F facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        ConfigFileVersion configFileVersion = this.getVersionToCreate(version.getVersionName());
        if (configFileVersion != null) {
            facet.getDescriptorsContainer().getConfiguration().replaceConfigFile(this.myMetaData, this.getDescriptorUrl((ModuleRootModel)rootModel));
        }
    }

    protected void onFacetCreated(F facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        ConfigFileVersion configFileVersion = this.getVersionToCreate(version.getVersionName());
        if (configFileVersion != null) {
            ConfigFileFactory.getInstance().createFile(null, this.getDescriptorUrl((ModuleRootModel)rootModel), configFileVersion, true);
        }
    }

    private String getDescriptorUrl(ModuleRootModel rootModel) {
        return rootModel.getContentRootUrls()[0] + this.myRelativeDescriptorBaseDir + "/" + this.myMetaData.getDirectoryPath() + "/" + this.myMetaData.getFileName();
    }

    @Nullable
    protected ConfigFileVersion getVersionToCreate(String versionString) {
        for (ConfigFileVersion version : this.myMetaData.getVersions()) {
            if (!version.getName().equals(versionString)) continue;
            return version;
        }
        return null;
    }

    @NotNull
    public List<FrameworkVersion> getVersions() {
        ArrayList<FrameworkVersion> result = new ArrayList<FrameworkVersion>();
        for (ConfigFileVersion version : this.myMetaData.getVersions()) {
            String versionName = version.getName();
            JavaeeVersion javaeeVersion = this.getJavaeeVersion(versionName);
            boolean isDefault = version.equals(this.myMetaData.getDefaultVersion());
            FrameworkVersion frameworkVersion = javaeeVersion != null ? new FrameworkVersion(versionName, javaeeVersion.getPresentableName(), JavaeeLibrariesUtil.getJavaeeLibraryInfos(javaeeVersion), isDefault) : new FrameworkVersion(versionName, isDefault);
            result.add(frameworkVersion);
        }
        ArrayList<FrameworkVersion> arrayList = result;
        if (arrayList == null) {
            JavaeeFrameworkSupportProvider.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    protected JavaeeVersion getJavaeeVersion(String selectedVersion) {
        return null;
    }

    protected void createFiles(F facet, JavaeeFrameworkSupportInfoCollector collector) {
    }

    protected Artifact createJavaeeArtifact(JavaeeFacet facet) {
        Module module = facet.getModule();
        Project project = module.getProject();
        ArtifactRootElement root = PackagingElementFactory.getInstance().createArtifactRootElement();
        root.addOrFindChild(JavaeeArtifactUtil.getInstance().createFacetResourcesElement(facet));
        this.addPackagingElements(facet, (CompositePackagingElement<?>)root);
        String artifactName = JavaeeUtil.suggestArtifactName(module.getName(), null, (FacetTypeId<? extends JavaeeFacet>)this.myFacetType.getId());
        return ArtifactManager.getInstance((Project)project).addArtifact(artifactName, (ArtifactType)this.getExplodedArtifactType(), (CompositePackagingElement)root);
    }

    protected void addPackagingElements(JavaeeFacet facet, CompositePackagingElement<?> root) {
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)facet.getModule().getProject()).getResolvingContext();
        PackagingElement<?> classesElement = JavaeeFacetClassesPackagingElement.createPackagingElementForFacetClasses(facet, context);
        factory.getOrCreateDirectory(root, this.myFacetType.getDefaultUriForDirectory()).addOrFindChild(classesElement);
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            JavaeeFrameworkSupportProvider.$$$reportNull$$$0(5);
        }
        JavaeeFrameworkSupportConfigurable javaeeFrameworkSupportConfigurable = new JavaeeFrameworkSupportConfigurable((FrameworkSupportProviderBase)this, model, this.getVersions(), this.getVersionLabelText());
        if (javaeeFrameworkSupportConfigurable == null) {
            JavaeeFrameworkSupportProvider.$$$reportNull$$$0(6);
        }
        return javaeeFrameworkSupportConfigurable;
    }

    protected abstract JavaeeArtifactTypeBase getExplodedArtifactType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeDescriptorBaseDir";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/facet/JavaeeFrameworkSupportProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/facet/JavaeeFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectCategories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportAlreadyAdded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class JavaeeFrameworkSupportConfigurable
    extends FrameworkSupportConfigurableBase {
        public JavaeeFrameworkSupportConfigurable(FrameworkSupportProviderBase frameworkSupportProvider, FrameworkSupportModel model, List<FrameworkVersion> versions, String versionLabelText) {
            super(frameworkSupportProvider, model, versions, versionLabelText);
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
            if (module == null) {
                JavaeeFrameworkSupportConfigurable.$$$reportNull$$$0(0);
            }
            if (rootModel == null) {
                JavaeeFrameworkSupportConfigurable.$$$reportNull$$$0(1);
            }
            FrameworkVersion version = this.getSelectedVersion();
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            if (!facetManager.getFacetsByType(JavaeeFrameworkSupportProvider.this.myFacetType.getId()).isEmpty()) {
                return;
            }
            ModifiableFacetModel model = facetManager.createModifiableModel();
            JavaeeFacet facet = (JavaeeFacet)facetManager.createFacet((FacetType)JavaeeFrameworkSupportProvider.this.myFacetType, JavaeeFrameworkSupportProvider.this.myFacetType.getDefaultFacetName(), null);
            JavaeeFrameworkSupportProvider.this.setupConfiguration(facet, rootModel, version);
            model.addFacet((Facet)facet);
            model.commit();
            JavaeeFrameworkSupportInfoCollector collector = JavaeeFrameworkSupportInfoCollector.getOrCreateCollector((FrameworkSupportModel)this.myFrameworkSupportModel);
            collector.setFacet(JavaeeFrameworkSupportProvider.this.myFacetType.getId(), (Facet)facet);
            collector.setArtifact((ArtifactType)JavaeeFrameworkSupportProvider.this.getExplodedArtifactType(), JavaeeFrameworkSupportProvider.this.createJavaeeArtifact(facet));
            JavaeeFrameworkSupportProvider.this.createFiles(facet, collector);
            JavaeeFrameworkSupportProvider.this.onFacetCreated(facet, rootModel, version);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootModel";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javaee/facet/JavaeeFrameworkSupportProvider$JavaeeFrameworkSupportConfigurable";
            objectArray[2] = "addSupport";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

